/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.plugins;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.analyzer.Analyzer;
import org.apache.tez.analyzer.CSVResult;
import org.apache.tez.analyzer.Result;
import org.apache.tez.analyzer.plugins.TezAnalyzerBase;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.EdgeInfo;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.TaskInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneOnOneEdgeAnalyzer
extends TezAnalyzerBase
implements Analyzer {
    private static final Logger LOG = LoggerFactory.getLogger(OneOnOneEdgeAnalyzer.class);
    private final String[] headers = new String[]{"sourceVertex", "downstreamVertex", "srcTaskId", "srcContainerHost", "destContainerHost"};
    private static final String ONE_TO_ONE = "ONE_TO_ONE";
    private final CSVResult csvResult = new CSVResult(this.headers);

    public OneOnOneEdgeAnalyzer(Configuration config) {
        super(config);
    }

    @Override
    public void analyze(DagInfo dagInfo) throws TezException {
        for (VertexInfo v : dagInfo.getVertices()) {
            for (EdgeInfo e : v.getOutputEdges()) {
                if (e.getDataMovementType() == null || !e.getDataMovementType().equals(ONE_TO_ONE)) continue;
                LOG.info("Src --> Dest : {} --> {}", (Object)e.getSourceVertex(), (Object)e.getDestinationVertex());
                VertexInfo sourceVertex = e.getSourceVertex();
                VertexInfo destinationVertex = e.getDestinationVertex();
                Map<Integer, String> sourceTaskToContainerMap = this.getContainerMappingForVertex(sourceVertex);
                Map<Integer, String> downStreamTaskToContainerMap = this.getContainerMappingForVertex(destinationVertex);
                int missedCounter = 0;
                LinkedList result = Lists.newLinkedList();
                for (Map.Entry<Integer, String> entry : sourceTaskToContainerMap.entrySet()) {
                    Integer taskId = entry.getKey();
                    String sourceContainerHost = entry.getValue();
                    String downstreamContainerHost = downStreamTaskToContainerMap.get(taskId);
                    if (downstreamContainerHost != null && !sourceContainerHost.equalsIgnoreCase(downstreamContainerHost)) {
                        LOG.info("TaskID: {}, source: {}, downStream:{}", new Object[]{taskId, sourceContainerHost, downstreamContainerHost});
                        result.add(sourceVertex.getVertexName());
                        result.add(destinationVertex.getVertexName());
                        result.add(taskId + "");
                        result.add(sourceContainerHost);
                        result.add(downstreamContainerHost);
                        this.csvResult.addRecord(result.toArray(new String[result.size()]));
                        ++missedCounter;
                    }
                    result.clear();
                }
                LOG.info("Total tasks:{}, miss: {}", (Object)sourceTaskToContainerMap.size(), (Object)missedCounter);
            }
        }
    }

    private Map<Integer, String> getContainerMappingForVertex(VertexInfo vertexInfo) {
        HashMap taskToContainerMap = Maps.newHashMap();
        for (TaskInfo taskInfo : vertexInfo.getTasks()) {
            TezTaskAttemptID id;
            TaskAttemptInfo successfulAttempt = taskInfo.getSuccessfulTaskAttempt();
            if (successfulAttempt == null || (id = TezTaskAttemptID.fromString((String)successfulAttempt.getTaskAttemptId())) == null) continue;
            taskToContainerMap.put(id.getTaskID().getId(), successfulAttempt.getContainer().getHost());
        }
        return taskToContainerMap;
    }

    @Override
    public Result getResult() throws TezException {
        return this.csvResult;
    }

    @Override
    public String getName() {
        return "One-to-One edge analyzer";
    }

    @Override
    public String getDescription() {
        return "To understand the locality miss in 1:1 edge";
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        OneOnOneEdgeAnalyzer analyzer = new OneOnOneEdgeAnalyzer(conf);
        int res = ToolRunner.run((Configuration)conf, (Tool)analyzer, (String[])args);
        System.exit(res);
    }
}

