/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.accesscontrol;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.beanutils.LazyDynaMap;
import org.owasp.esapi.reference.accesscontrol.policyloader.PolicyParameters;

public class DynaBeanACRParameter
implements PolicyParameters {
    protected LazyDynaMap policyProperties = new LazyDynaMap();

    @Override
    public Object get(String key) {
        return this.policyProperties.get(key);
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public byte getByte(String key) {
        return (Byte)this.get(key);
    }

    public char getChar(String key) {
        return ((Character)this.get(key)).charValue();
    }

    public int getInt(String key) {
        return (Integer)this.get(key);
    }

    public long getLong(String key) {
        return (Long)this.get(key);
    }

    public float getFloat(String key) {
        return ((Float)this.get(key)).floatValue();
    }

    public double getDouble(String key) {
        return (Double)this.get(key);
    }

    public BigDecimal getBigDecimal(String key) {
        return (BigDecimal)this.get(key);
    }

    public BigInteger getBigInteger(String key) {
        return (BigInteger)this.get(key);
    }

    public Date getDate(String key) {
        return (Date)this.get(key);
    }

    public Date getTime(String key) {
        return (Date)this.get(key);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public String getString(String key, String defaultValue) {
        return (String)this.get(key) == null ? defaultValue : (String)this.get(key);
    }

    public String[] getStringArray(String key) {
        return (String[])this.get(key);
    }

    public Object getObject(String key) {
        return this.get(key);
    }

    @Override
    public void set(String key, Object value) throws IllegalArgumentException {
        this.policyProperties.set(key, value);
    }

    @Override
    public void put(String key, Object value) throws IllegalArgumentException {
        this.set(key, value);
    }

    @Override
    public void lock() {
        this.policyProperties.setRestricted(true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> keys = this.policyProperties.getMap().keySet().iterator();
        while (keys.hasNext()) {
            String currentKey = keys.next();
            sb.append(currentKey);
            sb.append("=");
            sb.append(this.policyProperties.get(currentKey));
            if (!keys.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

