/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlethelpers.internalrequests;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.servlethelpers.internalrequests.JakartaInternalRequest;
import org.jetbrains.annotations.NotNull;

public class JakartaServletInternalRequest
extends JakartaInternalRequest {
    protected final ServletResolver servletResolver;
    private final Resource resource;

    public JakartaServletInternalRequest(@NotNull ServletResolver servletResolver, @NotNull Resource resource) {
        super(resource.getResourceResolver(), resource.getPath());
        this.checkNotNull(ServletResolver.class, (Object)servletResolver);
        this.checkNotNull(Resource.class, (Object)resource);
        this.resource = resource;
        this.servletResolver = servletResolver;
    }

    public String toString() {
        return String.format("%s: %s P=%s S=%s EXT=%s RT=%s(%s)", this.getClass().getSimpleName(), this.requestMethod, this.resource.getPath(), this.selectorString, this.extension, this.resource.getResourceType(), this.resource.getResourceSuperType());
    }

    @Override
    protected Resource getExecutionResource() {
        return this.resource;
    }

    @Override
    protected void delegateExecute(SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response, ResourceResolver resourceResolver) throws ServletException, IOException {
        Servlet s = this.servletResolver.resolve(request);
        this.log.debug("ServletResolver provides servlet '{}'", (Object)s);
        if (s == null) {
            response.sendError(404, "Servlet not found by " + this.getClass().getName());
        } else {
            s.service((ServletRequest)request, (ServletResponse)response);
        }
    }
}

