/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.producer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.producer.Producer;
import org.apache.rocketmq.client.apis.producer.ProducerBuilder;
import org.apache.rocketmq.client.apis.producer.TransactionChecker;
import org.apache.rocketmq.client.java.impl.producer.ProducerImpl;
import org.apache.rocketmq.client.java.message.MessageBuilderImpl;
import org.apache.rocketmq.shaded.com.google.common.base.Preconditions;

public class ProducerBuilderImpl
implements ProducerBuilder {
    private ClientConfiguration clientConfiguration = null;
    private final Set<String> topics = new HashSet<String>();
    private int maxAttempts = 3;
    private TransactionChecker checker = null;

    @Override
    public ProducerBuilder setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = Preconditions.checkNotNull(clientConfiguration, "clientConfiguration should not be null");
        return this;
    }

    @Override
    public ProducerBuilder setTopics(String ... topics) {
        Set set = Arrays.stream(topics).peek(topic -> Preconditions.checkNotNull(topic, "topic should not be null")).peek(topic -> Preconditions.checkArgument(MessageBuilderImpl.TOPIC_PATTERN.matcher((CharSequence)topic).matches(), "topic does not match the regex [regex=%s]", (Object)MessageBuilderImpl.TOPIC_PATTERN.pattern())).collect(Collectors.toSet());
        this.topics.addAll(set);
        return this;
    }

    @Override
    public ProducerBuilder setMaxAttempts(int maxAttempts) {
        Preconditions.checkArgument(maxAttempts > 0, "maxAttempts should be positive");
        this.maxAttempts = maxAttempts;
        return this;
    }

    @Override
    public ProducerBuilder setTransactionChecker(TransactionChecker checker) {
        this.checker = Preconditions.checkNotNull(checker, "checker should not set null");
        return this;
    }

    @Override
    public Producer build() {
        Preconditions.checkNotNull(this.clientConfiguration, "clientConfiguration has not been set yet");
        ProducerImpl producer = new ProducerImpl(this.clientConfiguration, this.topics, this.maxAttempts, this.checker);
        producer.startAsync().awaitRunning();
        return producer;
    }
}

