/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.topic;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.RocksDBConfigManager;
import org.apache.rocketmq.broker.topic.TopicConfigManager;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.remoting.protocol.DataVersion;

public class RocksDBTopicConfigManager
extends TopicConfigManager {
    protected RocksDBConfigManager rocksDBConfigManager;

    public RocksDBTopicConfigManager(BrokerController brokerController) {
        super(brokerController, false);
        this.rocksDBConfigManager = new RocksDBConfigManager(this.rocksdbConfigFilePath(), brokerController.getMessageStoreConfig().getMemTableFlushIntervalMs());
    }

    public boolean load() {
        if (!this.rocksDBConfigManager.init()) {
            return false;
        }
        if (!this.loadDataVersion() || !this.loadTopicConfig()) {
            return false;
        }
        this.init();
        return true;
    }

    public boolean loadTopicConfig() {
        return this.rocksDBConfigManager.loadData(this::decodeTopicConfig) && this.merge();
    }

    @Override
    public boolean loadDataVersion() {
        return this.rocksDBConfigManager.loadDataVersion();
    }

    private boolean merge() {
        if (!this.brokerController.getMessageStoreConfig().isTransferMetadataJsonToRocksdb()) {
            log.info("the switch transferMetadataJsonToRocksdb is off, no merge topic operation is needed.");
            return true;
        }
        if (!UtilAll.isPathExists((String)this.configFilePath()) && !UtilAll.isPathExists((String)(this.configFilePath() + ".bak"))) {
            log.info("topic json file does not exist, so skip merge");
            return true;
        }
        if (!super.loadDataVersion()) {
            log.error("load json topic dataVersion error, startup will exit");
            return false;
        }
        DataVersion dataVersion = super.getDataVersion();
        DataVersion kvDataVersion = this.getDataVersion();
        if (dataVersion.getCounter().get() > kvDataVersion.getCounter().get()) {
            if (!super.load()) {
                log.error("load topic config from json file error, startup will exit");
                return false;
            }
            ConcurrentMap<String, TopicConfig> topicConfigTable = this.getTopicConfigTable();
            for (Map.Entry entry : topicConfigTable.entrySet()) {
                this.putTopicConfig((TopicConfig)entry.getValue());
                log.info("import topic config to rocksdb, topic={}", entry.getValue());
            }
            this.getDataVersion().assignNewOne(dataVersion);
            this.updateDataVersion();
        } else {
            log.info("dataVersion is not greater than kvDataVersion, no need to merge topic metaData, dataVersion={}, kvDataVersion={}", (Object)dataVersion, (Object)kvDataVersion);
        }
        log.info("finish read topic config from json file and merge to rocksdb");
        this.persist();
        return true;
    }

    public boolean stop() {
        return this.rocksDBConfigManager.stop();
    }

    protected void decodeTopicConfig(byte[] key, byte[] body) {
        String topicName = new String(key, DataConverter.CHARSET_UTF8);
        TopicConfig topicConfig = (TopicConfig)JSON.parseObject((byte[])body, TopicConfig.class, (Feature[])new Feature[0]);
        this.topicConfigTable.put(topicName, topicConfig);
        log.info("load exist local topic, {}", (Object)topicConfig.toString());
    }

    @Override
    public TopicConfig putTopicConfig(TopicConfig topicConfig) {
        String topicName = topicConfig.getTopicName();
        TopicConfig oldTopicConfig = this.topicConfigTable.put(topicName, topicConfig);
        try {
            byte[] keyBytes = topicName.getBytes(DataConverter.CHARSET_UTF8);
            byte[] valueBytes = JSON.toJSONBytes((Object)topicConfig, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible});
            this.rocksDBConfigManager.put(keyBytes, keyBytes.length, valueBytes);
        }
        catch (Exception e) {
            log.error("kv put topic Failed, {}", (Object)topicConfig.toString(), (Object)e);
        }
        return oldTopicConfig;
    }

    @Override
    protected TopicConfig removeTopicConfig(String topicName) {
        TopicConfig topicConfig = (TopicConfig)this.topicConfigTable.remove(topicName);
        try {
            this.rocksDBConfigManager.delete(topicName.getBytes(DataConverter.CHARSET_UTF8));
        }
        catch (Exception e) {
            log.error("kv remove topic Failed, {}", (Object)topicConfig.toString());
        }
        return topicConfig;
    }

    public synchronized void persist() {
        if (this.brokerController.getMessageStoreConfig().isRealTimePersistRocksDBConfig()) {
            this.rocksDBConfigManager.flushWAL();
        }
    }

    public String rocksdbConfigFilePath() {
        return this.brokerController.getMessageStoreConfig().getStorePathRootDir() + File.separator + "config" + File.separator + "topics" + File.separator;
    }

    @Override
    public DataVersion getDataVersion() {
        return this.rocksDBConfigManager.getKvDataVersion();
    }

    @Override
    public void updateDataVersion() {
        try {
            this.rocksDBConfigManager.updateKvDataVersion();
        }
        catch (Exception e) {
            log.error("update topic config dataVersion error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

