/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import com.alibaba.fastjson.JSON;
import io.opentelemetry.api.common.Attributes;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.metrics.BrokerMetricsManager;
import org.apache.rocketmq.broker.metrics.PopMetricsManager;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.consumer.PullStatus;
import org.apache.rocketmq.common.KeyBuilder;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.PopAckConstants;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.AppendMessageStatus;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.pop.AckMsg;
import org.apache.rocketmq.store.pop.BatchAckMsg;
import org.apache.rocketmq.store.pop.PopCheckPoint;

public class PopReviveService
extends ServiceThread {
    private static final Logger POP_LOGGER = LoggerFactory.getLogger((String)"RocketmqPop");
    private final int[] ckRewriteIntervalsInSeconds = new int[]{10, 20, 30, 60, 120, 180, 240, 300, 360, 420, 480, 540, 600, 1200, 1800, 3600, 7200};
    private int queueId;
    private BrokerController brokerController;
    private String reviveTopic;
    private long currentReviveMessageTimestamp = -1L;
    private volatile boolean shouldRunPopRevive = false;
    private final NavigableMap<PopCheckPoint, Pair<Long, Boolean>> inflightReviveRequestMap = Collections.synchronizedNavigableMap(new TreeMap());
    private long reviveOffset;

    public PopReviveService(BrokerController brokerController, String reviveTopic, int queueId) {
        this.queueId = queueId;
        this.brokerController = brokerController;
        this.reviveTopic = reviveTopic;
        this.reviveOffset = brokerController.getConsumerOffsetManager().queryOffset("CID_RMQ_SYS_REVIVE_GROUP", reviveTopic, queueId);
    }

    public String getServiceName() {
        if (this.brokerController != null && this.brokerController.getBrokerConfig().isInBrokerContainer()) {
            return this.brokerController.getBrokerIdentity().getIdentifier() + "PopReviveService_" + this.queueId;
        }
        return "PopReviveService_" + this.queueId;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public void setShouldRunPopRevive(boolean shouldRunPopRevive) {
        this.shouldRunPopRevive = shouldRunPopRevive;
    }

    public boolean isShouldRunPopRevive() {
        return this.shouldRunPopRevive;
    }

    private boolean reviveRetry(PopCheckPoint popCheckPoint, MessageExt messageExt) {
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        if (!popCheckPoint.getTopic().startsWith("%RETRY%")) {
            msgInner.setTopic(KeyBuilder.buildPopRetryTopic((String)popCheckPoint.getTopic(), (String)popCheckPoint.getCId(), (boolean)this.brokerController.getBrokerConfig().isEnableRetryTopicV2()));
        } else {
            msgInner.setTopic(popCheckPoint.getTopic());
        }
        msgInner.setBody(messageExt.getBody());
        msgInner.setQueueId(0);
        if (messageExt.getTags() != null) {
            msgInner.setTags(messageExt.getTags());
        } else {
            MessageAccessor.setProperties((Message)msgInner, new HashMap());
        }
        msgInner.setBornTimestamp(messageExt.getBornTimestamp());
        msgInner.setFlag(messageExt.getFlag());
        msgInner.setSysFlag(messageExt.getSysFlag());
        msgInner.setBornHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setStoreHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setReconsumeTimes(messageExt.getReconsumeTimes() + 1);
        msgInner.getProperties().putAll(messageExt.getProperties());
        if (messageExt.getReconsumeTimes() == 0 || msgInner.getProperties().get("1ST_POP_TIME") == null) {
            msgInner.getProperties().put("1ST_POP_TIME", String.valueOf(popCheckPoint.getPopTime()));
        }
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        this.addRetryTopicIfNotExist(msgInner.getTopic(), popCheckPoint.getCId());
        PutMessageResult putMessageResult = this.brokerController.getEscapeBridge().putMessageToSpecificQueue(msgInner);
        PopMetricsManager.incPopReviveRetryMessageCount(popCheckPoint, putMessageResult.getPutMessageStatus());
        if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
            POP_LOGGER.info("reviveQueueId={},retry msg, ck={}, msg queueId {}, offset {}, reviveDelay={}, result is {} ", new Object[]{this.queueId, popCheckPoint, messageExt.getQueueId(), messageExt.getQueueOffset(), (System.currentTimeMillis() - popCheckPoint.getReviveTime()) / 1000L, putMessageResult});
        }
        if (putMessageResult.getAppendMessageResult() == null || putMessageResult.getAppendMessageResult().getStatus() != AppendMessageStatus.PUT_OK) {
            POP_LOGGER.error("reviveQueueId={}, revive error, msg is: {}", (Object)this.queueId, (Object)msgInner);
            return false;
        }
        this.brokerController.getPopInflightMessageCounter().decrementInFlightMessageNum(popCheckPoint);
        this.brokerController.getBrokerStatsManager().incBrokerPutNums(popCheckPoint.getTopic(), 1);
        this.brokerController.getBrokerStatsManager().incTopicPutNums(msgInner.getTopic());
        this.brokerController.getBrokerStatsManager().incTopicPutSize(msgInner.getTopic(), putMessageResult.getAppendMessageResult().getWroteBytes());
        return true;
    }

    private void initPopRetryOffset(String topic, String consumerGroup) {
        long offset = this.brokerController.getConsumerOffsetManager().queryOffset(consumerGroup, topic, 0);
        if (offset < 0L) {
            this.brokerController.getConsumerOffsetManager().commitOffset("initPopRetryOffset", consumerGroup, topic, 0, 0L);
        }
    }

    public void addRetryTopicIfNotExist(String topic, String consumerGroup) {
        if (this.brokerController != null) {
            TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(topic);
            if (topicConfig != null) {
                return;
            }
            topicConfig = new TopicConfig(topic);
            topicConfig.setReadQueueNums(PopAckConstants.retryQueueNum);
            topicConfig.setWriteQueueNums(PopAckConstants.retryQueueNum);
            topicConfig.setTopicFilterType(TopicFilterType.SINGLE_TAG);
            topicConfig.setPerm(6);
            topicConfig.setTopicSysFlag(0);
            this.brokerController.getTopicConfigManager().updateTopicConfig(topicConfig);
            this.initPopRetryOffset(topic, consumerGroup);
        }
    }

    protected List<MessageExt> getReviveMessage(long offset, int queueId) {
        PullResult pullResult = this.getMessage("CID_RMQ_SYS_REVIVE_GROUP", this.reviveTopic, queueId, offset, 32, true);
        if (pullResult == null) {
            return null;
        }
        if (this.reachTail(pullResult, offset)) {
            if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                POP_LOGGER.info("reviveQueueId={}, reach tail,offset {}", (Object)queueId, (Object)offset);
            }
        } else if (pullResult.getPullStatus() == PullStatus.OFFSET_ILLEGAL || pullResult.getPullStatus() == PullStatus.NO_MATCHED_MSG) {
            POP_LOGGER.error("reviveQueueId={}, OFFSET_ILLEGAL {}, result is {}", new Object[]{queueId, offset, pullResult});
            if (!this.shouldRunPopRevive) {
                POP_LOGGER.info("slave skip offset correct topic={}, reviveQueueId={}", (Object)this.reviveTopic, (Object)queueId);
                return null;
            }
            this.brokerController.getConsumerOffsetManager().commitOffset("127.0.0.1", "CID_RMQ_SYS_REVIVE_GROUP", this.reviveTopic, queueId, pullResult.getNextBeginOffset() - 1L);
        }
        return pullResult.getMsgFoundList();
    }

    private boolean reachTail(PullResult pullResult, long offset) {
        return pullResult.getPullStatus() == PullStatus.NO_NEW_MSG || pullResult.getPullStatus() == PullStatus.OFFSET_ILLEGAL && offset == pullResult.getMaxOffset();
    }

    public CompletableFuture<Triple<MessageExt, String, Boolean>> getBizMessage(PopCheckPoint popCheckPoint, long offset) {
        return this.brokerController.getEscapeBridge().getMessageAsync(popCheckPoint.getTopic(), offset, popCheckPoint.getQueueId(), popCheckPoint.getBrokerName(), false);
    }

    public PullResult getMessage(String group, String topic, int queueId, long offset, int nums, boolean deCompressBody) {
        GetMessageResult getMessageResult = this.brokerController.getMessageStore().getMessage(group, topic, queueId, offset, nums, null);
        if (getMessageResult != null) {
            PullStatus pullStatus = PullStatus.NO_NEW_MSG;
            List<MessageExt> foundList = null;
            switch (getMessageResult.getStatus()) {
                case FOUND: {
                    pullStatus = PullStatus.FOUND;
                    foundList = this.decodeMsgList(getMessageResult, deCompressBody);
                    this.brokerController.getBrokerStatsManager().incGroupGetNums(group, topic, getMessageResult.getMessageCount());
                    this.brokerController.getBrokerStatsManager().incGroupGetSize(group, topic, getMessageResult.getBufferTotalSize());
                    this.brokerController.getBrokerStatsManager().incBrokerGetNums(topic, getMessageResult.getMessageCount());
                    this.brokerController.getBrokerStatsManager().recordDiskFallBehindTime(group, topic, queueId, this.brokerController.getMessageStore().now() - foundList.get(foundList.size() - 1).getStoreTimestamp());
                    Attributes attributes = BrokerMetricsManager.newAttributesBuilder().put("topic", topic).put("consumer_group", group).put("is_system", TopicValidator.isSystemTopic((String)topic) || MixAll.isSysConsumerGroup((String)group)).build();
                    BrokerMetricsManager.messagesOutTotal.add((long)getMessageResult.getMessageCount(), attributes);
                    BrokerMetricsManager.throughputOutTotal.add((long)getMessageResult.getBufferTotalSize(), attributes);
                    break;
                }
                case NO_MATCHED_MESSAGE: {
                    pullStatus = PullStatus.NO_MATCHED_MSG;
                    POP_LOGGER.debug("no matched message. GetMessageStatus={}, topic={}, groupId={}, requestOffset={}", new Object[]{getMessageResult.getStatus(), topic, group, offset});
                    break;
                }
                case NO_MESSAGE_IN_QUEUE: {
                    POP_LOGGER.debug("no new message. GetMessageStatus={}, topic={}, groupId={}, requestOffset={}", new Object[]{getMessageResult.getStatus(), topic, group, offset});
                    break;
                }
                case MESSAGE_WAS_REMOVING: 
                case NO_MATCHED_LOGIC_QUEUE: 
                case OFFSET_FOUND_NULL: 
                case OFFSET_OVERFLOW_BADLY: 
                case OFFSET_TOO_SMALL: {
                    pullStatus = PullStatus.OFFSET_ILLEGAL;
                    POP_LOGGER.warn("offset illegal. GetMessageStatus={}, topic={}, groupId={}, requestOffset={}", new Object[]{getMessageResult.getStatus(), topic, group, offset});
                    break;
                }
                case OFFSET_OVERFLOW_ONE: {
                    pullStatus = PullStatus.OFFSET_ILLEGAL;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return new PullResult(pullStatus, getMessageResult.getNextBeginOffset(), getMessageResult.getMinOffset(), getMessageResult.getMaxOffset(), foundList);
        }
        long maxQueueOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId);
        if (maxQueueOffset > offset) {
            POP_LOGGER.error("get message from store return null. topic={}, groupId={}, requestOffset={}, maxQueueOffset={}", new Object[]{topic, group, offset, maxQueueOffset});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MessageExt> decodeMsgList(GetMessageResult getMessageResult, boolean deCompressBody) {
        ArrayList<MessageExt> foundList = new ArrayList<MessageExt>();
        try {
            List messageBufferList = getMessageResult.getMessageBufferList();
            if (messageBufferList != null) {
                for (int i = 0; i < messageBufferList.size(); ++i) {
                    ByteBuffer bb = (ByteBuffer)messageBufferList.get(i);
                    if (bb == null) {
                        POP_LOGGER.error("bb is null {}", (Object)getMessageResult);
                        continue;
                    }
                    MessageExt msgExt = MessageDecoder.decode((ByteBuffer)bb, (boolean)true, (boolean)deCompressBody);
                    if (msgExt == null) {
                        POP_LOGGER.error("decode msgExt is null {}", (Object)getMessageResult);
                        continue;
                    }
                    msgExt.setQueueOffset(((Long)getMessageResult.getMessageQueueOffset().get(i)).longValue());
                    foundList.add(msgExt);
                }
            }
        }
        finally {
            getMessageResult.release();
        }
        return foundList;
    }

    protected void consumeReviveMessage(ConsumeReviveObj consumeReviveObj) {
        long oldOffset;
        HashMap<String, PopCheckPoint> map = consumeReviveObj.map;
        HashMap<String, PopCheckPoint> mockPointMap = new HashMap<String, PopCheckPoint>();
        long startScanTime = System.currentTimeMillis();
        long endTime = 0L;
        long consumeOffset = this.brokerController.getConsumerOffsetManager().queryOffset("CID_RMQ_SYS_REVIVE_GROUP", this.reviveTopic, this.queueId);
        consumeReviveObj.oldOffset = oldOffset = Math.max(this.reviveOffset, consumeOffset);
        POP_LOGGER.info("reviveQueueId={}, old offset is {} ", (Object)this.queueId, (Object)oldOffset);
        long offset = oldOffset + 1L;
        int noMsgCount = 0;
        long firstRt = 0L;
        while (true) {
            if (!this.shouldRunPopRevive) {
                POP_LOGGER.info("slave skip scan, revive topic={}, reviveQueueId={}", (Object)this.reviveTopic, (Object)this.queueId);
                break;
            }
            List<MessageExt> messageExts = this.getReviveMessage(offset, this.queueId);
            if (messageExts == null || messageExts.isEmpty()) {
                long old = endTime;
                long timerDelay = this.brokerController.getMessageStore().getTimerMessageStore().getDequeueBehind();
                long commitLogDelay = this.brokerController.getMessageStore().getTimerMessageStore().getEnqueueBehind();
                if (endTime != 0L && System.currentTimeMillis() - endTime > 3000L && timerDelay <= 0L && commitLogDelay <= 0L) {
                    endTime = System.currentTimeMillis();
                }
                POP_LOGGER.debug("reviveQueueId={}, offset is {}, can not get new msg, old endTime {}, new endTime {}, timerDelay={}, commitLogDelay={} ", new Object[]{this.queueId, offset, old, endTime, timerDelay, commitLogDelay});
                if (endTime - firstRt > PopAckConstants.ackTimeInterval + 1000L) break;
                ++noMsgCount;
                try {
                    Thread.sleep(100L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if ((long)noMsgCount * 100L <= 4000L) continue;
                break;
            }
            noMsgCount = 0;
            if (System.currentTimeMillis() - startScanTime > this.brokerController.getBrokerConfig().getReviveScanTime()) {
                POP_LOGGER.info("reviveQueueId={}, scan timeout ", (Object)this.queueId);
                break;
            }
            for (MessageExt messageExt : messageExts) {
                long deliverTime;
                PopCheckPoint point;
                String mergeKey;
                if ("ck".equals(messageExt.getTags())) {
                    PopCheckPoint point2;
                    String raw = new String(messageExt.getBody(), DataConverter.CHARSET_UTF8);
                    if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                        POP_LOGGER.info("reviveQueueId={},find ck, offset:{}, raw : {}", new Object[]{messageExt.getQueueId(), messageExt.getQueueOffset(), raw});
                    }
                    if ((point2 = (PopCheckPoint)JSON.parseObject((String)raw, PopCheckPoint.class)).getTopic() == null || point2.getCId() == null) continue;
                    map.put(point2.getTopic() + point2.getCId() + point2.getQueueId() + point2.getStartOffset() + point2.getPopTime() + point2.getBrokerName(), point2);
                    PopMetricsManager.incPopReviveCkGetCount(point2, this.queueId);
                    point2.setReviveOffset(messageExt.getQueueOffset());
                    if (firstRt == 0L) {
                        firstRt = point2.getReviveTime();
                    }
                } else if ("ack".equals(messageExt.getTags())) {
                    String raw = new String(messageExt.getBody(), DataConverter.CHARSET_UTF8);
                    if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                        POP_LOGGER.info("reviveQueueId={}, find ack, offset:{}, raw : {}", new Object[]{messageExt.getQueueId(), messageExt.getQueueOffset(), raw});
                    }
                    AckMsg ackMsg = (AckMsg)JSON.parseObject((String)raw, AckMsg.class);
                    PopMetricsManager.incPopReviveAckGetCount(ackMsg, this.queueId);
                    mergeKey = ackMsg.getTopic() + ackMsg.getConsumerGroup() + ackMsg.getQueueId() + ackMsg.getStartOffset() + ackMsg.getPopTime() + ackMsg.getBrokerName();
                    point = map.get(mergeKey);
                    if (point == null) {
                        if (!this.brokerController.getBrokerConfig().isEnableSkipLongAwaitingAck()) continue;
                        if (this.mockCkForAck(messageExt, ackMsg, mergeKey, mockPointMap) && firstRt == 0L) {
                            firstRt = mockPointMap.get(mergeKey).getReviveTime();
                        }
                    } else {
                        int indexOfAck = point.indexOfAck(ackMsg.getAckOffset());
                        if (indexOfAck > -1) {
                            point.setBitMap(DataConverter.setBit((int)point.getBitMap(), (int)indexOfAck, (boolean)true));
                        } else {
                            POP_LOGGER.error("invalid ack index, {}, {}", (Object)ackMsg, (Object)point);
                        }
                    }
                } else if ("bAck".equals(messageExt.getTags())) {
                    String raw = new String(messageExt.getBody(), DataConverter.CHARSET_UTF8);
                    if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                        POP_LOGGER.info("reviveQueueId={}, find batch ack, offset:{}, raw : {}", new Object[]{messageExt.getQueueId(), messageExt.getQueueOffset(), raw});
                    }
                    BatchAckMsg bAckMsg = (BatchAckMsg)JSON.parseObject((String)raw, BatchAckMsg.class);
                    PopMetricsManager.incPopReviveAckGetCount((AckMsg)bAckMsg, this.queueId);
                    mergeKey = bAckMsg.getTopic() + bAckMsg.getConsumerGroup() + bAckMsg.getQueueId() + bAckMsg.getStartOffset() + bAckMsg.getPopTime() + bAckMsg.getBrokerName();
                    point = map.get(mergeKey);
                    if (point == null) {
                        if (!this.brokerController.getBrokerConfig().isEnableSkipLongAwaitingAck()) continue;
                        if (this.mockCkForAck(messageExt, (AckMsg)bAckMsg, mergeKey, mockPointMap) && firstRt == 0L) {
                            firstRt = mockPointMap.get(mergeKey).getReviveTime();
                        }
                    } else {
                        List ackOffsetList = bAckMsg.getAckOffsetList();
                        for (Long ackOffset : ackOffsetList) {
                            int indexOfAck = point.indexOfAck(ackOffset.longValue());
                            if (indexOfAck > -1) {
                                point.setBitMap(DataConverter.setBit((int)point.getBitMap(), (int)indexOfAck, (boolean)true));
                                continue;
                            }
                            POP_LOGGER.error("invalid batch ack index, {}, {}", (Object)bAckMsg, (Object)point);
                        }
                    }
                }
                if ((deliverTime = messageExt.getDeliverTimeMs()) <= endTime) continue;
                endTime = deliverTime;
            }
            offset += (long)messageExts.size();
        }
        consumeReviveObj.map.putAll(mockPointMap);
        consumeReviveObj.endTime = endTime;
    }

    private boolean mockCkForAck(MessageExt messageExt, AckMsg ackMsg, String mergeKey, HashMap<String, PopCheckPoint> mockPointMap) {
        long reviveAckWaitMs;
        long ackWaitTime = System.currentTimeMillis() - messageExt.getDeliverTimeMs();
        if (ackWaitTime > (reviveAckWaitMs = this.brokerController.getBrokerConfig().getReviveAckWaitMs())) {
            PopCheckPoint mockPoint = this.createMockCkForAck(ackMsg, messageExt.getQueueOffset());
            POP_LOGGER.warn("ack wait for {}ms cannot find ck, skip this ack. mergeKey:{}, ack:{}, mockCk:{}", new Object[]{reviveAckWaitMs, mergeKey, ackMsg, mockPoint});
            mockPointMap.put(mergeKey, mockPoint);
            return true;
        }
        return false;
    }

    private PopCheckPoint createMockCkForAck(AckMsg ackMsg, long reviveOffset) {
        PopCheckPoint point = new PopCheckPoint();
        point.setStartOffset(ackMsg.getStartOffset());
        point.setPopTime(ackMsg.getPopTime());
        point.setQueueId(ackMsg.getQueueId());
        point.setCId(ackMsg.getConsumerGroup());
        point.setTopic(ackMsg.getTopic());
        point.setNum((byte)0);
        point.setBitMap(0);
        point.setReviveOffset(reviveOffset);
        point.setBrokerName(ackMsg.getBrokerName());
        return point;
    }

    protected void mergeAndRevive(ConsumeReviveObj consumeReviveObj) throws Throwable {
        ArrayList<PopCheckPoint> sortList = consumeReviveObj.genSortList();
        POP_LOGGER.info("reviveQueueId={}, ck listSize={}", (Object)this.queueId, (Object)sortList.size());
        if (sortList.size() != 0) {
            POP_LOGGER.info("reviveQueueId={}, 1st ck, startOffset={}, reviveOffset={}; last ck, startOffset={}, reviveOffset={}", new Object[]{this.queueId, sortList.get(0).getStartOffset(), sortList.get(0).getReviveOffset(), sortList.get(sortList.size() - 1).getStartOffset(), sortList.get(sortList.size() - 1).getReviveOffset()});
        }
        long newOffset = consumeReviveObj.oldOffset;
        for (PopCheckPoint popCheckPoint : sortList) {
            if (!this.shouldRunPopRevive) {
                POP_LOGGER.info("slave skip ck process, revive topic={}, reviveQueueId={}", (Object)this.reviveTopic, (Object)this.queueId);
                break;
            }
            if (consumeReviveObj.endTime - popCheckPoint.getReviveTime() <= PopAckConstants.ackTimeInterval + 1000L) break;
            String normalTopic = KeyBuilder.parseNormalTopic((String)popCheckPoint.getTopic(), (String)popCheckPoint.getCId());
            if (this.brokerController.getTopicConfigManager().selectTopicConfig(normalTopic) == null) {
                POP_LOGGER.warn("reviveQueueId={}, can not get normal topic {}, then continue", (Object)this.queueId, (Object)popCheckPoint.getTopic());
                newOffset = popCheckPoint.getReviveOffset();
                continue;
            }
            if (null == this.brokerController.getSubscriptionGroupManager().findSubscriptionGroupConfig(popCheckPoint.getCId())) {
                POP_LOGGER.warn("reviveQueueId={}, can not get cid {}, then continue", (Object)this.queueId, (Object)popCheckPoint.getCId());
                newOffset = popCheckPoint.getReviveOffset();
                continue;
            }
            while (this.inflightReviveRequestMap.size() > 3) {
                this.waitForRunning(100L);
                Pair<Long, Boolean> pair = this.inflightReviveRequestMap.firstEntry().getValue();
                if (((Boolean)pair.getObject2()).booleanValue() || System.currentTimeMillis() - (Long)pair.getObject1() <= 30000L) continue;
                PopCheckPoint oldCK = (PopCheckPoint)this.inflightReviveRequestMap.firstKey();
                this.rePutCK(oldCK, pair);
                this.inflightReviveRequestMap.remove(oldCK);
                POP_LOGGER.warn("stay too long, remove from reviveRequestMap, {}, {}, {}, {}", new Object[]{popCheckPoint.getTopic(), popCheckPoint.getBrokerName(), popCheckPoint.getQueueId(), popCheckPoint.getStartOffset()});
            }
            this.reviveMsgFromCk(popCheckPoint);
            newOffset = popCheckPoint.getReviveOffset();
        }
        if (newOffset > consumeReviveObj.oldOffset) {
            if (!this.shouldRunPopRevive) {
                POP_LOGGER.info("slave skip commit, revive topic={}, reviveQueueId={}", (Object)this.reviveTopic, (Object)this.queueId);
                return;
            }
            this.brokerController.getConsumerOffsetManager().commitOffset("127.0.0.1", "CID_RMQ_SYS_REVIVE_GROUP", this.reviveTopic, this.queueId, newOffset);
        }
        this.reviveOffset = newOffset;
        consumeReviveObj.newOffset = newOffset;
    }

    private void reviveMsgFromCk(PopCheckPoint popCheckPoint) {
        if (!this.shouldRunPopRevive) {
            POP_LOGGER.info("slave skip retry, revive topic={}, reviveQueueId={}", (Object)this.reviveTopic, (Object)this.queueId);
            return;
        }
        this.inflightReviveRequestMap.put(popCheckPoint, (Pair<Long, Boolean>)new Pair((Object)System.currentTimeMillis(), (Object)false));
        ArrayList<CompletionStage> futureList = new ArrayList<CompletionStage>(popCheckPoint.getNum());
        for (int j = 0; j < popCheckPoint.getNum(); ++j) {
            if (DataConverter.getBit((int)popCheckPoint.getBitMap(), (int)j)) continue;
            long msgOffset = popCheckPoint.ackOffsetByIndex((byte)j);
            CompletionStage future = this.getBizMessage(popCheckPoint, msgOffset).thenApply(rst -> {
                MessageExt message = (MessageExt)rst.getLeft();
                if (message == null) {
                    POP_LOGGER.info("reviveQueueId={}, can not get biz msg, topic:{}, qid:{}, offset:{}, brokerName:{}, info:{}, retry:{}, then continue", new Object[]{this.queueId, popCheckPoint.getTopic(), popCheckPoint.getQueueId(), msgOffset, popCheckPoint.getBrokerName(), UtilAll.frontStringAtLeast((String)((String)rst.getMiddle()), (int)60), rst.getRight()});
                    return new Pair((Object)msgOffset, (Object)((Boolean)rst.getRight() == false ? 1 : 0));
                }
                boolean result = this.reviveRetry(popCheckPoint, message);
                return new Pair((Object)msgOffset, (Object)result);
            });
            futureList.add(future);
        }
        CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).whenComplete((v, e) -> {
            for (CompletableFuture completableFuture : futureList) {
                Pair pair = completableFuture.getNow(new Pair((Object)0L, (Object)false));
                if (((Boolean)pair.getObject2()).booleanValue()) continue;
                this.rePutCK(popCheckPoint, (Pair<Long, Boolean>)pair);
            }
            if (this.inflightReviveRequestMap.containsKey(popCheckPoint)) {
                ((Pair)this.inflightReviveRequestMap.get(popCheckPoint)).setObject2((Object)true);
            }
            for (Map.Entry entry : this.inflightReviveRequestMap.entrySet()) {
                PopCheckPoint oldCK = (PopCheckPoint)entry.getKey();
                Pair pair = (Pair)entry.getValue();
                if (!((Boolean)pair.getObject2()).booleanValue()) break;
                this.brokerController.getConsumerOffsetManager().commitOffset("127.0.0.1", "CID_RMQ_SYS_REVIVE_GROUP", this.reviveTopic, this.queueId, oldCK.getReviveOffset());
                this.inflightReviveRequestMap.remove(oldCK);
            }
        });
    }

    private void rePutCK(PopCheckPoint oldCK, Pair<Long, Boolean> pair) {
        int rePutTimes = oldCK.parseRePutTimes();
        if (rePutTimes >= this.ckRewriteIntervalsInSeconds.length && this.brokerController.getBrokerConfig().isSkipWhenCKRePutReachMaxTimes()) {
            POP_LOGGER.warn("rePut CK reach max times, drop it. {}, {}, {}, {}-{}, {}, {}, {}", new Object[]{oldCK.getTopic(), oldCK.getCId(), oldCK.getBrokerName(), oldCK.getQueueId(), pair.getObject1(), oldCK.getPopTime(), oldCK.getInvisibleTime(), rePutTimes});
            return;
        }
        PopCheckPoint newCk = new PopCheckPoint();
        newCk.setBitMap(0);
        newCk.setNum((byte)1);
        newCk.setPopTime(oldCK.getPopTime());
        newCk.setInvisibleTime(oldCK.getInvisibleTime());
        newCk.setStartOffset(((Long)pair.getObject1()).longValue());
        newCk.setCId(oldCK.getCId());
        newCk.setTopic(oldCK.getTopic());
        newCk.setQueueId(oldCK.getQueueId());
        newCk.setBrokerName(oldCK.getBrokerName());
        newCk.addDiff(0);
        newCk.setRePutTimes(String.valueOf(rePutTimes + 1));
        if (oldCK.getReviveTime() <= System.currentTimeMillis()) {
            int intervalIndex = rePutTimes >= this.ckRewriteIntervalsInSeconds.length ? this.ckRewriteIntervalsInSeconds.length - 1 : rePutTimes;
            newCk.setInvisibleTime(oldCK.getInvisibleTime() + (long)(this.ckRewriteIntervalsInSeconds[intervalIndex] * 1000));
        }
        MessageExtBrokerInner ckMsg = this.brokerController.getPopMessageProcessor().buildCkMsg(newCk, this.queueId);
        this.brokerController.getMessageStore().putMessage(ckMsg);
    }

    public long getReviveBehindMillis() {
        if (this.currentReviveMessageTimestamp <= 0L) {
            return 0L;
        }
        long maxOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(this.reviveTopic, this.queueId);
        if (maxOffset - this.reviveOffset > 1L) {
            return Math.max(0L, System.currentTimeMillis() - this.currentReviveMessageTimestamp);
        }
        return 0L;
    }

    public long getReviveBehindMessages() {
        if (this.currentReviveMessageTimestamp <= 0L) {
            return 0L;
        }
        long diff = this.brokerController.getMessageStore().getMaxOffsetInQueue(this.reviveTopic, this.queueId) - this.reviveOffset;
        return Math.max(0L, diff);
    }

    public void run() {
        int slow = 1;
        while (!this.isStopped()) {
            try {
                if (System.currentTimeMillis() < this.brokerController.getShouldStartTime()) {
                    POP_LOGGER.info("PopReviveService Ready to run after {}", (Object)this.brokerController.getShouldStartTime());
                    this.waitForRunning(1000L);
                    continue;
                }
                this.waitForRunning(this.brokerController.getBrokerConfig().getReviveInterval());
                if (!this.shouldRunPopRevive) {
                    POP_LOGGER.info("skip start revive topic={}, reviveQueueId={}", (Object)this.reviveTopic, (Object)this.queueId);
                    continue;
                }
                if (!this.brokerController.getMessageStore().getMessageStoreConfig().isTimerWheelEnable()) {
                    POP_LOGGER.warn("skip revive topic because timerWheelEnable is false");
                    continue;
                }
                POP_LOGGER.info("start revive topic={}, reviveQueueId={}", (Object)this.reviveTopic, (Object)this.queueId);
                ConsumeReviveObj consumeReviveObj = new ConsumeReviveObj();
                this.consumeReviveMessage(consumeReviveObj);
                if (!this.shouldRunPopRevive) {
                    POP_LOGGER.info("slave skip scan, revive topic={}, reviveQueueId={}", (Object)this.reviveTopic, (Object)this.queueId);
                    continue;
                }
                this.mergeAndRevive(consumeReviveObj);
                ArrayList<PopCheckPoint> sortList = consumeReviveObj.sortList;
                long delay = 0L;
                if (sortList != null && !sortList.isEmpty()) {
                    delay = (System.currentTimeMillis() - sortList.get(0).getReviveTime()) / 1000L;
                    this.currentReviveMessageTimestamp = sortList.get(0).getReviveTime();
                    slow = 1;
                } else {
                    this.currentReviveMessageTimestamp = System.currentTimeMillis();
                }
                POP_LOGGER.info("reviveQueueId={}, revive finish,old offset is {}, new offset is {}, ckDelay={}  ", new Object[]{this.queueId, consumeReviveObj.oldOffset, consumeReviveObj.newOffset, delay});
                if (sortList != null && !sortList.isEmpty()) continue;
                POP_LOGGER.info("reviveQueueId={}, has no new msg, take a rest {}", (Object)this.queueId, (Object)slow);
                this.waitForRunning((long)slow * this.brokerController.getBrokerConfig().getReviveInterval());
                if ((long)slow >= this.brokerController.getBrokerConfig().getReviveMaxSlow()) continue;
                ++slow;
            }
            catch (Throwable e) {
                POP_LOGGER.error("reviveQueueId={}, revive error", (Object)this.queueId, (Object)e);
            }
        }
    }

    static class ConsumeReviveObj {
        HashMap<String, PopCheckPoint> map = new HashMap();
        ArrayList<PopCheckPoint> sortList;
        long oldOffset;
        long endTime;
        long newOffset;

        ConsumeReviveObj() {
        }

        ArrayList<PopCheckPoint> genSortList() {
            if (this.sortList != null) {
                return this.sortList;
            }
            this.sortList = new ArrayList<PopCheckPoint>(this.map.values());
            this.sortList.sort((o1, o2) -> (int)(o1.getReviveOffset() - o2.getReviveOffset()));
            return this.sortList;
        }
    }
}

