/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.ranger.audit.provider.DebugTracer;
import org.apache.ranger.audit.provider.DestinationDispatcherThread;
import org.apache.ranger.audit.provider.LogBuffer;
import org.apache.ranger.audit.provider.LogDestination;
import org.apache.ranger.audit.provider.MiscUtil;

public class LocalFileLogBuffer<T>
implements LogBuffer<T> {
    private String mDirectory = null;
    private String mFile = null;
    private int mFlushIntervalSeconds = 60;
    private int mFileBufferSizeBytes = 8192;
    private String mEncoding = null;
    private boolean mIsAppend = true;
    private int mRolloverIntervalSeconds = 600;
    private String mArchiveDirectory = null;
    private int mArchiveFileCount = 10;
    private DebugTracer mLogger = null;
    private Writer mWriter = null;
    private String mBufferFilename = null;
    private long mNextRolloverTime = 0L;
    private long mNextFlushTime = 0L;
    private int mFileOpenRetryIntervalInMs = 60000;
    private long mNextFileOpenRetryTime = 0L;
    private DestinationDispatcherThread<T> mDispatcherThread = null;

    public LocalFileLogBuffer(DebugTracer tracer) {
        this.mLogger = tracer;
    }

    public String getDirectory() {
        return this.mDirectory;
    }

    public void setDirectory(String directory) {
        this.mDirectory = directory;
    }

    public String getFile() {
        return this.mFile;
    }

    public void setFile(String file) {
        this.mFile = file;
    }

    public int getFileBufferSizeBytes() {
        return this.mFileBufferSizeBytes;
    }

    public void setFileBufferSizeBytes(int fileBufferSizeBytes) {
        this.mFileBufferSizeBytes = fileBufferSizeBytes;
    }

    public int getFlushIntervalSeconds() {
        return this.mFlushIntervalSeconds;
    }

    public void setFlushIntervalSeconds(int flushIntervalSeconds) {
        this.mFlushIntervalSeconds = flushIntervalSeconds;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public void setEncoding(String encoding) {
        this.mEncoding = encoding;
    }

    public boolean getIsAppend() {
        return this.mIsAppend;
    }

    public void setIsAppend(boolean isAppend) {
        this.mIsAppend = isAppend;
    }

    public int getRolloverIntervalSeconds() {
        return this.mRolloverIntervalSeconds;
    }

    public void setRolloverIntervalSeconds(int rolloverIntervalSeconds) {
        this.mRolloverIntervalSeconds = rolloverIntervalSeconds;
    }

    public String getArchiveDirectory() {
        return this.mArchiveDirectory;
    }

    public void setArchiveDirectory(String archiveDirectory) {
        this.mArchiveDirectory = archiveDirectory;
    }

    public int getArchiveFileCount() {
        return this.mArchiveFileCount;
    }

    public void setArchiveFileCount(int archiveFileCount) {
        this.mArchiveFileCount = archiveFileCount;
    }

    public void start(LogDestination<T> destination) {
        this.mLogger.debug("==> LocalFileLogBuffer.start()");
        this.mDispatcherThread = new DestinationDispatcherThread<T>(this, destination, this.mLogger);
        this.mDispatcherThread.setDaemon(true);
        this.mDispatcherThread.start();
        this.mLogger.debug("<== LocalFileLogBuffer.start()");
    }

    public void stop() {
        this.mLogger.debug("==> LocalFileLogBuffer.stop()");
        DestinationDispatcherThread<T> dispatcherThread = this.mDispatcherThread;
        this.mDispatcherThread = null;
        if (dispatcherThread != null && dispatcherThread.isAlive()) {
            dispatcherThread.stopThread();
            try {
                dispatcherThread.join();
            }
            catch (InterruptedException e) {
                this.mLogger.warn("LocalFileLogBuffer.stop(): failed in waiting for DispatcherThread", (Throwable)e);
            }
        }
        this.closeFile();
        this.mLogger.debug("<== LocalFileLogBuffer.stop()");
    }

    public boolean isAvailable() {
        return this.mWriter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T log) {
        boolean ret = false;
        String msg = MiscUtil.stringify(log);
        if (msg.contains(MiscUtil.LINE_SEPARATOR)) {
            msg = msg.replace(MiscUtil.LINE_SEPARATOR, "\\" + MiscUtil.LINE_SEPARATOR);
        }
        LocalFileLogBuffer localFileLogBuffer = this;
        synchronized (localFileLogBuffer) {
            this.checkFileStatus();
            Writer writer = this.mWriter;
            if (writer != null) {
                try {
                    writer.write(msg + MiscUtil.LINE_SEPARATOR);
                    if (this.mFileBufferSizeBytes == 0) {
                        writer.flush();
                    }
                    ret = true;
                }
                catch (IOException excp) {
                    this.mLogger.warn("LocalFileLogBuffer.add(): write failed", (Throwable)excp);
                    this.closeFile();
                }
            }
        }
        return ret;
    }

    public boolean isEmpty() {
        return this.mDispatcherThread == null || this.mDispatcherThread.isIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void openFile() {
        this.mLogger.debug("==> LocalFileLogBuffer.openFile()");
        long now = System.currentTimeMillis();
        this.closeFile();
        if (this.mNextFileOpenRetryTime <= now) {
            try {
                this.mNextRolloverTime = MiscUtil.getNextRolloverTime((long)this.mNextRolloverTime, (long)((long)this.mRolloverIntervalSeconds * 1000L));
                long startTime = MiscUtil.getRolloverStartTime((long)this.mNextRolloverTime, (long)((long)this.mRolloverIntervalSeconds * 1000L));
                this.mBufferFilename = MiscUtil.replaceTokens((String)(this.mDirectory + File.separator + this.mFile), (long)startTime);
                MiscUtil.createParents((File)new File(this.mBufferFilename));
                FileOutputStream ostream = null;
                try {
                    ostream = new FileOutputStream(this.mBufferFilename, this.mIsAppend);
                }
                catch (Exception excp) {
                    this.mLogger.warn("LocalFileLogBuffer.openFile(): failed to open file " + this.mBufferFilename, (Throwable)excp);
                }
                if (ostream != null) {
                    this.mWriter = this.createWriter(ostream);
                    this.mLogger.debug("LocalFileLogBuffer.openFile(): opened file " + this.mBufferFilename);
                    this.mNextFlushTime = System.currentTimeMillis() + (long)this.mFlushIntervalSeconds * 1000L;
                } else {
                    this.mLogger.warn("LocalFileLogBuffer.openFile(): failed to open file for write " + this.mBufferFilename);
                    this.mBufferFilename = null;
                }
            }
            finally {
                if (this.mWriter == null) {
                    this.mNextFileOpenRetryTime = now + (long)this.mFileOpenRetryIntervalInMs;
                }
            }
        }
        this.mLogger.debug("<== LocalFileLogBuffer.openFile()");
    }

    private synchronized void closeFile() {
        this.mLogger.debug("==> LocalFileLogBuffer.closeFile()");
        Writer writer = this.mWriter;
        this.mWriter = null;
        if (writer != null) {
            try {
                writer.flush();
                writer.close();
            }
            catch (IOException excp) {
                this.mLogger.warn("LocalFileLogBuffer: failed to close file " + this.mBufferFilename, (Throwable)excp);
            }
            if (this.mDispatcherThread != null) {
                this.mDispatcherThread.addLogfile(this.mBufferFilename);
            }
        }
        this.mLogger.debug("<== LocalFileLogBuffer.closeFile()");
    }

    private void rollover() {
        this.mLogger.debug("==> LocalFileLogBuffer.rollover()");
        this.closeFile();
        this.openFile();
        this.mLogger.debug("<== LocalFileLogBuffer.rollover()");
    }

    private void checkFileStatus() {
        long now = System.currentTimeMillis();
        if (now > this.mNextRolloverTime) {
            this.rollover();
        } else if (this.mWriter == null) {
            this.openFile();
        } else if (now > this.mNextFlushTime) {
            try {
                this.mNextFlushTime = now + (long)this.mFlushIntervalSeconds * 1000L;
                this.mWriter.flush();
            }
            catch (IOException excp) {
                this.mLogger.warn("LocalFileLogBuffer: failed to flush to file " + this.mBufferFilename, (Throwable)excp);
            }
        }
    }

    private Writer createWriter(OutputStream os) {
        Writer writer = null;
        if (os != null) {
            if (this.mEncoding != null) {
                try {
                    writer = new OutputStreamWriter(os, this.mEncoding);
                }
                catch (UnsupportedEncodingException excp) {
                    this.mLogger.warn("LocalFileLogBuffer: failed to create output writer for file " + this.mBufferFilename, (Throwable)excp);
                }
            }
            if (writer == null) {
                writer = new OutputStreamWriter(os);
            }
            if (this.mFileBufferSizeBytes > 0 && writer != null) {
                writer = new BufferedWriter(writer, this.mFileBufferSizeBytes);
            }
        }
        return writer;
    }

    boolean isCurrentFilename(String filename) {
        return filename != null && filename.equals(this.mBufferFilename);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LocalFileLogBuffer {");
        sb.append("Directory=").append(this.mDirectory).append("; ");
        sb.append("File=").append(this.mFile).append("; ");
        sb.append("RolloverIntervaSeconds=").append(this.mRolloverIntervalSeconds).append("; ");
        sb.append("ArchiveDirectory=").append(this.mArchiveDirectory).append("; ");
        sb.append("ArchiveFileCount=").append(this.mArchiveFileCount);
        sb.append("}");
        return sb.toString();
    }
}

