/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.primitives;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;

public final class IntegerTypeEncoder
extends AbstractPrimitiveTypeEncoder<Integer> {
    @Override
    public Class<Integer> getTypeClass() {
        return Integer.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, Integer value) {
        this.writeType(buffer, state, (int)value);
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, int value) {
        if (value >= -128 && value <= 127) {
            buffer.writeByte((byte)84);
            buffer.writeByte((byte)value);
        } else {
            buffer.writeByte((byte)113);
            buffer.writeInt(value);
        }
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte((byte)113);
        for (Object value : values) {
            buffer.writeInt((Integer)value);
        }
    }

    public void writeRawArray(ProtonBuffer buffer, EncoderState state, int[] values) {
        buffer.writeByte((byte)113);
        for (int value : values) {
            buffer.writeInt(value);
        }
    }

    public void writeArray(ProtonBuffer buffer, EncoderState state, int[] values) {
        if (values.length < 63) {
            this.writeAsArray8(buffer, state, values);
        } else {
            this.writeAsArray32(buffer, state, values);
        }
    }

    private void writeAsArray8(ProtonBuffer buffer, EncoderState state, int[] values) {
        buffer.writeByte((byte)-32);
        int startIndex = buffer.getWriteOffset();
        buffer.writeByte((byte)0);
        buffer.writeByte((byte)values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteOffset();
        long writeSize = endIndex - startIndex - 1;
        buffer.setByte(startIndex, (byte)writeSize);
    }

    private void writeAsArray32(ProtonBuffer buffer, EncoderState state, int[] values) {
        buffer.writeByte((byte)-16);
        int startIndex = buffer.getWriteOffset();
        buffer.writeInt(0);
        buffer.writeInt(values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteOffset();
        long writeSize = endIndex - startIndex - 4;
        if (writeSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot encode given array, encoded size to large: " + writeSize);
        }
        buffer.setInt(startIndex, (int)writeSize);
    }
}

