/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.*;
import static org.w3c.domts.DOMTest.isExpandEntityReferences;
import static org.w3c.domts.DOMTest.load;


/**
 * The "removeAttributeNS(namespaceURI,localName)" method for an attribute causes the
 * DOMException NO_MODIFICATION_ALLOWED_ERR to be raised
 * if the node is readonly.
 * <p>
 * Obtain the children of the THIRD "gender" element.  The elements
 * content is an entity reference.  Try to remove an attribute
 * from the entity reference by executing the
 * "removeAttributeNS(namespaceURI,localName)" method.
 * This causes a NO_MODIFICATION_ALLOWED_ERR DOMException to be thrown.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-258A00AF')/constant[@name='NO_MODIFICATION_ALLOWED_ERR'])">http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-258A00AF')/constant[@name='NO_MODIFICATION_ALLOWED_ERR'])</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElRemAtNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElRemAtNS</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-ElRemAtNS')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NO_MODIFICATION_ALLOWED_ERR'])">http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-ElRemAtNS')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NO_MODIFICATION_ALLOWED_ERR'])</a>
 */
public class removeAttributeNS01 {
    @Test
    @Disabled
    public void testRun() throws Throwable {
        Document doc = load("staffNS", true);

        Node gen;
        if (!isExpandEntityReferences()) {
            NodeList genderList = doc.getElementsByTagName("gender");
            Node gender = genderList.item(2);
            NodeList genList = gender.getChildNodes();
            gen = genList.item(0);
        } else {
            gen = doc.createEntityReference("ent4");
        }

        NodeList gList = gen.getChildNodes();
        Element genElement = (Element) gList.item(0);
        assertNotNull(genElement, "notnull");

        DOMException ex = assertThrows(DOMException.class, () -> genElement.removeAttributeNS("www.xyz.com", "local1"));
        assertEquals(DOMException.NO_MODIFICATION_ALLOWED_ERR, ex.code, "throw_NO_MODIFICATION_ALLOWED_ERR");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/removeAttributeNS01";
    }

}
