/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class HistoryReadValueId extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 637;
  }

  // Properties.
  protected final NodeId nodeId;
  protected final PascalString indexRange;
  protected final QualifiedName dataEncoding;
  protected final PascalByteString continuationPoint;

  public HistoryReadValueId(
      NodeId nodeId,
      PascalString indexRange,
      QualifiedName dataEncoding,
      PascalByteString continuationPoint) {
    super();
    this.nodeId = nodeId;
    this.indexRange = indexRange;
    this.dataEncoding = dataEncoding;
    this.continuationPoint = continuationPoint;
  }

  public NodeId getNodeId() {
    return nodeId;
  }

  public PascalString getIndexRange() {
    return indexRange;
  }

  public QualifiedName getDataEncoding() {
    return dataEncoding;
  }

  public PascalByteString getContinuationPoint() {
    return continuationPoint;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("HistoryReadValueId");

    // Simple Field (nodeId)
    writeSimpleField("nodeId", nodeId, writeComplex(writeBuffer));

    // Simple Field (indexRange)
    writeSimpleField("indexRange", indexRange, writeComplex(writeBuffer));

    // Simple Field (dataEncoding)
    writeSimpleField("dataEncoding", dataEncoding, writeComplex(writeBuffer));

    // Simple Field (continuationPoint)
    writeSimpleField("continuationPoint", continuationPoint, writeComplex(writeBuffer));

    writeBuffer.popContext("HistoryReadValueId");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    HistoryReadValueId _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (nodeId)
    lengthInBits += nodeId.getLengthInBits();

    // Simple field (indexRange)
    lengthInBits += indexRange.getLengthInBits();

    // Simple field (dataEncoding)
    lengthInBits += dataEncoding.getLengthInBits();

    // Simple field (continuationPoint)
    lengthInBits += continuationPoint.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("HistoryReadValueId");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    NodeId nodeId =
        readSimpleField("nodeId", readComplex(() -> NodeId.staticParse(readBuffer), readBuffer));

    PascalString indexRange =
        readSimpleField(
            "indexRange", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    QualifiedName dataEncoding =
        readSimpleField(
            "dataEncoding", readComplex(() -> QualifiedName.staticParse(readBuffer), readBuffer));

    PascalByteString continuationPoint =
        readSimpleField(
            "continuationPoint",
            readComplex(() -> PascalByteString.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("HistoryReadValueId");
    // Create the instance
    return new HistoryReadValueIdBuilderImpl(nodeId, indexRange, dataEncoding, continuationPoint);
  }

  public static class HistoryReadValueIdBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final NodeId nodeId;
    private final PascalString indexRange;
    private final QualifiedName dataEncoding;
    private final PascalByteString continuationPoint;

    public HistoryReadValueIdBuilderImpl(
        NodeId nodeId,
        PascalString indexRange,
        QualifiedName dataEncoding,
        PascalByteString continuationPoint) {
      this.nodeId = nodeId;
      this.indexRange = indexRange;
      this.dataEncoding = dataEncoding;
      this.continuationPoint = continuationPoint;
    }

    public HistoryReadValueId build() {
      HistoryReadValueId historyReadValueId =
          new HistoryReadValueId(nodeId, indexRange, dataEncoding, continuationPoint);
      return historyReadValueId;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof HistoryReadValueId)) {
      return false;
    }
    HistoryReadValueId that = (HistoryReadValueId) o;
    return (getNodeId() == that.getNodeId())
        && (getIndexRange() == that.getIndexRange())
        && (getDataEncoding() == that.getDataEncoding())
        && (getContinuationPoint() == that.getContinuationPoint())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getNodeId(), getIndexRange(), getDataEncoding(), getContinuationPoint());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
