/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum BACnetLiftFault {
  CONTROLLER_FAULT((int) 0),
  DRIVE_AND_MOTOR_FAULT((int) 1),
  GOVERNOR_AND_SAFETY_GEAR_FAULT((int) 2),
  LIFT_SHAFT_DEVICE_FAULT((int) 3),
  POWER_SUPPLY_FAULT((int) 4),
  SAFETY_INTERLOCK_FAULT((int) 5),
  DOOR_CLOSING_FAULT((int) 6),
  DOOR_OPENING_FAULT((int) 7),
  CAR_STOPPED_OUTSIDE_LANDING_ZONE((int) 8),
  CALL_BUTTON_STUCK((int) 9),
  START_FAILURE((int) 10),
  CONTROLLER_SUPPLY_FAULT((int) 11),
  SELF_TEST_FAILURE((int) 12),
  RUNTIME_LIMIT_EXCEEDED((int) 13),
  POSITION_LOST((int) 14),
  DRIVE_TEMPERATURE_EXCEEDED((int) 15),
  LOAD_MEASUREMENT_FAULT((int) 16),
  VENDOR_PROPRIETARY_VALUE((int) 0XFFFF);
  private static final Map<Integer, BACnetLiftFault> map;

  static {
    map = new HashMap<>();
    for (BACnetLiftFault value : BACnetLiftFault.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  BACnetLiftFault(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static BACnetLiftFault enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
