/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SysexCommandPinStateQuery is the corresponding interface of SysexCommandPinStateQuery
type SysexCommandPinStateQuery interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SysexCommand
	// GetPin returns Pin (property field)
	GetPin() uint8
	// IsSysexCommandPinStateQuery is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSysexCommandPinStateQuery()
	// CreateBuilder creates a SysexCommandPinStateQueryBuilder
	CreateSysexCommandPinStateQueryBuilder() SysexCommandPinStateQueryBuilder
}

// _SysexCommandPinStateQuery is the data-structure of this message
type _SysexCommandPinStateQuery struct {
	SysexCommandContract
	Pin uint8
}

var _ SysexCommandPinStateQuery = (*_SysexCommandPinStateQuery)(nil)
var _ SysexCommandRequirements = (*_SysexCommandPinStateQuery)(nil)

// NewSysexCommandPinStateQuery factory function for _SysexCommandPinStateQuery
func NewSysexCommandPinStateQuery(pin uint8) *_SysexCommandPinStateQuery {
	_result := &_SysexCommandPinStateQuery{
		SysexCommandContract: NewSysexCommand(),
		Pin:                  pin,
	}
	_result.SysexCommandContract.(*_SysexCommand)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SysexCommandPinStateQueryBuilder is a builder for SysexCommandPinStateQuery
type SysexCommandPinStateQueryBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(pin uint8) SysexCommandPinStateQueryBuilder
	// WithPin adds Pin (property field)
	WithPin(uint8) SysexCommandPinStateQueryBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SysexCommandBuilder
	// Build builds the SysexCommandPinStateQuery or returns an error if something is wrong
	Build() (SysexCommandPinStateQuery, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SysexCommandPinStateQuery
}

// NewSysexCommandPinStateQueryBuilder() creates a SysexCommandPinStateQueryBuilder
func NewSysexCommandPinStateQueryBuilder() SysexCommandPinStateQueryBuilder {
	return &_SysexCommandPinStateQueryBuilder{_SysexCommandPinStateQuery: new(_SysexCommandPinStateQuery)}
}

type _SysexCommandPinStateQueryBuilder struct {
	*_SysexCommandPinStateQuery

	parentBuilder *_SysexCommandBuilder

	collectedErr []error
}

var _ (SysexCommandPinStateQueryBuilder) = (*_SysexCommandPinStateQueryBuilder)(nil)

func (b *_SysexCommandPinStateQueryBuilder) setParent(contract SysexCommandContract) {
	b.SysexCommandContract = contract
	contract.(*_SysexCommand)._SubType = b._SysexCommandPinStateQuery
}

func (b *_SysexCommandPinStateQueryBuilder) WithMandatoryFields(pin uint8) SysexCommandPinStateQueryBuilder {
	return b.WithPin(pin)
}

func (b *_SysexCommandPinStateQueryBuilder) WithPin(pin uint8) SysexCommandPinStateQueryBuilder {
	b.Pin = pin
	return b
}

func (b *_SysexCommandPinStateQueryBuilder) Build() (SysexCommandPinStateQuery, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SysexCommandPinStateQuery.deepCopy(), nil
}

func (b *_SysexCommandPinStateQueryBuilder) MustBuild() SysexCommandPinStateQuery {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SysexCommandPinStateQueryBuilder) Done() SysexCommandBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSysexCommandBuilder().(*_SysexCommandBuilder)
	}
	return b.parentBuilder
}

func (b *_SysexCommandPinStateQueryBuilder) buildForSysexCommand() (SysexCommand, error) {
	return b.Build()
}

func (b *_SysexCommandPinStateQueryBuilder) DeepCopy() any {
	_copy := b.CreateSysexCommandPinStateQueryBuilder().(*_SysexCommandPinStateQueryBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSysexCommandPinStateQueryBuilder creates a SysexCommandPinStateQueryBuilder
func (b *_SysexCommandPinStateQuery) CreateSysexCommandPinStateQueryBuilder() SysexCommandPinStateQueryBuilder {
	if b == nil {
		return NewSysexCommandPinStateQueryBuilder()
	}
	return &_SysexCommandPinStateQueryBuilder{_SysexCommandPinStateQuery: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SysexCommandPinStateQuery) GetCommandType() uint8 {
	return 0x6D
}

func (m *_SysexCommandPinStateQuery) GetResponse() bool {
	return false
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SysexCommandPinStateQuery) GetParent() SysexCommandContract {
	return m.SysexCommandContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SysexCommandPinStateQuery) GetPin() uint8 {
	return m.Pin
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSysexCommandPinStateQuery(structType any) SysexCommandPinStateQuery {
	if casted, ok := structType.(SysexCommandPinStateQuery); ok {
		return casted
	}
	if casted, ok := structType.(*SysexCommandPinStateQuery); ok {
		return *casted
	}
	return nil
}

func (m *_SysexCommandPinStateQuery) GetTypeName() string {
	return "SysexCommandPinStateQuery"
}

func (m *_SysexCommandPinStateQuery) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SysexCommandContract.(*_SysexCommand).getLengthInBits(ctx))

	// Simple field (pin)
	lengthInBits += 8

	return lengthInBits
}

func (m *_SysexCommandPinStateQuery) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SysexCommandPinStateQuery) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SysexCommand, response bool) (__sysexCommandPinStateQuery SysexCommandPinStateQuery, err error) {
	m.SysexCommandContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SysexCommandPinStateQuery"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SysexCommandPinStateQuery")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	pin, err := ReadSimpleField(ctx, "pin", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'pin' field"))
	}
	m.Pin = pin

	if closeErr := readBuffer.CloseContext("SysexCommandPinStateQuery"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SysexCommandPinStateQuery")
	}

	return m, nil
}

func (m *_SysexCommandPinStateQuery) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SysexCommandPinStateQuery) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SysexCommandPinStateQuery"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SysexCommandPinStateQuery")
		}

		if err := WriteSimpleField[uint8](ctx, "pin", m.GetPin(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'pin' field")
		}

		if popErr := writeBuffer.PopContext("SysexCommandPinStateQuery"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SysexCommandPinStateQuery")
		}
		return nil
	}
	return m.SysexCommandContract.(*_SysexCommand).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SysexCommandPinStateQuery) IsSysexCommandPinStateQuery() {}

func (m *_SysexCommandPinStateQuery) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SysexCommandPinStateQuery) deepCopy() *_SysexCommandPinStateQuery {
	if m == nil {
		return nil
	}
	_SysexCommandPinStateQueryCopy := &_SysexCommandPinStateQuery{
		m.SysexCommandContract.(*_SysexCommand).deepCopy(),
		m.Pin,
	}
	_SysexCommandPinStateQueryCopy.SysexCommandContract.(*_SysexCommand)._SubType = m
	return _SysexCommandPinStateQueryCopy
}

func (m *_SysexCommandPinStateQuery) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
