/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.jmx.MonitorManager;
import org.apache.phoenix.pherf.result.ResultUtil;
import org.apache.phoenix.pherf.schema.SchemaReader;
import org.apache.phoenix.pherf.util.GoogleChartGenerator;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.util.ResourceList;
import org.apache.phoenix.pherf.workload.QueryExecutor;
import org.apache.phoenix.pherf.workload.Workload;
import org.apache.phoenix.pherf.workload.WorkloadExecutor;
import org.apache.phoenix.pherf.workload.WriteWorkload;
import org.apache.phoenix.pherf.workload.mt.MultiTenantWorkload;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.DefaultParser;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Options;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pherf {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pherf.class);
    private static final Options options = new Options();
    private final PhoenixUtil phoenixUtil = PhoenixUtil.create();
    private final String zookeeper;
    private final String scenarioFile;
    private final String scenarioName;
    private final String schemaFile;
    private final String queryHint;
    private final Properties globalProperties;
    private final boolean preLoadData;
    private final boolean multiTenantWorkload;
    private final String dropPherfTablesRegEx;
    private final boolean executeQuerySets;
    private final boolean isFunctional;
    private final boolean monitor;
    private final int rowCountOverride;
    private final boolean listFiles;
    private final boolean applySchema;
    private final boolean writeRuntimeResults;
    private final PherfConstants.GeneratePhoenixStats generateStatistics;
    private final String label;
    private final String compareResults;
    private final PherfConstants.CompareType compareType;
    private final boolean thinDriver;
    private final String queryServerUrl;
    private Properties properties = new Properties();
    @VisibleForTesting
    WorkloadExecutor workloadExecutor;

    public Pherf(String[] args, Properties connProperties) throws Exception {
        this(args);
        if (connProperties != null) {
            this.properties.putAll((Map<?, ?>)connProperties);
        }
    }

    public Pherf(String[] args) throws Exception {
        DefaultParser parser = DefaultParser.builder().setAllowPartialMatching(false).setStripLeadingAndTrailingQuotes(false).build();
        CommandLine command = null;
        HelpFormatter hf = new HelpFormatter();
        try {
            command = parser.parse(options, args);
        }
        catch (ParseException e) {
            hf.printHelp("Pherf", options);
            LOGGER.error("Something went wrong while parsing.", (Throwable)e);
            System.exit(1);
        }
        this.globalProperties = PherfConstants.create().getProperties("pherf.properties", false);
        this.dropPherfTablesRegEx = command.getOptionValue("drop");
        this.monitor = command.hasOption("m");
        String monitorFrequency = command.hasOption("m") && command.hasOption("monitorFrequency") ? command.getOptionValue("monitorFrequency") : this.globalProperties.getProperty("pherf.default.monitorFrequency");
        this.globalProperties.setProperty("pherf.default.monitorFrequency", monitorFrequency);
        LOGGER.debug("Using Monitor: " + this.monitor);
        LOGGER.debug("Monitor Frequency Ms:" + monitorFrequency);
        this.globalProperties.setProperty("pherf.default.log_per_nrows", this.getLogPerNRow(command));
        this.preLoadData = command.hasOption("l");
        this.multiTenantWorkload = command.hasOption("mt");
        this.executeQuerySets = command.hasOption("q");
        this.zookeeper = command.getOptionValue("z", "localhost");
        this.queryHint = command.getOptionValue("hint");
        this.isFunctional = command.hasOption("diff");
        this.listFiles = command.hasOption("listFiles");
        this.applySchema = !command.hasOption("disableSchemaApply");
        this.writeRuntimeResults = !command.hasOption("disableRuntimeResult");
        this.scenarioFile = command.hasOption("scenarioFile") ? command.getOptionValue("scenarioFile") : null;
        this.scenarioName = command.hasOption("scenarioName") ? command.getOptionValue("scenarioName") : null;
        this.schemaFile = command.hasOption("schemaFile") ? command.getOptionValue("schemaFile") : null;
        this.rowCountOverride = Integer.parseInt(command.getOptionValue("rowCountOverride", "0"));
        this.generateStatistics = command.hasOption("stats") ? PherfConstants.GeneratePhoenixStats.YES : PherfConstants.GeneratePhoenixStats.NO;
        String writerThreadPoolSize = command.getOptionValue("writerThreadSize", this.globalProperties.getProperty("pherf.default.dataloader.threadpool"));
        this.globalProperties.setProperty("pherf.default.dataloader.threadpool", writerThreadPoolSize);
        this.label = command.getOptionValue("label");
        this.compareResults = command.getOptionValue("compare");
        this.compareType = command.hasOption("useAverageCompareType") ? PherfConstants.CompareType.AVERAGE : PherfConstants.CompareType.MINIMUM;
        this.thinDriver = command.hasOption("thin");
        this.queryServerUrl = this.thinDriver ? command.getOptionValue("server", "http://localhost:8765") : null;
        if (command.hasOption('b')) {
            System.setProperty("pherf.default.dataloader.batchApi", Boolean.TRUE.toString());
        }
        if ((command.hasOption("h") || args == null || args.length == 0) && !command.hasOption("listFiles")) {
            hf.printHelp("Pherf", options);
            System.exit(1);
        }
        PhoenixUtil.setRowCountOverride(this.rowCountOverride);
        if (!this.thinDriver) {
            LOGGER.info("Using thick driver with ZooKeepers '{}'", (Object)this.zookeeper);
            PhoenixUtil.setZookeeper(this.zookeeper);
        } else {
            LOGGER.info("Using thin driver with PQS '{}'", (Object)this.queryServerUrl);
            PhoenixUtil.useThinDriver(this.queryServerUrl);
        }
        ResultUtil.setFileSuffix(this.label);
        this.properties.putAll((Map<?, ?>)this.globalProperties);
    }

    private String getLogPerNRow(CommandLine command) {
        try {
            String logPerNRows;
            String string = logPerNRows = command.hasOption("log_per_nrows") ? command.getOptionValue("log_per_nrows") : this.globalProperties.getProperty("pherf.default.log_per_nrows", String.valueOf(1000000));
            if (Integer.valueOf(logPerNRows) > 0) {
                return logPerNRows;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Invalid Log per N rows value. Phoenix will pick the default value.");
        }
        return String.valueOf(1000000);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static void main(String[] args) {
        try {
            new Pherf(args).run();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Something went wrong.", (Throwable)e);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        MonitorManager monitorManager = null;
        ArrayList<Workload> workloads = new ArrayList<Workload>();
        this.workloadExecutor = new WorkloadExecutor(this.properties, workloads, !this.isFunctional);
        try {
            if (this.listFiles) {
                ResourceList list = new ResourceList("/datamodel");
                Collection<Path> schemaFiles = list.getResourceList(".*.sql");
                System.out.println("Schema Files:");
                for (Path path : schemaFiles) {
                    System.out.println(path);
                }
                list = new ResourceList("/scenario");
                Collection<Path> scenarioFiles = list.getResourceList(PherfConstants.SCENARIO_ROOT_PATTERN + ".xml");
                System.out.println("Scenario Files:");
                for (Path path : scenarioFiles) {
                    System.out.println(path);
                }
                return;
            }
            if (null != this.compareResults) {
                LOGGER.info("\nStarting to compare results and exiting for " + this.compareResults);
                new GoogleChartGenerator(this.compareResults, this.compareType).readAndRender();
                return;
            }
            if (null != this.dropPherfTablesRegEx) {
                LOGGER.info("\nDropping existing table with PHERF namename and " + this.dropPherfTablesRegEx + " regex expression.");
                this.phoenixUtil.deleteTables(this.dropPherfTablesRegEx);
            }
            if (this.applySchema) {
                LOGGER.info("\nStarting to apply schema...");
                SchemaReader reader = this.schemaFile == null ? new SchemaReader(".*.sql") : new SchemaReader(this.schemaFile);
                reader.applySchema();
            }
            if (this.scenarioFile == null) {
                return;
            }
            XMLConfigParser parser = new XMLConfigParser(this.scenarioFile);
            if (this.monitor) {
                monitorManager = new MonitorManager(Integer.parseInt(this.globalProperties.getProperty("pherf.default.monitorFrequency")));
                this.workloadExecutor.add(monitorManager);
            }
            if (this.preLoadData || this.multiTenantWorkload) {
                LOGGER.info("\nStarting Data Load...");
                ArrayList<Workload> newWorkloads = Lists.newArrayList();
                try {
                    if (this.multiTenantWorkload) {
                        for (DataModel dataModel : parser.getDataModels()) {
                            for (Scenario scenario : dataModel.getScenarios()) {
                                if (this.scenarioName != null && this.scenarioName.compareTo(scenario.getName()) != 0) continue;
                                MultiTenantWorkload workload = new MultiTenantWorkload(this.phoenixUtil, dataModel, scenario, this.properties);
                                newWorkloads.add(workload);
                            }
                        }
                    } else {
                        newWorkloads.add(new WriteWorkload(parser, this.properties, this.generateStatistics));
                    }
                    if (newWorkloads.isEmpty()) {
                        throw new IllegalArgumentException("Found no new workload");
                    }
                    for (Workload workload : newWorkloads) {
                        this.workloadExecutor.add(workload);
                    }
                    this.workloadExecutor.get();
                }
                finally {
                    if (!newWorkloads.isEmpty()) {
                        for (Workload workload : newWorkloads) {
                            workload.complete();
                        }
                    }
                }
            } else {
                LOGGER.info("\nSKIPPED: Data Load and schema creation as -l argument not specified");
            }
            if (this.executeQuerySets) {
                LOGGER.info("\nStarting to apply Execute Queries...");
                this.workloadExecutor.add(new QueryExecutor(parser, this.phoenixUtil, this.workloadExecutor, parser.getDataModels(), this.queryHint, this.isFunctional, this.writeRuntimeResults));
            } else {
                LOGGER.info("\nSKIPPED: Multithreaded query set execution as -q argument not specified");
            }
            if (monitorManager != null) {
                LOGGER.info("Run completed. Shutting down Monitor.");
                monitorManager.complete();
            }
            this.workloadExecutor.get();
        }
        finally {
            if (this.workloadExecutor != null) {
                LOGGER.info("Run completed. Shutting down thread pool.");
                this.workloadExecutor.shutdown();
            }
        }
    }

    static {
        options.addOption("disableSchemaApply", "disableSchemaApply", false, "Set to disable schema from being applied.");
        options.addOption("disableRuntimeResult", "disableRuntimeResult", false, "Set to disable writing detailed CSV file during query execution. Those will eventually get written at the end of query execution.");
        options.addOption("z", "zookeeper", true, "HBase Zookeeper address for connection. Default: localhost");
        options.addOption("q", "query", false, "Executes multi-threaded query sets");
        options.addOption("listFiles", "listFiles", false, "List available resource files");
        options.addOption("mt", "multi-tenant", false, "Multi tenanted workloads based on load profiles.");
        options.addOption("l", "load", false, "Pre-loads data according to specified configuration values.");
        options.addOption("scenarioFile", "scenarioFile", true, "Regex or file name for the Test Scenario configuration .xml file to use.");
        options.addOption("scenarioName", "scenarioName", true, "Regex or scenario name from the Test Scenario configuration .xml file to use.");
        options.addOption("drop", "drop", true, "Regex drop all tables with schema name as PHERF. \nExample drop Event tables: -drop .*(EVENT).* Drop all: -drop .* or -drop all");
        options.addOption("schemaFile", "schemaFile", true, "Regex or file name for the Test phoenix table schema .sql to use.");
        options.addOption("m", "monitor", false, "Launch the stats profilers");
        options.addOption("monitorFrequency", "monitorFrequency", true, "Override for frequency in Ms for which monitor should log stats. \n See pherf.default.monitorFrequency in pherf.properties");
        options.addOption("rowCountOverride", "rowCountOverride", true, "Row count override to use instead of one specified in scenario.");
        options.addOption("hint", "hint", true, "Executes all queries with specified hint. Example SMALL");
        options.addOption("log_per_nrows", "log_per_nrows", true, "Default value to display log line after every 'N' row load");
        options.addOption("diff", "diff", false, "Run pherf in verification mode and diff with exported results");
        options.addOption("export", "export", false, "Exports query results to CSV files in CSV_EXPORT directory");
        options.addOption("writerThreadSize", "writerThreadSize", true, "Override the default number of writer threads. See pherf.default.dataloader.threadpool in Pherf.properties.");
        options.addOption("h", "help", false, "Get help on using this utility.");
        options.addOption("d", "debug", false, "Put tool in debug mode");
        options.addOption("stats", "stats", false, "Update Phoenix Statistics after data is loaded with -l argument");
        options.addOption("label", "label", true, "Label a run. Result file name will be suffixed with specified label");
        options.addOption("compare", "compare", true, "Specify labeled run(s) to compare");
        options.addOption("useAverageCompareType", "useAverageCompareType", false, "Compare results with Average query time instead of default is Minimum query time.");
        options.addOption("t", "thin", false, "Use the Phoenix Thin Driver");
        options.addOption("s", "server", true, "The URL for the Phoenix QueryServer");
        options.addOption("b", "batchApi", false, "Use JDBC Batch API for writes");
    }
}

