# mapResponseHeaders

@@@ div { .group-scala }

## Signature

@@signature [BasicDirectives.scala](/http/src/main/scala/org/apache/pekko/http/scaladsl/server/directives/BasicDirectives.scala) { #mapResponseHeaders }

@@@

## Description

Changes the list of response headers that was generated by the inner route.

The `mapResponseHeaders` directive is used as a building block for @ref[Custom Directives](../custom-directives.md) to transform the list of
response headers that was generated by the inner route.

See @ref[Response Transforming Directives](index.md#response-transforming-directives) for similar directives.

## Example

Scala
:  @@snip [BasicDirectivesExamplesSpec.scala](/docs/src/test/scala/docs/http/scaladsl/server/directives/BasicDirectivesExamplesSpec.scala) { #mapResponseHeaders }

Java
:  @@snip [BasicDirectivesExamplesTest.java](/docs/src/test/java/docs/http/javadsl/server/directives/BasicDirectivesExamplesTest.java) { #mapResponseHeaders }
