/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.common.PDMetadata;

public class ExtractXMP {
    private static final String PASSWORD = "-password";
    private static final String CONSOLE = "-console";
    private static final String PAGE = "-page";

    public static void main(String[] args) throws IOException {
        System.setProperty("apple.awt.UIElement", "true");
        ExtractXMP extractor = new ExtractXMP();
        extractor.startExtraction(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startExtraction(String[] args) throws IOException {
        boolean toConsole = false;
        String password = "";
        int page = 0;
        String pdfFile = null;
        String outputFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    ExtractXMP.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(PAGE)) {
                if (++i >= args.length) {
                    ExtractXMP.usage();
                }
                page = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals(CONSOLE)) {
                toConsole = true;
                continue;
            }
            if (pdfFile == null) {
                pdfFile = args[i];
                continue;
            }
            outputFile = args[i];
        }
        if (pdfFile == null) {
            ExtractXMP.usage();
        } else {
            PrintStream output = null;
            PDDocument document = null;
            try {
                PDMetadata meta;
                if (outputFile == null && pdfFile.length() > 4) {
                    outputFile = new File(pdfFile.substring(0, pdfFile.length() - 4) + ".xml").getAbsolutePath();
                }
                document = PDDocument.load((File)new File(pdfFile), (String)password);
                PDDocumentCatalog catalog = document.getDocumentCatalog();
                if (page == 0) {
                    meta = catalog.getMetadata();
                } else {
                    if (page > document.getNumberOfPages()) {
                        System.err.println("Page " + page + " doesn't exist");
                        System.exit(1);
                    }
                    meta = document.getPage(page - 1).getMetadata();
                }
                if (meta == null) {
                    System.err.println("No XMP metadata available");
                    System.exit(1);
                }
                output = toConsole ? System.out : new PrintStream(outputFile);
                output.write(meta.toByteArray());
                output.close();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(output);
                IOUtils.closeQuietly(document);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)output);
            IOUtils.closeQuietly((Closeable)document);
        }
        System.exit(0);
    }

    private static void usage() {
        String message = "Usage: java -jar pdfbox-app-x.y.z.jar ExtractXMP [options] <inputfile> [output-text-file]\n\nOptions:\n  -password <password>        : Password to decrypt document\n  -console                    : Send text to console instead of file\n  -page <number>              : The optional page to extract XMP (1 based)\n  <inputfile>                 : The PDF document to use\n  [output-xml-file]           : The file to write the XMP to";
        System.err.println(message);
        System.exit(1);
    }
}

