/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.flow;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiActivateCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;
import org.apache.nifi.web.api.entity.ReportingTaskRunStatusEntity;
import org.apache.nifi.web.api.entity.ReportingTasksEntity;

public class StartReportingTasks
extends AbstractNiFiActivateCommand<ReportingTaskEntity, ReportingTaskRunStatusEntity> {
    public StartReportingTasks() {
        super("start-reporting-tasks");
    }

    @Override
    public String getDescription() {
        return "Starts any enabled and valid reporting tasks.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.RT_ID.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String rtId = this.getArg(properties, CommandOption.RT_ID);
        HashSet<ReportingTaskEntity> reportingTaskEntities = new HashSet<ReportingTaskEntity>();
        if (StringUtils.isBlank((CharSequence)rtId)) {
            ReportingTasksEntity reportingTasksEntity = client.getFlowClient().getReportingTasks();
            reportingTaskEntities.addAll(reportingTasksEntity.getReportingTasks());
        } else {
            reportingTaskEntities.add(client.getReportingTasksClient().getReportingTask(rtId));
        }
        this.activate(client, properties, reportingTaskEntities, "RUNNING");
        return VoidResult.getInstance();
    }

    @Override
    public ReportingTaskRunStatusEntity getRunStatusEntity() {
        return new ReportingTaskRunStatusEntity();
    }

    @Override
    public ReportingTaskEntity activateComponent(NiFiClient client, ReportingTaskEntity reportingTaskEntity, ReportingTaskRunStatusEntity runStatusEntity) throws NiFiClientException, IOException {
        return client.getReportingTasksClient().activateReportingTask(reportingTaskEntity.getId(), runStatusEntity);
    }

    @Override
    public String getDispName(ReportingTaskEntity reportingTaskEntity) {
        return "Reporting task \"" + reportingTaskEntity.getComponent().getName() + "\" (id: " + reportingTaskEntity.getId() + ")";
    }
}

