/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.ssl;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import org.apache.nifi.security.ssl.BuilderConfigurationException;
import org.apache.nifi.security.ssl.KeyManagerFactoryBuilder;

public class StandardKeyManagerFactoryBuilder
implements KeyManagerFactoryBuilder {
    private KeyStore keyStore;
    private char[] keyPassword;

    @Override
    public KeyManagerFactory build() {
        KeyManagerFactory keyManagerFactory;
        if (this.keyStore == null) {
            keyManagerFactory = null;
        } else {
            keyManagerFactory = this.getKeyManagerFactory();
            try {
                keyManagerFactory.init(this.keyStore, this.keyPassword);
            }
            catch (GeneralSecurityException e) {
                throw new BuilderConfigurationException("Key Manager Factory initialization failed", e);
            }
        }
        return keyManagerFactory;
    }

    public StandardKeyManagerFactoryBuilder keyStore(KeyStore keyStore) {
        this.keyStore = Objects.requireNonNull(keyStore, "Key Store required");
        return this;
    }

    public StandardKeyManagerFactoryBuilder keyPassword(char[] keyPassword) {
        this.keyPassword = Objects.requireNonNull(keyPassword, "Key Password required");
        return this;
    }

    private KeyManagerFactory getKeyManagerFactory() {
        String algorithm = KeyManagerFactory.getDefaultAlgorithm();
        try {
            return KeyManagerFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            String message = String.format("KeyManagerFactory creation failed with algorithm [%s]", algorithm);
            throw new BuilderConfigurationException(message, e);
        }
    }
}

