/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.ssl;

import java.security.KeyStore;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.nifi.security.ssl.BuilderConfigurationException;
import org.apache.nifi.security.ssl.KeyManagerBuilder;
import org.apache.nifi.security.ssl.StandardKeyManagerFactoryBuilder;

public class StandardKeyManagerBuilder
implements KeyManagerBuilder {
    private KeyStore keyStore;
    private char[] keyPassword;

    @Override
    public X509ExtendedKeyManager build() {
        KeyManager[] keyManagers = this.getKeyManagers();
        if (keyManagers == null) {
            throw new BuilderConfigurationException("Key Managers not found: Key Store required");
        }
        Optional<X509ExtendedKeyManager> configuredKeyManager = Arrays.stream(keyManagers).filter(keyManager -> keyManager instanceof X509ExtendedKeyManager).map(keyManager -> (X509ExtendedKeyManager)keyManager).findFirst();
        return configuredKeyManager.orElseThrow(() -> new BuilderConfigurationException("X.509 Extended Key Manager not found"));
    }

    public StandardKeyManagerBuilder keyStore(KeyStore keyStore) {
        this.keyStore = Objects.requireNonNull(keyStore, "Key Store required");
        return this;
    }

    public StandardKeyManagerBuilder keyPassword(char[] keyPassword) {
        this.keyPassword = Objects.requireNonNull(keyPassword, "Key Password required");
        return this;
    }

    private KeyManager[] getKeyManagers() {
        KeyManager[] keyManagers;
        if (this.keyStore == null) {
            keyManagers = null;
        } else {
            KeyManagerFactory keyManagerFactory = new StandardKeyManagerFactoryBuilder().keyStore(this.keyStore).keyPassword(this.keyPassword).build();
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        return keyManagers;
    }
}

