/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.aggregator;

import java.util.function.BiFunction;
import org.springframework.integration.aggregator.GroupConditionProvider;
import org.springframework.integration.aggregator.ReleaseStrategy;
import org.springframework.integration.file.splitter.FileSplitter;
import org.springframework.integration.store.MessageGroup;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public class FileMarkerReleaseStrategy
implements ReleaseStrategy,
GroupConditionProvider {
    public static final BiFunction<Message<?>, String, String> GROUP_CONDITION = (message, existingCondition) -> {
        MessageHeaders headers = message.getHeaders();
        if (FileSplitter.FileMarker.Mark.END.name().equals(headers.get((Object)"file_marker"))) {
            Long lineCount = (Long)headers.get((Object)"file_lineCount", Long.class);
            return lineCount != null ? "" + lineCount : existingCondition;
        }
        return existingCondition;
    };

    public boolean canRelease(MessageGroup group) {
        String condition;
        int size = group.size();
        if (size > 1 && (condition = group.getCondition()) != null) {
            long lineCount = Long.parseLong(condition);
            return lineCount == (long)(size - 2);
        }
        return false;
    }

    public BiFunction<Message<?>, String, String> getGroupConditionSupplier() {
        return GROUP_CONDITION;
    }
}

