/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import org.apache.camel.api.management.JmxNotificationBroadcasterAware;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxNotificationEventNotifier
extends EventNotifierSupport
implements JmxNotificationBroadcasterAware {
    private static final Logger LOG = LoggerFactory.getLogger(JmxNotificationEventNotifier.class);
    private final AtomicLong counter = new AtomicLong();
    private NotificationBroadcasterSupport notificationBroadcaster;
    private String source = "Camel";

    public void setNotificationBroadcaster(NotificationBroadcasterSupport broadcaster) {
        this.notificationBroadcaster = broadcaster;
    }

    public void notify(CamelEvent event) throws Exception {
        if (this.notificationBroadcaster != null) {
            String type = event.getClass().getSimpleName();
            String message = event.toString();
            Notification notification = new Notification(type, (Object)this.source, this.counter.getAndIncrement(), message);
            LOG.trace("Broadcasting JMX notification: {}", (Object)notification);
            this.notificationBroadcaster.sendNotification(notification);
        }
    }

    public boolean isEnabled(CamelEvent event) {
        return true;
    }

    protected void doStart() throws Exception {
        this.counter.set(0L);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

