/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.equinox.internal.region.StandardRegionFilter;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public final class StandardRegionFilterBuilder
implements RegionFilterBuilder {
    private final Object monitor = new Object();
    private final Map<String, Collection<Filter>> policy = new HashMap<String, Collection<Filter>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegionFilterBuilder allow(String namespace, String filter) throws InvalidSyntaxException {
        if (namespace == null) {
            throw new IllegalArgumentException("The namespace must not be null.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("The filter must not be null.");
        }
        Object object = this.monitor;
        synchronized (object) {
            Collection<Filter> namespaceFilters = this.getNamespaceFilters(namespace);
            namespaceFilters.add(StandardRegionFilterBuilder.createFilter(filter));
        }
        if ("org.eclipse.equinox.allow.service".equals(namespace)) {
            this.allow("osgi.service", filter);
        }
        return this;
    }

    public static Filter createFilter(String spec) throws InvalidSyntaxException {
        Filter filter = FrameworkUtil.createFilter((String)spec);
        return StandardRegionFilter.ALL.equals((Object)filter) ? StandardRegionFilter.ALL : filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegionFilterBuilder allowAll(String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException("The namespace must not be null.");
        }
        Object object = this.monitor;
        synchronized (object) {
            Collection<Filter> namespaceFilters = this.getNamespaceFilters(namespace);
            namespaceFilters.clear();
            namespaceFilters.add(StandardRegionFilter.ALL);
        }
        if ("org.eclipse.equinox.allow.service".equals(namespace)) {
            this.allowAll("osgi.service");
        }
        return this;
    }

    private Collection<Filter> getNamespaceFilters(String namespace) {
        Collection<Filter> namespaceFilters = this.policy.get(namespace);
        if (namespaceFilters == null) {
            namespaceFilters = new LinkedHashSet<Filter>();
            this.policy.put(namespace, namespaceFilters);
        }
        return namespaceFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegionFilter build() {
        Object object = this.monitor;
        synchronized (object) {
            return new StandardRegionFilter(this.policy);
        }
    }
}

