/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ConnectHandler;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;

public class WelcomeMessageHandler
implements ConnectHandler<SMTPSession> {
    private static final String SERVICE_TYPE = "SMTP";

    public Response onConnect(SMTPSession session) {
        return this.computeGreetings(session, session.getConfiguration().getGreeting());
    }

    private SMTPResponse computeGreetings(SMTPSession session, String smtpGreeting) {
        if (smtpGreeting == null) {
            return new SMTPResponse("220", new StringBuilder(256).append(session.getConfiguration().getHelloName()).append(" ").append(this.getServiceType()).append(" Server (").append(session.getConfiguration().getSoftwareName()).append(") ready"));
        }
        return new SMTPResponse("220", smtpGreeting);
    }

    protected String getServiceType() {
        return SERVICE_TYPE;
    }
}

