/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tika.parser.microsoft.onenote.ExtendedGUID;
import org.apache.tika.parser.microsoft.onenote.FileChunkReference;
import org.apache.tika.parser.microsoft.onenote.FileNode;
import org.apache.tika.parser.microsoft.onenote.FileNodeList;
import org.apache.tika.parser.microsoft.onenote.FileNodePtr;
import org.apache.tika.parser.microsoft.onenote.OneNoteHeader;
import org.apache.tika.parser.microsoft.onenote.Revision;

class OneNoteDocument {
    OneNoteHeader header;
    List<ExtendedGUID> revisionListOrder = new ArrayList<ExtendedGUID>();
    Map<ExtendedGUID, Revision> revisionMap = new HashMap<ExtendedGUID, Revision>();
    Map<ExtendedGUID, FileNodePtr> revisionManifestLists = new HashMap<ExtendedGUID, FileNodePtr>();
    Map<ExtendedGUID, FileChunkReference> guidToRef = new HashMap<ExtendedGUID, FileChunkReference>();
    Map<ExtendedGUID, FileNodePtr> guidToObject = new HashMap<ExtendedGUID, FileNodePtr>();
    Map<ExtendedGUID, Pair<Long, ExtendedGUID>> revisionRoleMap = new HashMap<ExtendedGUID, Pair<Long, ExtendedGUID>>();
    ExtendedGUID currentRevision = ExtendedGUID.nil();
    FileNodeList root = new FileNodeList();

    FileChunkReference getAssocGuidToRef(ExtendedGUID guid) {
        return this.guidToRef.get(guid);
    }

    void setAssocGuidToRef(ExtendedGUID guid, FileChunkReference ref) {
        this.guidToRef.put(guid, ref);
    }

    void registerRevisionManifestList(ExtendedGUID guid, FileNodePtr ptr) {
        this.revisionManifestLists.put(guid, ptr);
        this.revisionListOrder.add(guid);
    }

    void registerRevisionManifest(FileNode fn) {
        this.revisionMap.putIfAbsent(fn.gosid, new Revision());
        Revision toModify = this.revisionMap.get(fn.gosid);
        toModify.gosid = fn.gosid;
        toModify.dependent = fn.subType.revisionManifest.ridDependent;
        this.currentRevision = fn.gosid;
    }

    public void registerAdditionalRevisionRole(ExtendedGUID gosid, long revisionRole, ExtendedGUID gctxid) {
        this.revisionRoleMap.put(gosid, Pair.of(revisionRole, gctxid));
    }

    public List<ExtendedGUID> getRevisionListOrder() {
        return this.revisionListOrder;
    }

    public OneNoteDocument setRevisionListOrder(List<ExtendedGUID> revisionListOrder) {
        this.revisionListOrder = revisionListOrder;
        return this;
    }

    public Map<ExtendedGUID, Revision> getRevisionMap() {
        return this.revisionMap;
    }

    public OneNoteDocument setRevisionMap(Map<ExtendedGUID, Revision> revisionMap) {
        this.revisionMap = revisionMap;
        return this;
    }

    public Map<ExtendedGUID, FileNodePtr> getRevisionManifestLists() {
        return this.revisionManifestLists;
    }

    public OneNoteDocument setRevisionManifestLists(Map<ExtendedGUID, FileNodePtr> revisionManifestLists) {
        this.revisionManifestLists = revisionManifestLists;
        return this;
    }

    public Map<ExtendedGUID, FileChunkReference> getGuidToRef() {
        return this.guidToRef;
    }

    public OneNoteDocument setGuidToRef(Map<ExtendedGUID, FileChunkReference> guidToRef) {
        this.guidToRef = guidToRef;
        return this;
    }

    public Map<ExtendedGUID, FileNodePtr> getGuidToObject() {
        return this.guidToObject;
    }

    public OneNoteDocument setGuidToObject(Map<ExtendedGUID, FileNodePtr> guidToObject) {
        this.guidToObject = guidToObject;
        return this;
    }

    public Map<ExtendedGUID, Pair<Long, ExtendedGUID>> getRevisionRoleMap() {
        return this.revisionRoleMap;
    }

    public OneNoteDocument setRevisionRoleMap(Map<ExtendedGUID, Pair<Long, ExtendedGUID>> revisionRoleMap) {
        this.revisionRoleMap = revisionRoleMap;
        return this;
    }

    public ExtendedGUID getCurrentRevision() {
        return this.currentRevision;
    }

    public OneNoteDocument setCurrentRevision(ExtendedGUID currentRevision) {
        this.currentRevision = currentRevision;
        return this;
    }

    public FileNodeList getRoot() {
        return this.root;
    }

    public OneNoteDocument setRoot(FileNodeList root) {
        this.root = root;
        return this;
    }
}

