/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.indesign;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

class ContentAndMetadataExtractor {
    private static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();

    ContentAndMetadataExtractor() {
    }

    static void extract(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XMLReaderUtils.parseSAX(new CloseShieldInputStream(stream), new ContentAndMetadataHandler(handler, metadata), context);
    }

    static class ContentAndMetadataHandler
    extends DefaultHandler {
        private final ContentHandler handler;
        private final Metadata metadata;
        private boolean inContent = false;

        ContentAndMetadataHandler(ContentHandler handler, Metadata metadata) {
            this.handler = handler;
            this.metadata = metadata;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("Spread".equals(localName) || "MasterSpread".equals(localName)) {
                this.metadata.add("PageCount", attributes.getValue("PageCount"));
            }
            if ("Content".equals(localName)) {
                this.inContent = true;
                this.handler.startElement("http://www.w3.org/1999/xhtml", "p", "p", EMPTY_ATTRIBUTES);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inContent) {
                this.handler.characters(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("Content".equals(localName)) {
                this.inContent = false;
                this.handler.endElement("http://www.w3.org/1999/xhtml", "p", "p");
            }
        }
    }
}

