/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.info;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.chain.Context;
import org.apache.jackrabbit.standalone.cli.CommandException;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

final class PrintHelper {
    private PrintHelper() {
    }

    public static void printRow(Context ctx, int[] width, String[] text) {
        if (width.length != text.length) {
            throw new IllegalArgumentException("width[] and text[] haven't the same length");
        }
        PrintWriter out = CommandHelper.getOutput(ctx);
        int rows = 1;
        for (int i = 0; i < text.length; ++i) {
            int columnWidth;
            int neededRows;
            int textLength = text[i].length();
            if (textLength == 0) {
                textLength = 1;
            }
            if ((neededRows = (int)Math.ceil((double)textLength / (double)(columnWidth = width[i]))) <= rows) continue;
            rows = neededRows;
        }
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < width.length; ++column) {
                for (int pointer = 0; pointer < width[column]; ++pointer) {
                    int pos = row * width[column] + pointer;
                    if (pos < text[column].length()) {
                        out.print(text[column].charAt(pos));
                        continue;
                    }
                    out.print(' ');
                }
                out.print(' ');
            }
            out.println();
        }
    }

    public static void printSeparatorRow(Context ctx, int[] width, char separator) {
        PrintWriter out = CommandHelper.getOutput(ctx);
        for (int i = 0; i < width.length; ++i) {
            for (int j = 0; j <= width[i]; ++j) {
                if (j < width[i]) {
                    out.print(separator);
                    continue;
                }
                out.print(' ');
            }
        }
        out.println();
    }

    public static void printRow(Context ctx, int[] width, Collection texts) throws CommandException {
        String[] text = new String[width.length];
        Iterator iter = texts.iterator();
        int column = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o == null) {
                text[column] = "";
            } else if (o instanceof String) {
                text[column] = (String)o;
            } else if (o instanceof Collection) {
                StringBuffer sb = new StringBuffer();
                for (String str : (Collection)o) {
                    int rows = (int)Math.ceil((double)str.length() / (double)width[column]);
                    if (rows == 0) {
                        rows = 1;
                    }
                    sb.append(str);
                    for (int j = 0; j < rows * width[column] - str.length(); ++j) {
                        sb.append(' ');
                    }
                }
                text[column] = sb.toString();
            } else {
                throw new CommandException("exception.illegalargument");
            }
            ++column;
        }
        PrintHelper.printRow(ctx, width, text);
    }

    public static void printRow(Context ctx, Collection widths, Collection texts) throws CommandException {
        PrintHelper.printRow(ctx, PrintHelper.convertWidth(widths), texts);
    }

    private static int[] convertWidth(Collection widths) throws CommandException {
        int[] width = new int[widths.size()];
        int index = 0;
        for (Integer i : widths) {
            width[index] = i;
            ++index;
        }
        return width;
    }

    public static void printSeparatorRow(Context ctx, Collection widths, char separator) throws CommandException {
        PrintHelper.printSeparatorRow(ctx, PrintHelper.convertWidth(widths), separator);
    }
}

