/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.queryengine.plan.relational.function.OperatorType;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeSignature;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.read.common.type.Type;

public class OperatorNotFoundException
extends IoTDBException {
    private final OperatorType operatorType;
    private final TypeSignature returnType;
    private final List<Type> argumentTypes;

    public OperatorNotFoundException(OperatorType operatorType, List<? extends Type> argumentTypes, Throwable cause) {
        super(OperatorNotFoundException.formatErrorMessage(operatorType, argumentTypes, Optional.empty()), cause, TSStatusCode.OPERATOR_NOT_FOUND.getStatusCode());
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.returnType = null;
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
    }

    public OperatorNotFoundException(OperatorType operatorType, List<? extends Type> argumentTypes, TypeSignature returnType, Throwable cause) {
        super(OperatorNotFoundException.formatErrorMessage(operatorType, argumentTypes, Optional.of(returnType)), cause, TSStatusCode.OPERATOR_NOT_FOUND.getStatusCode());
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
    }

    private static String formatErrorMessage(OperatorType operatorType, List<? extends Type> argumentTypes, Optional<TypeSignature> returnType) {
        switch (operatorType) {
            case ADD: 
            case SUBTRACT: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULUS: 
            case EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                return String.format("Cannot apply operator: %s %s %s", argumentTypes.get(0), operatorType.getOperator(), argumentTypes.get(1));
            }
            case NEGATION: {
                return String.format("Cannot negate %s", argumentTypes.get(0));
            }
            case IS_DISTINCT_FROM: {
                return String.format("Cannot check if %s is distinct from %s", argumentTypes.get(0), argumentTypes.get(1));
            }
            case CAST: {
                return String.format("Cannot cast %s to %s", argumentTypes.get(0), returnType.orElseThrow(() -> new NoSuchElementException("No value present")));
            }
            case SUBSCRIPT: {
                return String.format("Cannot use %s for subscript of %s", argumentTypes.get(1), argumentTypes.get(0));
            }
        }
        return String.format("Operator '%s'%s cannot be applied to %s", operatorType.getOperator(), returnType.map(value -> ":" + value).orElse(""), Joiner.on((String)", ").join(argumentTypes));
    }

    public OperatorType getOperatorType() {
        return this.operatorType;
    }

    public TypeSignature getReturnType() {
        return this.returnType;
    }

    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }
}

