/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Fill;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GroupBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Offset;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.OrderBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QueryBody;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Relation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Select;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WindowDefinition;

public class QuerySpecification
extends QueryBody {
    private final Select select;
    private final Optional<Relation> from;
    private final Optional<Expression> where;
    private final Optional<GroupBy> groupBy;
    private final Optional<Expression> having;
    private final Optional<Fill> fill;
    private final List<WindowDefinition> windows;
    private final Optional<OrderBy> orderBy;
    private final Optional<Offset> offset;
    private final Optional<Node> limit;

    public QuerySpecification(Select select, Optional<Relation> from, Optional<Expression> where, Optional<GroupBy> groupBy, Optional<Expression> having, Optional<Fill> fill, List<WindowDefinition> windows, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<Node> limit) {
        this(null, select, from, where, groupBy, having, fill, windows, orderBy, offset, limit);
    }

    public QuerySpecification(NodeLocation location, Select select, Optional<Relation> from, Optional<Expression> where, Optional<GroupBy> groupBy, Optional<Expression> having, Optional<Fill> fill, List<WindowDefinition> windows, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<Node> limit) {
        super(location);
        this.select = Objects.requireNonNull(select, "select is null");
        this.from = Objects.requireNonNull(from, "from is null");
        this.where = Objects.requireNonNull(where, "where is null");
        this.groupBy = Objects.requireNonNull(groupBy, "groupBy is null");
        this.having = Objects.requireNonNull(having, "having is null");
        this.fill = Objects.requireNonNull(fill, "fill is null");
        this.windows = Objects.requireNonNull(windows, "windows is null");
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
        this.offset = Objects.requireNonNull(offset, "offset is null");
        this.limit = Objects.requireNonNull(limit, "limit is null");
    }

    public Select getSelect() {
        return this.select;
    }

    public Optional<Relation> getFrom() {
        return this.from;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    public Optional<GroupBy> getGroupBy() {
        return this.groupBy;
    }

    public Optional<Expression> getHaving() {
        return this.having;
    }

    public Optional<Fill> getFill() {
        return this.fill;
    }

    public List<WindowDefinition> getWindows() {
        return this.windows;
    }

    public Optional<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public Optional<Offset> getOffset() {
        return this.offset;
    }

    public Optional<Node> getLimit() {
        return this.limit;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuerySpecification(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)this.select);
        this.from.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.where.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.groupBy.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.having.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.fill.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.orderBy.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.offset.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.limit.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("select", (Object)this.select).add("from", this.from).add("where", this.where.orElse(null)).add("groupBy", this.groupBy).add("having", this.having.orElse(null)).add("fill", this.fill.orElse(null)).add("orderBy", this.orderBy).add("offset", this.offset.orElse(null)).add("limit", this.limit.orElse(null)).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QuerySpecification o = (QuerySpecification)obj;
        return Objects.equals(this.select, o.select) && Objects.equals(this.from, o.from) && Objects.equals(this.where, o.where) && Objects.equals(this.groupBy, o.groupBy) && Objects.equals(this.having, o.having) && Objects.equals(this.fill, o.fill) && Objects.equals(this.orderBy, o.orderBy) && Objects.equals(this.offset, o.offset) && Objects.equals(this.limit, o.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.select, this.from, this.where, this.groupBy, this.having, this.fill, this.orderBy, this.offset, this.limit);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return QuerySpecification.sameClass(this, other);
    }
}

