/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Relation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetOperation;

public final class Except
extends SetOperation {
    private final Relation left;
    private final Relation right;

    public Except(Relation left, Relation right, boolean distinct) {
        super(null, distinct);
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
    }

    public Except(NodeLocation location, Relation left, Relation right, boolean distinct) {
        super(Objects.requireNonNull(location, "location is null"), distinct);
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
    }

    public Relation getLeft() {
        return this.left;
    }

    public Relation getRight() {
        return this.right;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExcept(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    public List<Relation> getRelations() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("left", (Object)this.left).add("right", (Object)this.right).add("distinct", this.isDistinct()).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Except o = (Except)obj;
        return Objects.equals(this.left, o.left) && Objects.equals(this.right, o.right) && Objects.equals(this.isDistinct(), o.isDistinct());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left, this.right, this.isDistinct());
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Except.sameClass(this, other)) {
            return false;
        }
        return this.isDistinct() == ((Except)other).isDistinct();
    }
}

