/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.tsfile;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTsFileResourceSegmentLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTsFileResourceSegmentLock.class);
    private static final int SEGMENT_LOCK_MIN_SIZE = 32;
    private static final int SEGMENT_LOCK_MAX_SIZE = 128;
    private volatile ReentrantLock[] locks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNecessary() {
        if (this.locks == null) {
            PipeTsFileResourceSegmentLock pipeTsFileResourceSegmentLock = this;
            synchronized (pipeTsFileResourceSegmentLock) {
                if (this.locks == null) {
                    int lockSegmentSize = 32;
                    try {
                        lockSegmentSize = StorageEngine.getInstance().getAllDataRegionIds().size();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot get data region ids, use default lock segment size: {}", (Object)lockSegmentSize);
                    }
                    lockSegmentSize = Math.min(128, lockSegmentSize);
                    lockSegmentSize = Math.max(32, lockSegmentSize);
                    ReentrantLock[] tmpLocks = new ReentrantLock[lockSegmentSize];
                    for (int i = 0; i < tmpLocks.length; ++i) {
                        tmpLocks[i] = new ReentrantLock();
                    }
                    this.locks = tmpLocks;
                }
            }
        }
    }

    public void lock(File file) {
        this.initIfNecessary();
        this.locks[Math.abs(file.hashCode()) % this.locks.length].lock();
    }

    public boolean tryLock(File file, long timeout, TimeUnit timeUnit) throws InterruptedException {
        this.initIfNecessary();
        return this.locks[Math.abs(file.hashCode()) % this.locks.length].tryLock(timeout, timeUnit);
    }

    public boolean tryLockAll(long timeout, TimeUnit timeUnit) throws InterruptedException {
        this.initIfNecessary();
        int alreadyLocked = 0;
        for (ReentrantLock lock : this.locks) {
            if (!lock.tryLock(timeout, timeUnit)) break;
            ++alreadyLocked;
        }
        if (alreadyLocked == this.locks.length) {
            return true;
        }
        this.unlockUntil(alreadyLocked);
        return false;
    }

    private void unlockUntil(int index) {
        for (int i = 0; i < index; ++i) {
            this.locks[i].unlock();
        }
    }

    public void unlock(File file) {
        this.initIfNecessary();
        this.locks[Math.abs(file.hashCode()) % this.locks.length].unlock();
    }

    public void unlockAll() {
        this.initIfNecessary();
        this.unlockUntil(this.locks.length);
    }
}

