/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.FieldId;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ResolvedField;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Scope;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.util.AstUtil;

final class ScopeReferenceExtractor {
    private ScopeReferenceExtractor() {
    }

    public static boolean hasReferencesToScope(Node node, Analysis analysis, Scope scope) {
        return ScopeReferenceExtractor.getReferencesToScope(node, analysis, scope).findAny().isPresent();
    }

    public static Stream<Expression> getReferencesToScope(Node node, Analysis analysis, Scope scope) {
        Map<NodeRef<Expression>, ResolvedField> columnReferences = analysis.getColumnReferenceFields();
        return AstUtil.preOrder(node).filter(Expression.class::isInstance).map(Expression.class::cast).filter(expression -> columnReferences.containsKey(NodeRef.of(expression))).filter(expression -> ScopeReferenceExtractor.isReferenceToScope(expression, scope, columnReferences));
    }

    private static boolean isReferenceToScope(Expression node, Scope scope, Map<NodeRef<Expression>, ResolvedField> columnReferences) {
        ResolvedField field = columnReferences.get(NodeRef.of(node));
        Objects.requireNonNull(field, () -> "No Field for " + node);
        return ScopeReferenceExtractor.isFieldFromScope(field.getFieldId(), scope);
    }

    public static boolean isFieldFromScope(FieldId field, Scope scope) {
        return Objects.equals(field.getRelationId(), scope.getRelationId());
    }
}

