/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.memory;

import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.plan.planner.memory.PipelineMemoryEstimator;

public class ConsumeChildrenOneByOnePipelineMemoryEstimator
extends PipelineMemoryEstimator {
    private long concurrentRunningChildrenNum = -1L;
    private boolean concurrentRunningChildrenNumInitialized = false;

    public ConsumeChildrenOneByOnePipelineMemoryEstimator(Operator root, int dependencyPipelineIndex) {
        super(root, dependencyPipelineIndex);
    }

    @Override
    public long calculateEstimatedRunningMemorySize() {
        return this.children.isEmpty() ? this.root.calculateMaxPeekMemoryWithCounter() : (long)((double)this.root.calculateMaxPeekMemoryWithCounter() + (double)this.children.stream().map(PipelineMemoryEstimator::calculateEstimatedRunningMemorySize).reduce(0L, Long::sum).longValue() / (double)this.children.size() * (double)this.getConcurrentRunningChildrenNum());
    }

    private long getConcurrentRunningChildrenNum() {
        if (this.concurrentRunningChildrenNumInitialized) {
            return this.concurrentRunningChildrenNum;
        }
        this.concurrentRunningChildrenNum = this.children.stream().filter(memoryEstimator -> memoryEstimator.getDependencyPipelineIndex() == -1).count();
        this.concurrentRunningChildrenNumInitialized = true;
        return this.concurrentRunningChildrenNum;
    }

    @TestOnly
    public long getConcurrentRunningChildrenNumForTest() {
        return this.children.stream().filter(memoryEstimator -> memoryEstimator.getDependencyPipelineIndex() == -1).count();
    }
}

