/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor.predicate;

import java.util.ArrayList;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.binary.ArithmeticBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.CompareBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.WhenThenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.LeafOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.NullOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.other.CaseWhenThenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.other.GroupByTimeExpression;
import org.apache.iotdb.db.queryengine.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.InExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.IsNullExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.NegationExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.RegularExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionAnalyzeVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.predicate.ConvertPredicateToFilterVisitor;

public class PredicateSimplifier
extends ExpressionAnalyzeVisitor<Expression, Void> {
    @Override
    public Expression visitIsNullExpression(IsNullExpression isNullExpression, Void context) {
        Expression simplifiedInputExpression = (Expression)this.process(isNullExpression.getExpression(), context);
        if (simplifiedInputExpression.getExpressionType().equals((Object)ExpressionType.NULL)) {
            if (isNullExpression.isNot()) {
                return ConstantOperand.FALSE;
            }
            return ConstantOperand.TRUE;
        }
        isNullExpression.setExpression(simplifiedInputExpression);
        return isNullExpression;
    }

    @Override
    public Expression visitInExpression(InExpression inExpression, Void context) {
        return this.processFilterUnaryExpression(inExpression, context);
    }

    @Override
    public Expression visitLikeExpression(LikeExpression likeExpression, Void context) {
        return this.processFilterUnaryExpression(likeExpression, context);
    }

    @Override
    public Expression visitRegularExpression(RegularExpression regularExpression, Void context) {
        return this.processFilterUnaryExpression(regularExpression, context);
    }

    private Expression processFilterUnaryExpression(UnaryExpression unaryExpression, Void context) {
        Expression simplifiedInputExpression = (Expression)this.process(unaryExpression.getExpression(), context);
        if (simplifiedInputExpression.getExpressionType().equals((Object)ExpressionType.NULL)) {
            return ConstantOperand.FALSE;
        }
        unaryExpression.setExpression(simplifiedInputExpression);
        return unaryExpression;
    }

    @Override
    public Expression visitLogicNotExpression(LogicNotExpression logicNotExpression, Void context) {
        Expression simplifiedInputExpression = (Expression)this.process(logicNotExpression.getExpression(), context);
        if (simplifiedInputExpression.equals(ConstantOperand.TRUE)) {
            return ConstantOperand.FALSE;
        }
        if (simplifiedInputExpression.equals(ConstantOperand.FALSE)) {
            return ConstantOperand.TRUE;
        }
        logicNotExpression.setExpression(simplifiedInputExpression);
        return logicNotExpression;
    }

    @Override
    public Expression visitNegationExpression(NegationExpression negationExpression, Void context) {
        Expression simplifiedInputExpression = (Expression)this.process(negationExpression.getExpression(), context);
        if (simplifiedInputExpression.getExpressionType().equals((Object)ExpressionType.NULL)) {
            return new NullOperand();
        }
        negationExpression.setExpression(simplifiedInputExpression);
        return negationExpression;
    }

    @Override
    public Expression visitArithmeticBinaryExpression(ArithmeticBinaryExpression arithmeticBinaryExpression, Void context) {
        Expression simplifiedLeft = (Expression)this.process(arithmeticBinaryExpression.getLeftExpression(), context);
        Expression simplifiedRight = (Expression)this.process(arithmeticBinaryExpression.getRightExpression(), context);
        boolean leftIsNull = simplifiedLeft.getExpressionType().equals((Object)ExpressionType.NULL);
        boolean rightIsNull = simplifiedRight.getExpressionType().equals((Object)ExpressionType.NULL);
        if (leftIsNull || rightIsNull) {
            return new NullOperand();
        }
        arithmeticBinaryExpression.setLeftExpression(simplifiedLeft);
        arithmeticBinaryExpression.setRightExpression(simplifiedRight);
        return arithmeticBinaryExpression;
    }

    @Override
    public Expression visitLogicAndExpression(LogicAndExpression logicAndExpression, Void context) {
        Expression simplifiedLeft = (Expression)this.process(logicAndExpression.getLeftExpression(), context);
        Expression simplifiedRight = (Expression)this.process(logicAndExpression.getRightExpression(), context);
        boolean isLeftTrue = simplifiedLeft.equals(ConstantOperand.TRUE);
        boolean isRightTrue = simplifiedRight.equals(ConstantOperand.TRUE);
        if (isLeftTrue && isRightTrue) {
            return ConstantOperand.TRUE;
        }
        if (isLeftTrue) {
            return simplifiedRight;
        }
        if (isRightTrue) {
            return simplifiedLeft;
        }
        boolean isLeftFalse = simplifiedLeft.equals(ConstantOperand.FALSE);
        boolean isRightFalse = simplifiedRight.equals(ConstantOperand.FALSE);
        if (isLeftFalse || isRightFalse) {
            return ConstantOperand.FALSE;
        }
        logicAndExpression.setLeftExpression(simplifiedLeft);
        logicAndExpression.setRightExpression(simplifiedRight);
        return logicAndExpression;
    }

    @Override
    public Expression visitLogicOrExpression(LogicOrExpression logicOrExpression, Void context) {
        Expression simplifiedLeft = (Expression)this.process(logicOrExpression.getLeftExpression(), context);
        Expression simplifiedRight = (Expression)this.process(logicOrExpression.getRightExpression(), context);
        boolean isLeftTrue = simplifiedLeft.equals(ConstantOperand.TRUE);
        boolean isRightTrue = simplifiedRight.equals(ConstantOperand.TRUE);
        if (isRightTrue || isLeftTrue) {
            return ConstantOperand.TRUE;
        }
        boolean isLeftFalse = simplifiedLeft.equals(ConstantOperand.FALSE);
        boolean isRightFalse = simplifiedRight.equals(ConstantOperand.FALSE);
        if (isLeftFalse && isRightFalse) {
            return ConstantOperand.FALSE;
        }
        if (isLeftFalse) {
            return simplifiedRight;
        }
        if (isRightFalse) {
            return simplifiedLeft;
        }
        logicOrExpression.setLeftExpression(simplifiedLeft);
        logicOrExpression.setRightExpression(simplifiedRight);
        return logicOrExpression;
    }

    @Override
    public Expression visitCompareBinaryExpression(CompareBinaryExpression compareBinaryExpression, Void context) {
        Expression simplifiedLeft = (Expression)this.process(compareBinaryExpression.getLeftExpression(), context);
        Expression simplifiedRight = (Expression)this.process(compareBinaryExpression.getRightExpression(), context);
        boolean leftIsNull = simplifiedLeft.getExpressionType().equals((Object)ExpressionType.NULL);
        boolean rightIsNull = simplifiedRight.getExpressionType().equals((Object)ExpressionType.NULL);
        if (leftIsNull || rightIsNull) {
            return ConstantOperand.FALSE;
        }
        compareBinaryExpression.setLeftExpression(simplifiedLeft);
        compareBinaryExpression.setRightExpression(simplifiedRight);
        return compareBinaryExpression;
    }

    @Override
    public Expression visitBetweenExpression(BetweenExpression betweenExpression, Void context) {
        Expression simplifiedFirstExpression = (Expression)this.process(betweenExpression.getFirstExpression(), context);
        Expression simplifiedSecondExpression = (Expression)this.process(betweenExpression.getSecondExpression(), context);
        Expression simplifiedThirdExpression = (Expression)this.process(betweenExpression.getThirdExpression(), context);
        boolean firstIsNull = simplifiedFirstExpression.getExpressionType().equals((Object)ExpressionType.NULL);
        boolean secondIsNull = simplifiedSecondExpression.getExpressionType().equals((Object)ExpressionType.NULL);
        boolean thirdIsNull = simplifiedThirdExpression.getExpressionType().equals((Object)ExpressionType.NULL);
        if (firstIsNull || secondIsNull || thirdIsNull) {
            return ConstantOperand.FALSE;
        }
        boolean firstIsConstant = simplifiedFirstExpression.isConstantOperand();
        boolean secondIsConstant = simplifiedSecondExpression.isConstantOperand();
        boolean thirdIsConstant = simplifiedThirdExpression.isConstantOperand();
        boolean isNotBetween = betweenExpression.isNotBetween();
        if (firstIsConstant && secondIsConstant && this.lessThan((ConstantOperand)simplifiedFirstExpression, (ConstantOperand)simplifiedSecondExpression) || firstIsConstant && thirdIsConstant && this.lessThan((ConstantOperand)simplifiedThirdExpression, (ConstantOperand)simplifiedFirstExpression)) {
            if (isNotBetween) {
                return ConstantOperand.TRUE;
            }
            return ConstantOperand.FALSE;
        }
        betweenExpression.setFirstExpression(simplifiedFirstExpression);
        betweenExpression.setSecondExpression(simplifiedSecondExpression);
        betweenExpression.setThirdExpression(simplifiedThirdExpression);
        return betweenExpression;
    }

    private <T extends Comparable<T>> boolean lessThan(ConstantOperand operand1, ConstantOperand operand2) {
        Object value2;
        Object value1 = ConvertPredicateToFilterVisitor.getValue(operand1.getValueString(), operand1.getDataType());
        return value1.compareTo(value2 = ConvertPredicateToFilterVisitor.getValue(operand2.getValueString(), operand2.getDataType())) < 0;
    }

    @Override
    public Expression visitFunctionExpression(FunctionExpression functionExpression, Void context) {
        ArrayList<Expression> simplifiedInputExpressions = new ArrayList<Expression>();
        for (Expression inputExpression : functionExpression.getExpressions()) {
            Expression simplifiedInputExpression = (Expression)this.process(inputExpression, context);
            if (simplifiedInputExpression.getExpressionType().equals((Object)ExpressionType.NULL)) {
                return new NullOperand();
            }
            simplifiedInputExpressions.add(simplifiedInputExpression);
        }
        functionExpression.setExpressions(simplifiedInputExpressions);
        return functionExpression;
    }

    @Override
    public Expression visitLeafOperand(LeafOperand leafOperand, Void context) {
        return leafOperand;
    }

    @Override
    public Expression visitCaseWhenThenExpression(CaseWhenThenExpression caseWhenThenExpression, Void context) {
        return caseWhenThenExpression;
    }

    @Override
    public Expression visitWhenThenExpression(WhenThenExpression whenThenExpression, Void context) {
        return whenThenExpression;
    }

    @Override
    public Expression visitGroupByTimeExpression(GroupByTimeExpression groupByTimeExpression, Void context) {
        return groupByTimeExpression;
    }
}

