/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.audit.AuditLogOperation;
import org.apache.iotdb.db.audit.AuditLogStorage;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.LoadConfigurationException;
import org.apache.iotdb.db.protocol.thrift.impl.ClientRPCServiceImpl;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.LastCacheLoadStrategy;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.constant.CrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.constant.InnerSeqCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.constant.InnerUnseqCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionPriority;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.constant.CrossCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.constant.InnerSequenceCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.constant.InnerUnsequenceCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.TimeIndexLevel;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALMode;
import org.apache.iotdb.db.storageengine.load.disk.ILoadDiskSelector;
import org.apache.iotdb.db.utils.datastructure.TVListSortAlgorithm;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.metricsets.system.SystemMetrics;
import org.apache.iotdb.rpc.BaseRpcTransportFactory;
import org.apache.iotdb.rpc.ZeroCopyRpcTransportFactory;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.fileSystem.FSType;
import org.apache.tsfile.utils.FSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConfig {
    public static final String WATERMARK_GROUPED_LSB = "GroupBasedLSBMethod";
    public static final String CONFIG_NAME = "iotdb-system.properties";
    private static final Logger logger = LoggerFactory.getLogger(IoTDBConfig.class);
    private static final String MULTI_DIR_STRATEGY_PREFIX = "org.apache.iotdb.db.storageengine.rescon.disk.strategy.";
    private static final String[] CLUSTER_ALLOWED_MULTI_DIR_STRATEGIES = new String[]{"SequenceStrategy", "MaxDiskUsableSpaceFirstStrategy"};
    private static final String DEFAULT_MULTI_DIR_STRATEGY = "SequenceStrategy";
    private static final String STORAGE_GROUP_MATCHER = "([a-zA-Z0-9`_.\\-\\u2E80-\\u9FFF]+)";
    public static final Pattern STORAGE_GROUP_PATTERN = Pattern.compile("([a-zA-Z0-9`_.\\-\\u2E80-\\u9FFF]+)");
    private static final String NODE_NAME_MATCHER = "([^\n\t]+)";
    private static final String PARTIAL_NODE_MATCHER = "[.]([^\n\t]+)";
    private static final String NODE_MATCHER = "([.])?([^\n\t]+)([.]([^\n\t]+))*";
    public static final Pattern NODE_PATTERN = Pattern.compile("([.])?([^\n\t]+)([.]([^\n\t]+))*");
    private boolean enableMQTTService = false;
    private String mqttHost = "127.0.0.1";
    private int mqttPort = 1883;
    private int mqttHandlerPoolSize = 1;
    private String mqttPayloadFormatter = "json";
    private String mqttDataPath = "data/";
    private int mqttMaxMessageSize = 0x100000;
    private String rpcAddress = "0.0.0.0";
    private boolean rpcThriftCompressionEnable = false;
    private boolean rpcAdvancedCompressionEnable = false;
    private int rpcPort = 6667;
    private boolean enableSSL = false;
    private String keyStorePath = "";
    private String keyStorePwd = "";
    private int rpcSelectorThreadCount = 1;
    private int rpcMaxConcurrentClientNum = 1000;
    private long allocateMemoryForRead = Runtime.getRuntime().maxMemory() * 3L / 10L;
    private double flushProportion = 0.4;
    private double writeMemoryVariationReportProportion = 0.001;
    private int checkPeriodWhenInsertBlocked = 50;
    private int maxWaitingTimeWhenInsertBlockedInMs = 10000;
    private volatile WALMode walMode = WALMode.ASYNC;
    private int maxWalNodesNum = 0;
    private volatile long walAsyncModeFsyncDelayInMs = 1000L;
    private volatile long walSyncModeFsyncDelayInMs = 3L;
    private int walBufferSize = 0x2000000;
    private int deletionAheadLogBufferQueueCapacity = 500;
    private volatile long walFileSizeThresholdInByte = 0x1E00000L;
    private volatile long checkpointFileSizeThresholdInByte = 0x300000L;
    private volatile double walMinEffectiveInfoRatio = 0.1;
    private volatile long walMemTableSnapshotThreshold = 0x800000L;
    private volatile int maxWalMemTableSnapshotNum = 1;
    private volatile long deleteWalFilesPeriodInMs = 20000L;
    private volatile boolean WALCacheShrinkClearEnabled = true;
    private long syncMlogPeriodInMs = 100L;
    private int tlogBufferSize = 0x100000;
    private String systemDir = IoTDBConstant.DN_DEFAULT_DATA_DIR + File.separator + "system";
    private String schemaDir = IoTDBConstant.DN_DEFAULT_DATA_DIR + File.separator + "system" + File.separator + "schema";
    private String queryDir = IoTDBConstant.DN_DEFAULT_DATA_DIR + File.separator + "query";
    private String extDir = "ext";
    private String udfDir = "ext" + File.separator + "udf";
    private String udfTemporaryLibDir = this.udfDir + File.separator + "tmp";
    private String triggerDir = "ext" + File.separator + "trigger";
    private String triggerTemporaryLibDir = this.triggerDir + File.separator + "tmp";
    private String pipeDir = "ext" + File.separator + "pipe";
    private String pipeTemporaryLibDir = this.pipeDir + File.separator + "tmp";
    private String extPipeDir = "ext" + File.separator + "extPipe";
    private int pipeTaskThreadCount = 5;
    private String mqttDir = "ext" + File.separator + "mqtt";
    private String[][] tierDataDirs = new String[][]{{IoTDBConstant.DN_DEFAULT_DATA_DIR + File.separator + "data"}};
    private String[] loadTsFileDirs = new String[]{this.tierDataDirs[0][0] + File.separator + "load"};
    private String multiDirStrategyClassName = null;
    private String ratisDataRegionSnapshotDir = IoTDBConstant.DN_DEFAULT_DATA_DIR + File.separator + "data" + File.separator + "snapshot";
    private String consensusDir = IoTDBConstant.DN_DEFAULT_DATA_DIR + File.separator + "consensus";
    private String dataRegionConsensusDir = this.consensusDir + File.separator + "data_region";
    private String invalidDataRegionConsensusDir = this.consensusDir + File.separator + "invalid_data_region";
    private String schemaRegionConsensusDir = this.consensusDir + File.separator + "schema_region";
    private String sortTmpDir = IoTDBConstant.DN_DEFAULT_DATA_DIR + File.separator + "tmp";
    private int maxMemtableNumber = 0;
    private int batchSize = 100000;
    private int flushThreadCount = Runtime.getRuntime().availableProcessors();
    private int degreeOfParallelism = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    private int mergeThresholdOfExplainAnalyze = 10;
    private int modeMapSizeThreshold = 10000;
    private int maxAllowedConcurrentQueries = 1000;
    private int windowEvaluationThreadCount = Runtime.getRuntime().availableProcessors();
    private int maxPendingWindowEvaluationTasks = 64;
    private boolean enableIndex = false;
    private int concurrentIndexBuildThread = Runtime.getRuntime().availableProcessors();
    private int defaultIndexWindowRange = 10;
    private String indexRootFolder = "data" + File.separator + "index";
    private long unSeqTsFileSize = 0L;
    private long seqTsFileSize = 0L;
    private boolean enableTimedFlushSeqMemtable = true;
    private long seqMemtableFlushInterval = 600000L;
    private long seqMemtableFlushCheckInterval = 30000L;
    private boolean enableTimedFlushUnseqMemtable = true;
    private long unseqMemtableFlushInterval = 600000L;
    private long unseqMemtableFlushCheckInterval = 30000L;
    private TVListSortAlgorithm tvListSortAlgorithm = TVListSortAlgorithm.TIM;
    private int tvListSortThreshold = 0;
    private volatile boolean enableSeqSpaceCompaction = true;
    private volatile boolean enableUnseqSpaceCompaction = true;
    private volatile boolean enableCrossSpaceCompaction = true;
    private volatile boolean enableAutoRepairCompaction = true;
    private long sortBufferSize = 0x100000L;
    private InnerSequenceCompactionSelector innerSequenceCompactionSelector = InnerSequenceCompactionSelector.SIZE_TIERED_MULTI_TARGET;
    private InnerSeqCompactionPerformer innerSeqCompactionPerformer = InnerSeqCompactionPerformer.READ_CHUNK;
    private InnerUnsequenceCompactionSelector innerUnsequenceCompactionSelector = InnerUnsequenceCompactionSelector.SIZE_TIERED_MULTI_TARGET;
    private InnerUnseqCompactionPerformer innerUnseqCompactionPerformer = InnerUnseqCompactionPerformer.FAST;
    private CrossCompactionSelector crossCompactionSelector = CrossCompactionSelector.REWRITE;
    private CrossCompactionPerformer crossCompactionPerformer = CrossCompactionPerformer.FAST;
    private CompactionPriority compactionPriority = CompactionPriority.INNER_CROSS;
    private double chunkMetadataSizeProportion = 0.1;
    private long innerCompactionTotalFileSizeThresholdInByte = 0x280000000L;
    private int innerCompactionTotalFileNumThreshold = 100;
    private int maxLevelGapInInnerCompaction = 2;
    private long targetCompactionFileSize = 0x80000000L;
    private long targetChunkSize = 1600000L;
    private long targetChunkPointNum = 100000L;
    private long chunkSizeLowerBoundInCompaction = 10240L;
    private long chunkPointNumLowerBoundInCompaction = 1000L;
    private long compactionAcquireWriteLockTimeout = 60000L;
    private volatile int innerCompactionCandidateFileNum = 30;
    private volatile int fileLimitPerCrossTask = 500;
    private volatile int totalFileLimitForCompactionTask = 5000;
    private volatile long maxCrossCompactionCandidateFileSize = 0x140000000L;
    private volatile int minCrossCompactionUnseqFileLevel = 1;
    private long compactionScheduleIntervalInMs = 60000L;
    private int ttlCheckerNum = 1;
    private long maxExpiredTime = 2592000000L;
    private float expiredDataRatio = 0.3f;
    private int subCompactionTaskNum = 4;
    private int compactionScheduleThreadNum = 4;
    private volatile boolean enableTsFileValidation = false;
    private int candidateCompactionTaskQueueSize = 50;
    private volatile long innerCompactionTaskSelectionModsFileThreshold = 131072L;
    private volatile double innerCompactionTaskSelectionDiskRedundancy = 0.05;
    private int mRemoteSchemaCacheSize = 100000;
    private String languageVersion = "EN";
    private long cacheFileReaderClearPeriod = 100000L;
    private long queryTimeoutThreshold = 60000L;
    private int sessionTimeoutThreshold = 0;
    private String rpcImplClassName = ClientRPCServiceImpl.class.getName();
    private String clusterName = "defaultCluster";
    private String clusterId = "";
    private volatile int dataNodeId = -1;
    private boolean chunkBufferPoolEnable = false;
    private boolean enableAutoCreateSchema = true;
    private TSDataType booleanStringInferType = TSDataType.BOOLEAN;
    private TSDataType integerStringInferType = TSDataType.DOUBLE;
    private TSDataType floatingStringInferType = TSDataType.DOUBLE;
    private TSDataType nanStringInferType = TSDataType.DOUBLE;
    private int defaultStorageGroupLevel = 1;
    private TSEncoding defaultBooleanEncoding = TSEncoding.RLE;
    private TSEncoding defaultInt32Encoding = TSEncoding.TS_2DIFF;
    private TSEncoding defaultInt64Encoding = TSEncoding.TS_2DIFF;
    private TSEncoding defaultFloatEncoding = TSEncoding.GORILLA;
    private TSEncoding defaultDoubleEncoding = TSEncoding.GORILLA;
    private TSEncoding defaultTextEncoding = TSEncoding.PLAIN;
    private int settleThreadNum = 1;
    private long crossCompactionFileSelectionTimeBudget = 30000L;
    private long mergeIntervalSec = 0L;
    private int compactionWriteThroughputMbPerSec = 16;
    private int compactionReadThroughputMbPerSec = 0;
    private int compactionReadOperationPerSec = 0;
    private int compactionThreadCount = 10;
    private int compactionMaxAlignedSeriesNumInOneBatch = 10;
    private int continuousQueryThreadNum = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    private long continuousQueryMinimumEveryInterval = 1000L;
    private long intoOperationBufferSizeInByte = 0x6400000L;
    private int selectIntoInsertTabletPlanRowLimit = 10000;
    private int intoOperationExecutionThreadCount = 2;
    private FSType tsFileStorageFs = FSType.LOCAL;
    private boolean enableHDFS = false;
    private String coreSitePath = "/etc/hadoop/conf/core-site.xml";
    private String hdfsSitePath = "/etc/hadoop/conf/hdfs-site.xml";
    private String hdfsIp = "localhost";
    private String hdfsPort = "9000";
    private String dfsNameServices = "hdfsnamespace";
    private String dfsHaNamenodes = "nn1,nn2";
    private boolean dfsHaAutomaticFailoverEnabled = true;
    private String dfsClientFailoverProxyProvider = "org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider";
    private boolean useKerberos = false;
    private String kerberosKeytabFilePath = "/path";
    private String kerberosPrincipal = "your principal";
    private int defaultFillInterval = -1;
    private int primitiveArraySize = 64;
    private TimeIndexLevel timeIndexLevel = TimeIndexLevel.ARRAY_DEVICE_TIME_INDEX;
    private int thriftServerAwaitTimeForStopService = 60;
    private int tagAttributeFlushInterval = 1000;
    private boolean enablePartialInsert = true;
    private boolean enable13DataInsertAdapt = false;
    private int udfInitialByteArrayLengthForMemoryControl = 48;
    private float udfMemoryBudgetInMB = (float)Math.min(30.0, 0.2 * (double)this.allocateMemoryForRead);
    private float udfReaderMemoryBudgetInMB = (float)(0.3333333333333333 * (double)this.udfMemoryBudgetInMB);
    private float udfTransformerMemoryBudgetInMB = (float)(0.3333333333333333 * (double)this.udfMemoryBudgetInMB);
    private float udfCollectorMemoryBudgetInMB = (float)(0.3333333333333333 * (double)this.udfMemoryBudgetInMB);
    private int thriftMaxFrameSize = 0x20000000;
    private int thriftDefaultBufferSize = 1024;
    private long slowQueryThreshold = 30000L;
    private int patternMatchingThreshold = 1000000;
    private boolean enableRpcService = true;
    private int ioTaskQueueSizeForFlushing = 10;
    private int dataRegionNum = 1;
    private long recoveryLogIntervalInMs = 5000L;
    private boolean enableSeparateData = true;
    private String deviceIDTransformationMethod = "Plain";
    private boolean enableIDTableLogFile = false;
    private int cachedMNodeSizeInPBTreeMode = -1;
    private short minimumSegmentInPBTree = 0;
    private int pageCacheSizeInPBTree = 1024;
    private int pbTreeLogSize = 16384;
    private int maxMeasurementNumOfInternalRequest = 10000;
    private String internalAddress = "127.0.0.1";
    private int internalPort = 10730;
    private int dataRegionConsensusPort = 10760;
    private int schemaRegionConsensusPort = 10750;
    private TEndPoint seedConfigNode = new TEndPoint("127.0.0.1", 10710);
    private long joinClusterRetryIntervalMs = TimeUnit.SECONDS.toMillis(1L);
    private String dataRegionConsensusProtocolClass = "org.apache.iotdb.consensus.iot.IoTConsensus";
    private String schemaRegionConsensusProtocolClass = "org.apache.iotdb.consensus.ratis.RatisConsensus";
    private String seriesPartitionExecutorClass = "org.apache.iotdb.commons.partition.executor.hash.BKDRHashExecutor";
    private int seriesPartitionSlotNum = 10000;
    private int mppDataExchangePort = 10740;
    private int mppDataExchangeCorePoolSize = 10;
    private int mppDataExchangeMaxPoolSize = 10;
    private int mppDataExchangeKeepAliveTimeInMs = 1000;
    private int connectionTimeoutInMS = (int)TimeUnit.SECONDS.toMillis(60L);
    private int selectorNumOfClientManager = Runtime.getRuntime().availableProcessors() / 4 > 0 ? Runtime.getRuntime().availableProcessors() / 4 : 1;
    private int maxClientNumForEachNode = 1000;
    private int partitionCacheSize = 1000;
    private int authorCacheSize = 100;
    private int authorCacheExpireTime = 30;
    private int triggerForwardMaxQueueNumber = 8;
    private int triggerForwardMaxSizePerQueue = 2000;
    private int triggerForwardBatchSize = 50;
    private int triggerForwardHTTPPoolSize = 200;
    private int triggerForwardHTTPPOOLMaxPerRoute = 20;
    private int triggerForwardMQTTPoolSize = 4;
    private int retryNumToFindStatefulTrigger = 3;
    private int coordinatorReadExecutorSize = 20;
    private int coordinatorWriteExecutorSize = 50;
    private String dataNodeSchemaCacheEvictionPolicy = "FIFO";
    private int dataNodeTableCacheSemaphorePermitNum = 5;
    private long generalRegionAttributeSecurityServiceIntervalSeconds = 30L;
    private long generalRegionAttributeSecurityServiceTimeoutSeconds = 20L;
    private long generalRegionAttributeSecurityServiceFailureDurationSecondsToFetch = 600L;
    private int generalRegionAttributeSecurityServiceFailureTimesToFetch = 20;
    private long detailContainerMinDegradeMemoryInBytes = 0x100000L;
    private int schemaThreadCount = 5;
    private String readConsistencyLevel = "strong";
    private int driverTaskExecutionTimeSliceInMs = 200;
    private long throttleThreshold = 0x3200000000L;
    private long cacheWindowTimeInMs = 10000L;
    private long dataRatisConsensusLogAppenderBufferSizeMax = 0x1000000L;
    private long schemaRatisConsensusLogAppenderBufferSizeMax = 0x1000000L;
    private long dataRatisConsensusSnapshotTriggerThreshold = 400000L;
    private long schemaRatisConsensusSnapshotTriggerThreshold = 400000L;
    private boolean dataRatisConsensusLogUnsafeFlushEnable = false;
    private boolean schemaRatisConsensusLogUnsafeFlushEnable = false;
    private int dataRatisConsensusLogForceSyncNum = 128;
    private int schemaRatisConsensusLogForceSyncNum = 128;
    private long dataRatisConsensusLogSegmentSizeMax = 0x1800000L;
    private long schemaRatisConsensusLogSegmentSizeMax = 0x1800000L;
    private long dataRatisConsensusGrpcFlowControlWindow = 0x400000L;
    private long schemaRatisConsensusGrpcFlowControlWindow = 0x400000L;
    private int dataRatisConsensusGrpcLeaderOutstandingAppendsMax = 128;
    private int schemaRatisConsensusGrpcLeaderOutstandingAppendsMax = 128;
    private long dataRatisConsensusLeaderElectionTimeoutMinMs = 2000L;
    private long schemaRatisConsensusLeaderElectionTimeoutMinMs = 2000L;
    private long dataRatisConsensusLeaderElectionTimeoutMaxMs = 4000L;
    private long schemaRatisConsensusLeaderElectionTimeoutMaxMs = 4000L;
    private long cqMinEveryIntervalInMs = 1000L;
    private long dataRatisConsensusRequestTimeoutMs = 10000L;
    private long schemaRatisConsensusRequestTimeoutMs = 10000L;
    private int dataRatisConsensusMaxRetryAttempts = 10;
    private int schemaRatisConsensusMaxRetryAttempts = 10;
    private long dataRatisConsensusInitialSleepTimeMs = 100L;
    private long schemaRatisConsensusInitialSleepTimeMs = 100L;
    private long dataRatisConsensusMaxSleepTimeMs = 10000L;
    private long schemaRatisConsensusMaxSleepTimeMs = 10000L;
    private long dataRatisConsensusPreserveWhenPurge = 1000L;
    private long schemaRatisConsensusPreserveWhenPurge = 1000L;
    private long ratisFirstElectionTimeoutMinMs = 50L;
    private long ratisFirstElectionTimeoutMaxMs = 150L;
    private long dataRatisLogMax = 0x500000000L;
    private long schemaRatisLogMax = 0x80000000L;
    private long dataRatisPeriodicSnapshotInterval = 86400L;
    private long schemaRatisPeriodicSnapshotInterval = 86400L;
    private boolean enableAuditLog = false;
    private List<AuditLogStorage> auditLogStorage = Arrays.asList(AuditLogStorage.IOTDB, AuditLogStorage.LOGGER);
    private List<AuditLogOperation> auditLogOperation = Arrays.asList(AuditLogOperation.DML, AuditLogOperation.DDL, AuditLogOperation.QUERY);
    private boolean enableAuditLogForNativeInsertApi = true;
    private Properties customizedProperties = new Properties();
    private int maxLogEntriesNumPerBatch = 1024;
    private int maxSizePerBatch = 0x1000000;
    private int maxPendingBatchesNum = 5;
    private double maxMemoryRatioForQueue = 0.6;
    private long regionMigrationSpeedLimitBytesPerSecond = 0x3000000L;
    private int iotConsensusV2PipelineSize = 5;
    private String iotConsensusV2Mode = "batch";
    private long tsFileWriterCheckInterval = TimeUnit.MINUTES.toMillis(5L);
    private long tsFileWriterZombieThreshold = TimeUnit.MINUTES.toMillis(10L);
    private String[] iotConsensusV2ReceiverFileDirs = new String[0];
    private String iotConsensusV2DeletionFileDir = this.systemDir + File.separator + "pipe" + File.separator + "consensus" + File.separator + "deletion";
    private double maxAllocateMemoryRatioForLoad = 0.8;
    private int loadTsFileAnalyzeSchemaBatchReadTimeSeriesMetadataCount = 4096;
    private int loadTsFileAnalyzeSchemaBatchFlushTimeSeriesNumber = 4096;
    private int loadTsFileAnalyzeSchemaBatchFlushTableDeviceNumber = 4096;
    private long loadTsFileAnalyzeSchemaMemorySizeInBytes = 0L;
    private long loadTsFileTabletConversionBatchMemorySizeInBytes = 0x400000L;
    private int loadTsFileTabletConversionThreadCount = 5;
    private int loadTsFileMaxDeviceCountToUseDeviceTimeIndex = 10000;
    private long loadChunkMetadataMemorySizeInBytes = 0x2000000L;
    private long loadMemoryAllocateRetryIntervalMs = 1000L;
    private int loadMemoryAllocateMaxRetries = 5;
    private long loadCleanupTaskExecutionDelayTimeSeconds = 1800L;
    private int loadTsFileRetryCountOnRegionChange = 10;
    private double loadWriteThroughputBytesPerSecond = -1.0;
    private long loadTabletConversionThresholdBytes = -1L;
    private boolean loadActiveListeningEnable = true;
    private String[] loadActiveListeningDirs = new String[]{"ext" + File.separator + "load" + File.separator + "pending"};
    private String loadActiveListeningPipeDir = "ext" + File.separator + "load" + File.separator + "pipe";
    private String loadActiveListeningFailDir = "ext" + File.separator + "load" + File.separator + "failed";
    private long loadActiveListeningCheckIntervalSeconds = 5L;
    private int loadActiveListeningMaxThreadNum = Runtime.getRuntime().availableProcessors();
    private boolean loadActiveListeningVerifyEnable = true;
    private String loadDiskSelectStrategy = ILoadDiskSelector.LoadDiskSelectorType.MIN_IO_FIRST.getValue();
    private String loadDiskSelectStrategyForIoTV2AndPipe = ILoadDiskSelector.LoadDiskSelectorType.INHERIT_LOAD.getValue();
    private String[] pipeReceiverFileDirs = new String[0];
    private boolean quotaEnable = false;
    private String RateLimiterType = "FixedIntervalRateLimiter";
    private CompressionType WALCompressionAlgorithm = CompressionType.LZ4;
    private LastCacheLoadStrategy lastCacheLoadStrategy = LastCacheLoadStrategy.UPDATE;
    private boolean cacheLastValuesForLoad = true;
    private long cacheLastValuesMemoryBudgetInByte = 0x400000L;

    IoTDBConfig() {
    }

    public int getMaxLogEntriesNumPerBatch() {
        return this.maxLogEntriesNumPerBatch;
    }

    public int getMaxSizePerBatch() {
        return this.maxSizePerBatch;
    }

    public int getMaxPendingBatchesNum() {
        return this.maxPendingBatchesNum;
    }

    public double getMaxMemoryRatioForQueue() {
        return this.maxMemoryRatioForQueue;
    }

    public void setMaxLogEntriesNumPerBatch(int maxLogEntriesNumPerBatch) {
        this.maxLogEntriesNumPerBatch = maxLogEntriesNumPerBatch;
    }

    public long getRegionMigrationSpeedLimitBytesPerSecond() {
        return this.regionMigrationSpeedLimitBytesPerSecond;
    }

    public void setRegionMigrationSpeedLimitBytesPerSecond(long regionMigrationSpeedLimitBytesPerSecond) {
        this.regionMigrationSpeedLimitBytesPerSecond = regionMigrationSpeedLimitBytesPerSecond;
    }

    public int getIotConsensusV2PipelineSize() {
        return this.iotConsensusV2PipelineSize;
    }

    public void setIotConsensusV2PipelineSize(int iotConsensusV2PipelineSize) {
        this.iotConsensusV2PipelineSize = iotConsensusV2PipelineSize;
    }

    public long getTsFileWriterCheckInterval() {
        return this.tsFileWriterCheckInterval;
    }

    public void setTsFileWriterCheckInterval(long tsFileWriterCheckInterval) {
        this.tsFileWriterCheckInterval = tsFileWriterCheckInterval;
    }

    public long getTsFileWriterZombieThreshold() {
        return this.tsFileWriterZombieThreshold;
    }

    public void setTsFileWriterZombieThreshold(long tsFileWriterZombieThreshold) {
        this.tsFileWriterZombieThreshold = tsFileWriterZombieThreshold;
    }

    public void setMaxSizePerBatch(int maxSizePerBatch) {
        this.maxSizePerBatch = maxSizePerBatch;
    }

    public void setMaxPendingBatchesNum(int maxPendingBatchesNum) {
        this.maxPendingBatchesNum = maxPendingBatchesNum;
    }

    public void setMaxMemoryRatioForQueue(double maxMemoryRatioForQueue) {
        this.maxMemoryRatioForQueue = maxMemoryRatioForQueue;
    }

    public float getUdfMemoryBudgetInMB() {
        return this.udfMemoryBudgetInMB;
    }

    public void setUdfMemoryBudgetInMB(float udfMemoryBudgetInMB) {
        this.udfMemoryBudgetInMB = udfMemoryBudgetInMB;
    }

    public float getUdfReaderMemoryBudgetInMB() {
        return this.udfReaderMemoryBudgetInMB;
    }

    public void setUdfReaderMemoryBudgetInMB(float udfReaderMemoryBudgetInMB) {
        this.udfReaderMemoryBudgetInMB = udfReaderMemoryBudgetInMB;
    }

    public float getUdfTransformerMemoryBudgetInMB() {
        return this.udfTransformerMemoryBudgetInMB;
    }

    public void setUdfTransformerMemoryBudgetInMB(float udfTransformerMemoryBudgetInMB) {
        this.udfTransformerMemoryBudgetInMB = udfTransformerMemoryBudgetInMB;
    }

    public float getUdfCollectorMemoryBudgetInMB() {
        return this.udfCollectorMemoryBudgetInMB;
    }

    public void setUdfCollectorMemoryBudgetInMB(float udfCollectorMemoryBudgetInMB) {
        this.udfCollectorMemoryBudgetInMB = udfCollectorMemoryBudgetInMB;
    }

    public boolean isEnableSSL() {
        return this.enableSSL;
    }

    public void setEnableSSL(boolean enableSSL) {
        this.enableSSL = enableSSL;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStorePwd() {
        return this.keyStorePwd;
    }

    public void setKeyStorePwd(String keyStorePwd) {
        this.keyStorePwd = keyStorePwd;
    }

    public int getUdfInitialByteArrayLengthForMemoryControl() {
        return this.udfInitialByteArrayLengthForMemoryControl;
    }

    public void setUdfInitialByteArrayLengthForMemoryControl(int udfInitialByteArrayLengthForMemoryControl) {
        this.udfInitialByteArrayLengthForMemoryControl = udfInitialByteArrayLengthForMemoryControl;
    }

    public int getDefaultFillInterval() {
        return this.defaultFillInterval;
    }

    public void setDefaultFillInterval(int defaultFillInterval) {
        this.defaultFillInterval = defaultFillInterval;
    }

    public TimeIndexLevel getTimeIndexLevel() {
        return this.timeIndexLevel;
    }

    public void setTimeIndexLevel(String timeIndexLevel) {
        this.timeIndexLevel = TimeIndexLevel.valueOf(timeIndexLevel);
    }

    public void updatePath() {
        this.formulateFolders();
        this.confirmMultiDirStrategy();
    }

    private void formulateFolders() {
        int i;
        this.systemDir = IoTDBConfig.addDataHomeDir(this.systemDir);
        this.schemaDir = IoTDBConfig.addDataHomeDir(this.schemaDir);
        this.consensusDir = IoTDBConfig.addDataHomeDir(this.consensusDir);
        this.iotConsensusV2DeletionFileDir = IoTDBConfig.addDataHomeDir(this.iotConsensusV2DeletionFileDir);
        this.dataRegionConsensusDir = IoTDBConfig.addDataHomeDir(this.dataRegionConsensusDir);
        this.ratisDataRegionSnapshotDir = IoTDBConfig.addDataHomeDir(this.ratisDataRegionSnapshotDir);
        this.schemaRegionConsensusDir = IoTDBConfig.addDataHomeDir(this.schemaRegionConsensusDir);
        this.indexRootFolder = IoTDBConfig.addDataHomeDir(this.indexRootFolder);
        this.extDir = IoTDBConfig.addDataHomeDir(this.extDir);
        for (i = 0; i < this.loadActiveListeningDirs.length; ++i) {
            this.loadActiveListeningDirs[i] = IoTDBConfig.addDataHomeDir(this.loadActiveListeningDirs[i]);
        }
        this.loadActiveListeningPipeDir = IoTDBConfig.addDataHomeDir(this.loadActiveListeningPipeDir);
        this.loadActiveListeningFailDir = IoTDBConfig.addDataHomeDir(this.loadActiveListeningFailDir);
        this.udfDir = IoTDBConfig.addDataHomeDir(this.udfDir);
        this.udfTemporaryLibDir = IoTDBConfig.addDataHomeDir(this.udfTemporaryLibDir);
        this.triggerDir = IoTDBConfig.addDataHomeDir(this.triggerDir);
        this.triggerTemporaryLibDir = IoTDBConfig.addDataHomeDir(this.triggerTemporaryLibDir);
        this.pipeDir = IoTDBConfig.addDataHomeDir(this.pipeDir);
        this.pipeTemporaryLibDir = IoTDBConfig.addDataHomeDir(this.pipeTemporaryLibDir);
        for (i = 0; i < this.pipeReceiverFileDirs.length; ++i) {
            this.pipeReceiverFileDirs[i] = IoTDBConfig.addDataHomeDir(this.pipeReceiverFileDirs[i]);
        }
        for (i = 0; i < this.iotConsensusV2ReceiverFileDirs.length; ++i) {
            this.iotConsensusV2ReceiverFileDirs[i] = IoTDBConfig.addDataHomeDir(this.iotConsensusV2ReceiverFileDirs[i]);
        }
        this.iotConsensusV2DeletionFileDir = IoTDBConfig.addDataHomeDir(this.iotConsensusV2DeletionFileDir);
        this.mqttDir = IoTDBConfig.addDataHomeDir(this.mqttDir);
        this.extPipeDir = IoTDBConfig.addDataHomeDir(this.extPipeDir);
        this.queryDir = IoTDBConfig.addDataHomeDir(this.queryDir);
        this.sortTmpDir = IoTDBConfig.addDataHomeDir(this.sortTmpDir);
        this.formulateDataDirs(this.tierDataDirs);
    }

    private void formulateDataDirs(String[][] tierDataDirs) {
        for (int i = 0; i < tierDataDirs.length; ++i) {
            block6: for (int j = 0; j < tierDataDirs[i].length; ++j) {
                if (tierDataDirs[i][j].equals("object_storage")) {
                    tierDataDirs[i][j] = FSUtils.getOSDefaultPath((String)this.getObjectStorageBucket(), (int)this.dataNodeId);
                }
                switch (FSUtils.getFSType((String)tierDataDirs[i][j])) {
                    case HDFS: {
                        tierDataDirs[i][j] = this.getHdfsDir() + File.separatorChar + tierDataDirs[i][j];
                        continue block6;
                    }
                    case LOCAL: {
                        tierDataDirs[i][j] = IoTDBConfig.addDataHomeDir(tierDataDirs[i][j]);
                        continue block6;
                    }
                    case OBJECT_STORAGE: {
                        tierDataDirs[i][j] = FSUtils.getOSDefaultPath((String)this.getObjectStorageBucket(), (int)this.dataNodeId);
                        continue block6;
                    }
                }
            }
        }
        this.formulateLoadTsFileDirs(tierDataDirs);
    }

    void reloadDataDirs(String[][] newTierDataDirs) throws LoadConfigurationException {
        this.formulateDataDirs(newTierDataDirs);
        if (newTierDataDirs.length < this.tierDataDirs.length) {
            String msg = "some data dirs are removed from data_dirs parameter, please add them back.";
            logger.error(msg);
            throw new LoadConfigurationException(msg);
        }
        for (int i = 0; i < this.tierDataDirs.length; ++i) {
            List<String> newDirs = Arrays.asList(newTierDataDirs[i]);
            for (String oldDir : this.tierDataDirs[i]) {
                if (!newDirs.stream().noneMatch(newDir -> Objects.equals(new File((String)newDir).getAbsolutePath(), new File(oldDir).getAbsolutePath()))) continue;
                String msg = String.format("%s is removed from data_dirs parameter, please add it back.", oldDir);
                logger.error(msg);
                throw new LoadConfigurationException(msg);
            }
        }
        this.tierDataDirs = newTierDataDirs;
        this.reloadSystemMetrics();
    }

    void reloadSystemMetrics() {
        ArrayList<String> diskDirs = new ArrayList<String>();
        diskDirs.add(IoTDBDescriptor.getInstance().getConfig().getSystemDir());
        diskDirs.add(IoTDBDescriptor.getInstance().getConfig().getConsensusDir());
        diskDirs.addAll(Arrays.asList(IoTDBDescriptor.getInstance().getConfig().getDataDirs()));
        diskDirs.addAll(Arrays.asList(CommonDescriptor.getInstance().getConfig().getWalDirs()));
        diskDirs.add(CommonDescriptor.getInstance().getConfig().getSyncDir());
        diskDirs.add(IoTDBDescriptor.getInstance().getConfig().getSortTmpDir());
        SystemMetrics.getInstance().setDiskDirs(diskDirs);
    }

    public static String addDataHomeDir(String dir) {
        String dataHomeDir = System.getProperty("IOTDB_DATA_HOME", null);
        if (dataHomeDir == null) {
            dataHomeDir = System.getProperty("IOTDB_HOME", null);
        }
        if (dataHomeDir == null) {
            return dir;
        }
        File dataHomeFile = new File(dataHomeDir);
        try {
            dataHomeDir = dataHomeFile.getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("Fail to get canonical path of {}", (Object)dataHomeFile, (Object)e);
        }
        return FileUtils.addPrefix2FilePath((String)dataHomeDir, (String)dir);
    }

    void confirmMultiDirStrategy() {
        if (this.getMultiDirStrategyClassName() == null) {
            this.multiDirStrategyClassName = DEFAULT_MULTI_DIR_STRATEGY;
        }
        if (!this.getMultiDirStrategyClassName().contains(".")) {
            this.multiDirStrategyClassName = MULTI_DIR_STRATEGY_PREFIX + this.multiDirStrategyClassName;
        }
        try {
            Class.forName(this.multiDirStrategyClassName);
        }
        catch (ClassNotFoundException e) {
            logger.warn("Cannot find given directory strategy {}, using the default value", (Object)this.getMultiDirStrategyClassName(), (Object)e);
            this.setMultiDirStrategyClassName("org.apache.iotdb.db.storageengine.rescon.disk.strategy.SequenceStrategy");
        }
    }

    private String getHdfsDir() {
        String[] hdfsIps = TSFileDescriptor.getInstance().getConfig().getHdfsIp();
        String hdfsDir = "hdfs://";
        hdfsDir = hdfsIps.length > 1 ? hdfsDir + TSFileDescriptor.getInstance().getConfig().getDfsNameServices() : hdfsDir + hdfsIps[0] + ":" + TSFileDescriptor.getInstance().getConfig().getHdfsPort();
        return hdfsDir;
    }

    public String[] getDataDirs() {
        return (String[])Arrays.stream(this.tierDataDirs).flatMap(Arrays::stream).toArray(String[]::new);
    }

    public String[] getLocalDataDirs() {
        return (String[])Arrays.stream(this.tierDataDirs).flatMap(Arrays::stream).filter(FSUtils::isLocal).toArray(String[]::new);
    }

    public String[][] getTierDataDirs() {
        return this.tierDataDirs;
    }

    public void setTierDataDirs(String[][] tierDataDirs) {
        this.formulateDataDirs(tierDataDirs);
        this.tierDataDirs = tierDataDirs;
        this.setRatisDataRegionSnapshotDir(tierDataDirs[0][0] + File.separator + "snapshot");
    }

    public String getRpcAddress() {
        return this.rpcAddress;
    }

    public void setRpcAddress(String rpcAddress) {
        this.rpcAddress = rpcAddress;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public boolean isEnableSeparateData() {
        return this.enableSeparateData;
    }

    public void setEnableSeparateData(boolean enableSeparateData) {
        this.enableSeparateData = enableSeparateData;
    }

    public String getSystemDir() {
        return this.systemDir;
    }

    public void setSystemDir(String systemDir) {
        this.systemDir = systemDir;
    }

    public String getIotConsensusV2DeletionFileDir() {
        return this.iotConsensusV2DeletionFileDir;
    }

    public void setIotConsensusV2DeletionFileDir(String iotConsensusV2DeletionFileDir) {
        this.iotConsensusV2DeletionFileDir = iotConsensusV2DeletionFileDir;
    }

    public String[] getLoadTsFileDirs() {
        return this.loadTsFileDirs;
    }

    public void formulateLoadTsFileDirs(String[][] tierDataDirs) {
        if (tierDataDirs.length < 1) {
            logger.warn("No data directory is set. loadTsFileDirs is kept as the default value.");
            return;
        }
        String[] firstTierDataDirs = tierDataDirs[0];
        String[] newLoadTsFileDirs = new String[firstTierDataDirs.length];
        for (int i = 0; i < firstTierDataDirs.length; ++i) {
            newLoadTsFileDirs[i] = firstTierDataDirs[i] + File.separator + "load";
        }
        this.loadTsFileDirs = newLoadTsFileDirs;
    }

    public String getSchemaDir() {
        return this.schemaDir;
    }

    public void setSchemaDir(String schemaDir) {
        this.schemaDir = schemaDir;
    }

    public String getQueryDir() {
        return this.queryDir;
    }

    public void setQueryDir(String queryDir) {
        this.queryDir = queryDir;
    }

    public String getRatisDataRegionSnapshotDir() {
        return this.ratisDataRegionSnapshotDir;
    }

    public void setRatisDataRegionSnapshotDir(String ratisDataRegionSnapshotDir) {
        this.ratisDataRegionSnapshotDir = ratisDataRegionSnapshotDir;
    }

    public String getConsensusDir() {
        return this.consensusDir;
    }

    public void setConsensusDir(String consensusDir) {
        this.consensusDir = consensusDir;
        this.setDataRegionConsensusDir(consensusDir + File.separator + "data_region");
        this.setSchemaRegionConsensusDir(consensusDir + File.separator + "schema_region");
        this.setInvalidDataRegionConsensusDir(consensusDir + File.separator + "invalid_data_region");
    }

    public String getDataRegionConsensusDir() {
        return this.dataRegionConsensusDir;
    }

    public void setDataRegionConsensusDir(String dataRegionConsensusDir) {
        this.dataRegionConsensusDir = dataRegionConsensusDir;
    }

    public String getInvalidDataRegionConsensusDir() {
        return this.invalidDataRegionConsensusDir;
    }

    public void setInvalidDataRegionConsensusDir(String invalidDataRegionConsensusDir) {
        this.invalidDataRegionConsensusDir = invalidDataRegionConsensusDir;
    }

    public String getSchemaRegionConsensusDir() {
        return this.schemaRegionConsensusDir;
    }

    public void setSchemaRegionConsensusDir(String schemaRegionConsensusDir) {
        this.schemaRegionConsensusDir = schemaRegionConsensusDir;
    }

    public String getExtDir() {
        return this.extDir;
    }

    public void setExtDir(String extDir) {
        this.extDir = extDir;
    }

    public String getUdfDir() {
        return this.udfDir;
    }

    public void setUdfDir(String udfDir) {
        this.udfDir = udfDir;
        this.updateUdfTemporaryLibDir();
    }

    public String getUdfTemporaryLibDir() {
        return this.udfTemporaryLibDir;
    }

    public void updateUdfTemporaryLibDir() {
        this.udfTemporaryLibDir = this.udfDir + File.separator + "tmp";
    }

    public String getTriggerDir() {
        return this.triggerDir;
    }

    public void setTriggerDir(String triggerDir) {
        this.triggerDir = triggerDir;
        this.updateTriggerTemporaryLibDir();
    }

    public String getTriggerTemporaryLibDir() {
        return this.triggerTemporaryLibDir;
    }

    public void updateTriggerTemporaryLibDir() {
        this.triggerTemporaryLibDir = this.triggerDir + File.separator + "tmp";
    }

    public String getPipeLibDir() {
        return this.pipeDir;
    }

    public void setPipeLibDir(String pipeDir) {
        this.pipeDir = pipeDir;
        this.updatePipeTemporaryLibDir();
    }

    public String getPipeTemporaryLibDir() {
        return this.pipeTemporaryLibDir;
    }

    public void updatePipeTemporaryLibDir() {
        this.pipeTemporaryLibDir = this.pipeDir + File.separator + "tmp";
    }

    public String getMqttDir() {
        return this.mqttDir;
    }

    public void setMqttDir(String mqttDir) {
        this.mqttDir = mqttDir;
    }

    public String getMultiDirStrategyClassName() {
        return this.multiDirStrategyClassName;
    }

    void setMultiDirStrategyClassName(String multiDirStrategyClassName) {
        this.multiDirStrategyClassName = multiDirStrategyClassName;
    }

    public void checkMultiDirStrategyClassName() {
        this.confirmMultiDirStrategy();
        for (String multiDirStrategy : CLUSTER_ALLOWED_MULTI_DIR_STRATEGIES) {
            if (!this.multiDirStrategyClassName.equals(multiDirStrategy) && !this.multiDirStrategyClassName.equals(MULTI_DIR_STRATEGY_PREFIX + multiDirStrategy)) continue;
            return;
        }
        String msg = String.format("Cannot set multi_dir_strategy to %s, because cluster mode only allows %s.", this.multiDirStrategyClassName, Arrays.toString(CLUSTER_ALLOWED_MULTI_DIR_STRATEGIES));
        logger.error(msg);
        throw new RuntimeException(msg);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getMaxMemtableNumber() {
        return this.maxMemtableNumber;
    }

    public void setMaxMemtableNumber(int maxMemtableNumber) {
        this.maxMemtableNumber = maxMemtableNumber;
    }

    public int getFlushThreadCount() {
        return this.flushThreadCount;
    }

    void setFlushThreadCount(int flushThreadCount) {
        this.flushThreadCount = flushThreadCount;
    }

    public void setDegreeOfParallelism(int degreeOfParallelism) {
        if (degreeOfParallelism > 0) {
            this.degreeOfParallelism = degreeOfParallelism;
        }
    }

    public int getDegreeOfParallelism() {
        return this.degreeOfParallelism;
    }

    public void setMergeThresholdOfExplainAnalyze(int mergeThresholdOfExplainAnalyze) {
        this.mergeThresholdOfExplainAnalyze = mergeThresholdOfExplainAnalyze;
    }

    public int getMergeThresholdOfExplainAnalyze() {
        return this.mergeThresholdOfExplainAnalyze;
    }

    public int getMaxAllowedConcurrentQueries() {
        return this.maxAllowedConcurrentQueries;
    }

    public void setMaxAllowedConcurrentQueries(int maxAllowedConcurrentQueries) {
        this.maxAllowedConcurrentQueries = maxAllowedConcurrentQueries;
    }

    public int getWindowEvaluationThreadCount() {
        return this.windowEvaluationThreadCount;
    }

    public void setWindowEvaluationThreadCount(int windowEvaluationThreadCount) {
        this.windowEvaluationThreadCount = windowEvaluationThreadCount;
    }

    public int getMaxPendingWindowEvaluationTasks() {
        return this.maxPendingWindowEvaluationTasks;
    }

    public void setMaxPendingWindowEvaluationTasks(int maxPendingWindowEvaluationTasks) {
        this.maxPendingWindowEvaluationTasks = maxPendingWindowEvaluationTasks;
    }

    public long getSeqTsFileSize() {
        return this.seqTsFileSize;
    }

    public void setSeqTsFileSize(long seqTsFileSize) {
        this.seqTsFileSize = seqTsFileSize;
    }

    public long getUnSeqTsFileSize() {
        return this.unSeqTsFileSize;
    }

    public void setUnSeqTsFileSize(long unSeqTsFileSize) {
        this.unSeqTsFileSize = unSeqTsFileSize;
    }

    public int getRpcSelectorThreadCount() {
        return this.rpcSelectorThreadCount;
    }

    public void setRpcSelectorThreadCount(int rpcSelectorThreadCount) {
        this.rpcSelectorThreadCount = rpcSelectorThreadCount;
    }

    public int getRpcMaxConcurrentClientNum() {
        return this.rpcMaxConcurrentClientNum;
    }

    void setRpcMaxConcurrentClientNum(int rpcMaxConcurrentClientNum) {
        this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
    }

    public int getmRemoteSchemaCacheSize() {
        return this.mRemoteSchemaCacheSize;
    }

    public void setmRemoteSchemaCacheSize(int mRemoteSchemaCacheSize) {
        this.mRemoteSchemaCacheSize = mRemoteSchemaCacheSize;
    }

    String getLanguageVersion() {
        return this.languageVersion;
    }

    void setLanguageVersion(String languageVersion) {
        this.languageVersion = languageVersion;
    }

    public String getIoTDBVersion() {
        return IoTDBConstant.VERSION;
    }

    public String getIoTDBMajorVersion() {
        return IoTDBConstant.MAJOR_VERSION;
    }

    public String getIoTDBMajorVersion(String version) {
        return "UNKNOWN".equals(version) ? "UNKNOWN" : version.split("\\.")[0] + "." + version.split("\\.")[1];
    }

    public long getCacheFileReaderClearPeriod() {
        return this.cacheFileReaderClearPeriod;
    }

    public void setCacheFileReaderClearPeriod(long cacheFileReaderClearPeriod) {
        this.cacheFileReaderClearPeriod = cacheFileReaderClearPeriod;
    }

    public long getQueryTimeoutThreshold() {
        return this.queryTimeoutThreshold;
    }

    public void setQueryTimeoutThreshold(long queryTimeoutThreshold) {
        this.queryTimeoutThreshold = queryTimeoutThreshold;
    }

    public int getSessionTimeoutThreshold() {
        return this.sessionTimeoutThreshold;
    }

    public void setSessionTimeoutThreshold(int sessionTimeoutThreshold) {
        this.sessionTimeoutThreshold = sessionTimeoutThreshold;
    }

    public String getRpcImplClassName() {
        return this.rpcImplClassName;
    }

    public void setRpcImplClassName(String rpcImplClassName) {
        this.rpcImplClassName = rpcImplClassName;
    }

    public WALMode getWalMode() {
        return this.walMode;
    }

    public void setWalMode(WALMode walMode) {
        this.walMode = walMode;
    }

    public int getMaxWalNodesNum() {
        return this.maxWalNodesNum;
    }

    void setMaxWalNodesNum(int maxWalNodesNum) {
        this.maxWalNodesNum = maxWalNodesNum;
    }

    public long getWalAsyncModeFsyncDelayInMs() {
        return this.walAsyncModeFsyncDelayInMs;
    }

    void setWalAsyncModeFsyncDelayInMs(long walAsyncModeFsyncDelayInMs) {
        this.walAsyncModeFsyncDelayInMs = walAsyncModeFsyncDelayInMs;
    }

    public long getWalSyncModeFsyncDelayInMs() {
        return this.walSyncModeFsyncDelayInMs;
    }

    public void setWalSyncModeFsyncDelayInMs(long walSyncModeFsyncDelayInMs) {
        this.walSyncModeFsyncDelayInMs = walSyncModeFsyncDelayInMs;
    }

    public int getWalBufferSize() {
        return this.walBufferSize;
    }

    public void setWalBufferSize(int walBufferSize) {
        this.walBufferSize = walBufferSize;
    }

    public int getDeletionAheadLogBufferQueueCapacity() {
        return this.deletionAheadLogBufferQueueCapacity;
    }

    void setDeletionAheadLogBufferQueueCapacity(int deletionAheadLogBufferQueueCapacity) {
        this.deletionAheadLogBufferQueueCapacity = deletionAheadLogBufferQueueCapacity;
    }

    public long getWalFileSizeThresholdInByte() {
        return this.walFileSizeThresholdInByte;
    }

    public void setWalFileSizeThresholdInByte(long walFileSizeThresholdInByte) {
        this.walFileSizeThresholdInByte = walFileSizeThresholdInByte;
    }

    public long getCheckpointFileSizeThresholdInByte() {
        return this.checkpointFileSizeThresholdInByte;
    }

    public void setCheckpointFileSizeThresholdInByte(long checkpointFileSizeThresholdInByte) {
        this.checkpointFileSizeThresholdInByte = checkpointFileSizeThresholdInByte;
    }

    public double getWalMinEffectiveInfoRatio() {
        return this.walMinEffectiveInfoRatio;
    }

    void setWalMinEffectiveInfoRatio(double walMinEffectiveInfoRatio) {
        this.walMinEffectiveInfoRatio = walMinEffectiveInfoRatio;
    }

    public long getWalMemTableSnapshotThreshold() {
        return this.walMemTableSnapshotThreshold;
    }

    void setWalMemTableSnapshotThreshold(long walMemTableSnapshotThreshold) {
        this.walMemTableSnapshotThreshold = walMemTableSnapshotThreshold;
    }

    public int getMaxWalMemTableSnapshotNum() {
        return this.maxWalMemTableSnapshotNum;
    }

    void setMaxWalMemTableSnapshotNum(int maxWalMemTableSnapshotNum) {
        this.maxWalMemTableSnapshotNum = maxWalMemTableSnapshotNum;
    }

    public long getDeleteWalFilesPeriodInMs() {
        return this.deleteWalFilesPeriodInMs;
    }

    void setDeleteWalFilesPeriodInMs(long deleteWalFilesPeriodInMs) {
        this.deleteWalFilesPeriodInMs = deleteWalFilesPeriodInMs;
    }

    public boolean getWALCacheShrinkClearEnabled() {
        return this.WALCacheShrinkClearEnabled;
    }

    void setWALCacheShrinkClearEnabled(boolean WALCacheShrinkClearEnabled) {
        this.WALCacheShrinkClearEnabled = WALCacheShrinkClearEnabled;
    }

    public boolean isChunkBufferPoolEnable() {
        return this.chunkBufferPoolEnable;
    }

    void setChunkBufferPoolEnable(boolean chunkBufferPoolEnable) {
        this.chunkBufferPoolEnable = chunkBufferPoolEnable;
    }

    public long getMergeIntervalSec() {
        return this.mergeIntervalSec;
    }

    void setMergeIntervalSec(long mergeIntervalSec) {
        this.mergeIntervalSec = mergeIntervalSec;
    }

    public double getFlushProportion() {
        return this.flushProportion;
    }

    public void setFlushProportion(double flushProportion) {
        this.flushProportion = flushProportion;
    }

    public double getWriteMemoryVariationReportProportion() {
        return this.writeMemoryVariationReportProportion;
    }

    public void setWriteMemoryVariationReportProportion(double writeMemoryVariationReportProportion) {
        this.writeMemoryVariationReportProportion = writeMemoryVariationReportProportion;
    }

    public boolean isEnablePartialInsert() {
        return this.enablePartialInsert;
    }

    public void setEnablePartialInsert(boolean enablePartialInsert) {
        this.enablePartialInsert = enablePartialInsert;
    }

    public boolean isEnable13DataInsertAdapt() {
        return this.enable13DataInsertAdapt;
    }

    public void setEnable13DataInsertAdapt(boolean enable13DataInsertAdapt) {
        this.enable13DataInsertAdapt = enable13DataInsertAdapt;
    }

    public int getCompactionThreadCount() {
        return this.compactionThreadCount;
    }

    public void setCompactionThreadCount(int compactionThreadCount) {
        this.compactionThreadCount = compactionThreadCount;
    }

    public int getCompactionMaxAlignedSeriesNumInOneBatch() {
        return this.compactionMaxAlignedSeriesNumInOneBatch;
    }

    public void setCompactionMaxAlignedSeriesNumInOneBatch(int compactionMaxAlignedSeriesNumInOneBatch) {
        this.compactionMaxAlignedSeriesNumInOneBatch = compactionMaxAlignedSeriesNumInOneBatch;
    }

    public int getContinuousQueryThreadNum() {
        return this.continuousQueryThreadNum;
    }

    public void setContinuousQueryThreadNum(int continuousQueryThreadNum) {
        this.continuousQueryThreadNum = continuousQueryThreadNum;
    }

    public long getContinuousQueryMinimumEveryInterval() {
        return this.continuousQueryMinimumEveryInterval;
    }

    public void setContinuousQueryMinimumEveryInterval(long minimumEveryInterval) {
        this.continuousQueryMinimumEveryInterval = minimumEveryInterval;
    }

    public long getIntoOperationBufferSizeInByte() {
        return this.intoOperationBufferSizeInByte;
    }

    public void setIntoOperationBufferSizeInByte(long intoOperationBufferSizeInByte) {
        this.intoOperationBufferSizeInByte = intoOperationBufferSizeInByte;
    }

    public int getSelectIntoInsertTabletPlanRowLimit() {
        return this.selectIntoInsertTabletPlanRowLimit;
    }

    public void setSelectIntoInsertTabletPlanRowLimit(int selectIntoInsertTabletPlanRowLimit) {
        this.selectIntoInsertTabletPlanRowLimit = selectIntoInsertTabletPlanRowLimit;
    }

    public int getIntoOperationExecutionThreadCount() {
        return this.intoOperationExecutionThreadCount;
    }

    public void setIntoOperationExecutionThreadCount(int intoOperationExecutionThreadCount) {
        this.intoOperationExecutionThreadCount = intoOperationExecutionThreadCount;
    }

    public int getCompactionWriteThroughputMbPerSec() {
        return this.compactionWriteThroughputMbPerSec;
    }

    public void setCompactionWriteThroughputMbPerSec(int compactionWriteThroughputMbPerSec) {
        this.compactionWriteThroughputMbPerSec = compactionWriteThroughputMbPerSec;
    }

    public int getCompactionReadThroughputMbPerSec() {
        return this.compactionReadThroughputMbPerSec;
    }

    public void setCompactionReadThroughputMbPerSec(int compactionReadThroughputMbPerSec) {
        this.compactionReadThroughputMbPerSec = compactionReadThroughputMbPerSec;
    }

    public int getCompactionReadOperationPerSec() {
        return this.compactionReadOperationPerSec;
    }

    public void setCompactionReadOperationPerSec(int compactionReadOperationPerSec) {
        this.compactionReadOperationPerSec = compactionReadOperationPerSec;
    }

    public boolean isEnableTimedFlushSeqMemtable() {
        return this.enableTimedFlushSeqMemtable;
    }

    public void setEnableTimedFlushSeqMemtable(boolean enableTimedFlushSeqMemtable) {
        this.enableTimedFlushSeqMemtable = enableTimedFlushSeqMemtable;
    }

    public long getSeqMemtableFlushInterval() {
        return this.seqMemtableFlushInterval;
    }

    public void setSeqMemtableFlushInterval(long seqMemtableFlushInterval) {
        this.seqMemtableFlushInterval = seqMemtableFlushInterval;
    }

    public long getSeqMemtableFlushCheckInterval() {
        return this.seqMemtableFlushCheckInterval;
    }

    public void setSeqMemtableFlushCheckInterval(long seqMemtableFlushCheckInterval) {
        this.seqMemtableFlushCheckInterval = seqMemtableFlushCheckInterval;
    }

    public boolean isEnableTimedFlushUnseqMemtable() {
        return this.enableTimedFlushUnseqMemtable;
    }

    public void setEnableTimedFlushUnseqMemtable(boolean enableTimedFlushUnseqMemtable) {
        this.enableTimedFlushUnseqMemtable = enableTimedFlushUnseqMemtable;
    }

    public long getUnseqMemtableFlushInterval() {
        return this.unseqMemtableFlushInterval;
    }

    public void setUnseqMemtableFlushInterval(long unseqMemtableFlushInterval) {
        this.unseqMemtableFlushInterval = unseqMemtableFlushInterval;
    }

    public long getUnseqMemtableFlushCheckInterval() {
        return this.unseqMemtableFlushCheckInterval;
    }

    public void setUnseqMemtableFlushCheckInterval(long unseqMemtableFlushCheckInterval) {
        this.unseqMemtableFlushCheckInterval = unseqMemtableFlushCheckInterval;
    }

    public TVListSortAlgorithm getTvListSortAlgorithm() {
        return this.tvListSortAlgorithm;
    }

    public void setTvListSortAlgorithm(TVListSortAlgorithm tvListSortAlgorithm) {
        this.tvListSortAlgorithm = tvListSortAlgorithm;
    }

    public int getTvListSortThreshold() {
        return this.tvListSortThreshold;
    }

    public void setTVListSortThreshold(int tvListSortThreshold) {
        this.tvListSortThreshold = tvListSortThreshold;
    }

    public boolean isRpcThriftCompressionEnable() {
        return this.rpcThriftCompressionEnable;
    }

    public void setRpcThriftCompressionEnable(boolean rpcThriftCompressionEnable) {
        this.rpcThriftCompressionEnable = rpcThriftCompressionEnable;
    }

    public boolean isAutoCreateSchemaEnabled() {
        return this.enableAutoCreateSchema;
    }

    public void setAutoCreateSchemaEnabled(boolean enableAutoCreateSchema) {
        this.enableAutoCreateSchema = enableAutoCreateSchema;
    }

    public TSDataType getBooleanStringInferType() {
        return this.booleanStringInferType;
    }

    public void setBooleanStringInferType(TSDataType booleanStringInferType) {
        if (booleanStringInferType != TSDataType.BOOLEAN && booleanStringInferType != TSDataType.TEXT) {
            logger.warn("Config Property boolean_string_infer_type can only be BOOLEAN or TEXT but is {}", (Object)booleanStringInferType);
            return;
        }
        this.booleanStringInferType = booleanStringInferType;
    }

    public TSDataType getIntegerStringInferType() {
        return this.integerStringInferType;
    }

    public void setIntegerStringInferType(TSDataType integerStringInferType) {
        this.integerStringInferType = integerStringInferType;
    }

    public TSDataType getFloatingStringInferType() {
        return this.floatingStringInferType;
    }

    public void setFloatingStringInferType(TSDataType floatingNumberStringInferType) {
        if (floatingNumberStringInferType != TSDataType.DOUBLE && floatingNumberStringInferType != TSDataType.FLOAT && floatingNumberStringInferType != TSDataType.TEXT) {
            logger.warn("Config Property floating_string_infer_type can only be FLOAT, DOUBLE or TEXT but is {}", (Object)floatingNumberStringInferType);
            return;
        }
        this.floatingStringInferType = floatingNumberStringInferType;
    }

    public TSDataType getNanStringInferType() {
        return this.nanStringInferType;
    }

    public void setNanStringInferType(TSDataType nanStringInferType) {
        if (nanStringInferType != TSDataType.DOUBLE && nanStringInferType != TSDataType.FLOAT && nanStringInferType != TSDataType.TEXT) {
            logger.warn("Config Property nan_string_infer_type can only be FLOAT, DOUBLE or TEXT but is {}", (Object)nanStringInferType);
            return;
        }
        this.nanStringInferType = nanStringInferType;
    }

    public int getDefaultStorageGroupLevel() {
        return this.defaultStorageGroupLevel;
    }

    void setDefaultStorageGroupLevel(int defaultStorageGroupLevel, boolean startUp) {
        if (defaultStorageGroupLevel < 1) {
            if (startUp) {
                logger.warn("Illegal defaultStorageGroupLevel: {}, should >= 1, use default value 1", (Object)defaultStorageGroupLevel);
                defaultStorageGroupLevel = 1;
            } else {
                throw new IllegalArgumentException(String.format("Illegal defaultStorageGroupLevel: %d, should >= 1", defaultStorageGroupLevel));
            }
        }
        this.defaultStorageGroupLevel = defaultStorageGroupLevel;
    }

    public TSEncoding getDefaultBooleanEncoding() {
        return this.defaultBooleanEncoding;
    }

    public void setDefaultBooleanEncoding(TSEncoding defaultBooleanEncoding) {
        this.defaultBooleanEncoding = defaultBooleanEncoding;
    }

    void setDefaultBooleanEncoding(String defaultBooleanEncoding) {
        this.defaultBooleanEncoding = TSEncoding.valueOf((String)defaultBooleanEncoding);
    }

    public TSEncoding getDefaultInt32Encoding() {
        return this.defaultInt32Encoding;
    }

    public void setDefaultInt32Encoding(TSEncoding defaultInt32Encoding) {
        this.defaultInt32Encoding = defaultInt32Encoding;
    }

    void setDefaultInt32Encoding(String defaultInt32Encoding) {
        this.defaultInt32Encoding = TSEncoding.valueOf((String)defaultInt32Encoding);
    }

    public TSEncoding getDefaultInt64Encoding() {
        return this.defaultInt64Encoding;
    }

    public void setDefaultInt64Encoding(TSEncoding defaultInt64Encoding) {
        this.defaultInt64Encoding = defaultInt64Encoding;
    }

    void setDefaultInt64Encoding(String defaultInt64Encoding) {
        this.defaultInt64Encoding = TSEncoding.valueOf((String)defaultInt64Encoding);
    }

    public TSEncoding getDefaultFloatEncoding() {
        return this.defaultFloatEncoding;
    }

    public void setDefaultFloatEncoding(TSEncoding defaultFloatEncoding) {
        this.defaultFloatEncoding = defaultFloatEncoding;
    }

    void setDefaultFloatEncoding(String defaultFloatEncoding) {
        this.defaultFloatEncoding = TSEncoding.valueOf((String)defaultFloatEncoding);
    }

    public TSEncoding getDefaultDoubleEncoding() {
        return this.defaultDoubleEncoding;
    }

    public void setDefaultDoubleEncoding(TSEncoding defaultDoubleEncoding) {
        this.defaultDoubleEncoding = defaultDoubleEncoding;
    }

    void setDefaultDoubleEncoding(String defaultDoubleEncoding) {
        this.defaultDoubleEncoding = TSEncoding.valueOf((String)defaultDoubleEncoding);
    }

    public TSEncoding getDefaultTextEncoding() {
        return this.defaultTextEncoding;
    }

    public void setDefaultTextEncoding(TSEncoding defaultTextEncoding) {
        this.defaultTextEncoding = defaultTextEncoding;
    }

    void setDefaultTextEncoding(String defaultTextEncoding) {
        this.defaultTextEncoding = TSEncoding.valueOf((String)defaultTextEncoding);
    }

    FSType getTsFileStorageFs() {
        return this.tsFileStorageFs;
    }

    void setTsFileStorageFs(String tsFileStorageFs) {
        this.tsFileStorageFs = FSType.valueOf((String)tsFileStorageFs);
    }

    public boolean isEnableHDFS() {
        return this.enableHDFS;
    }

    public void setEnableHDFS(boolean enableHDFS) {
        this.enableHDFS = enableHDFS;
    }

    String getCoreSitePath() {
        return this.coreSitePath;
    }

    void setCoreSitePath(String coreSitePath) {
        this.coreSitePath = coreSitePath;
    }

    String getHdfsSitePath() {
        return this.hdfsSitePath;
    }

    void setHdfsSitePath(String hdfsSitePath) {
        this.hdfsSitePath = hdfsSitePath;
    }

    public String[] getHdfsIp() {
        return this.hdfsIp.split(",");
    }

    String getRawHDFSIp() {
        return this.hdfsIp;
    }

    void setHdfsIp(String[] hdfsIp) {
        this.hdfsIp = String.join((CharSequence)",", hdfsIp);
    }

    String getHdfsPort() {
        return this.hdfsPort;
    }

    void setHdfsPort(String hdfsPort) {
        this.hdfsPort = hdfsPort;
    }

    public int getSettleThreadNum() {
        return this.settleThreadNum;
    }

    String getDfsNameServices() {
        return this.dfsNameServices;
    }

    void setDfsNameServices(String dfsNameServices) {
        this.dfsNameServices = dfsNameServices;
    }

    public String[] getDfsHaNamenodes() {
        return this.dfsHaNamenodes.split(",");
    }

    String getRawDfsHaNamenodes() {
        return this.dfsHaNamenodes;
    }

    void setDfsHaNamenodes(String[] dfsHaNamenodes) {
        this.dfsHaNamenodes = String.join((CharSequence)",", dfsHaNamenodes);
    }

    boolean isDfsHaAutomaticFailoverEnabled() {
        return this.dfsHaAutomaticFailoverEnabled;
    }

    void setDfsHaAutomaticFailoverEnabled(boolean dfsHaAutomaticFailoverEnabled) {
        this.dfsHaAutomaticFailoverEnabled = dfsHaAutomaticFailoverEnabled;
    }

    String getDfsClientFailoverProxyProvider() {
        return this.dfsClientFailoverProxyProvider;
    }

    void setDfsClientFailoverProxyProvider(String dfsClientFailoverProxyProvider) {
        this.dfsClientFailoverProxyProvider = dfsClientFailoverProxyProvider;
    }

    boolean isUseKerberos() {
        return this.useKerberos;
    }

    void setUseKerberos(boolean useKerberos) {
        this.useKerberos = useKerberos;
    }

    String getKerberosKeytabFilePath() {
        return this.kerberosKeytabFilePath;
    }

    void setKerberosKeytabFilePath(String kerberosKeytabFilePath) {
        this.kerberosKeytabFilePath = kerberosKeytabFilePath;
    }

    String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    void setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
    }

    public int getThriftServerAwaitTimeForStopService() {
        return this.thriftServerAwaitTimeForStopService;
    }

    public void setThriftServerAwaitTimeForStopService(int thriftServerAwaitTimeForStopService) {
        this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
    }

    public boolean isEnableMQTTService() {
        return this.enableMQTTService;
    }

    public void setEnableMQTTService(boolean enableMQTTService) {
        this.enableMQTTService = enableMQTTService;
    }

    public String getMqttHost() {
        return this.mqttHost;
    }

    public void setMqttHost(String mqttHost) {
        this.mqttHost = mqttHost;
    }

    public int getMqttPort() {
        return this.mqttPort;
    }

    public void setMqttPort(int mqttPort) {
        this.mqttPort = mqttPort;
    }

    public int getMqttHandlerPoolSize() {
        return this.mqttHandlerPoolSize;
    }

    public void setMqttHandlerPoolSize(int mqttHandlerPoolSize) {
        this.mqttHandlerPoolSize = mqttHandlerPoolSize;
    }

    public String getMqttPayloadFormatter() {
        return this.mqttPayloadFormatter;
    }

    public void setMqttPayloadFormatter(String mqttPayloadFormatter) {
        this.mqttPayloadFormatter = mqttPayloadFormatter;
    }

    public String getMqttDataPath() {
        return this.mqttDataPath;
    }

    public void setMqttDataPath(String mqttDataPath) {
        this.mqttDataPath = mqttDataPath;
    }

    public int getMqttMaxMessageSize() {
        return this.mqttMaxMessageSize;
    }

    public void setMqttMaxMessageSize(int mqttMaxMessageSize) {
        this.mqttMaxMessageSize = mqttMaxMessageSize;
    }

    public int getTagAttributeFlushInterval() {
        return this.tagAttributeFlushInterval;
    }

    public void setTagAttributeFlushInterval(int tagAttributeFlushInterval) {
        this.tagAttributeFlushInterval = tagAttributeFlushInterval;
    }

    public int getPrimitiveArraySize() {
        return this.primitiveArraySize;
    }

    public void setPrimitiveArraySize(int primitiveArraySize) {
        this.primitiveArraySize = primitiveArraySize;
    }

    public int getThriftMaxFrameSize() {
        return this.thriftMaxFrameSize;
    }

    public void setThriftMaxFrameSize(int thriftMaxFrameSize) {
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        BaseRpcTransportFactory.setThriftMaxFrameSize((int)this.thriftMaxFrameSize);
    }

    public int getThriftDefaultBufferSize() {
        return this.thriftDefaultBufferSize;
    }

    public void setThriftDefaultBufferSize(int thriftDefaultBufferSize) {
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        BaseRpcTransportFactory.setDefaultBufferCapacity((int)this.thriftDefaultBufferSize);
    }

    public int getCheckPeriodWhenInsertBlocked() {
        return this.checkPeriodWhenInsertBlocked;
    }

    public void setCheckPeriodWhenInsertBlocked(int checkPeriodWhenInsertBlocked) {
        this.checkPeriodWhenInsertBlocked = checkPeriodWhenInsertBlocked;
    }

    public int getMaxWaitingTimeWhenInsertBlocked() {
        return this.maxWaitingTimeWhenInsertBlockedInMs;
    }

    public void setMaxWaitingTimeWhenInsertBlocked(int maxWaitingTimeWhenInsertBlocked) {
        this.maxWaitingTimeWhenInsertBlockedInMs = maxWaitingTimeWhenInsertBlocked;
    }

    public long getSlowQueryThreshold() {
        return this.slowQueryThreshold;
    }

    public void setSlowQueryThreshold(long slowQueryThreshold) {
        this.slowQueryThreshold = slowQueryThreshold;
    }

    public boolean isEnableIndex() {
        return this.enableIndex;
    }

    public void setEnableIndex(boolean enableIndex) {
        this.enableIndex = enableIndex;
    }

    void setConcurrentIndexBuildThread(int concurrentIndexBuildThread) {
        this.concurrentIndexBuildThread = concurrentIndexBuildThread;
    }

    public int getConcurrentIndexBuildThread() {
        return this.concurrentIndexBuildThread;
    }

    public String getIndexRootFolder() {
        return this.indexRootFolder;
    }

    public void setIndexRootFolder(String indexRootFolder) {
        this.indexRootFolder = indexRootFolder;
    }

    public int getDefaultIndexWindowRange() {
        return this.defaultIndexWindowRange;
    }

    public void setDefaultIndexWindowRange(int defaultIndexWindowRange) {
        this.defaultIndexWindowRange = defaultIndexWindowRange;
    }

    public int getDataRegionNum() {
        return this.dataRegionNum;
    }

    public void setDataRegionNum(int dataRegionNum) {
        this.dataRegionNum = dataRegionNum;
    }

    public long getRecoveryLogIntervalInMs() {
        return this.recoveryLogIntervalInMs;
    }

    public void setRecoveryLogIntervalInMs(long recoveryLogIntervalInMs) {
        this.recoveryLogIntervalInMs = recoveryLogIntervalInMs;
    }

    public boolean isRpcAdvancedCompressionEnable() {
        return this.rpcAdvancedCompressionEnable;
    }

    public void setRpcAdvancedCompressionEnable(boolean rpcAdvancedCompressionEnable) {
        this.rpcAdvancedCompressionEnable = rpcAdvancedCompressionEnable;
        ZeroCopyRpcTransportFactory.setUseSnappy((boolean)this.rpcAdvancedCompressionEnable);
    }

    public long getSyncMlogPeriodInMs() {
        return this.syncMlogPeriodInMs;
    }

    public void setSyncMlogPeriodInMs(long syncMlogPeriodInMs) {
        this.syncMlogPeriodInMs = syncMlogPeriodInMs;
    }

    public int getTlogBufferSize() {
        return this.tlogBufferSize;
    }

    public void setTlogBufferSize(int tlogBufferSize) {
        this.tlogBufferSize = tlogBufferSize;
    }

    public boolean isEnableRpcService() {
        return this.enableRpcService;
    }

    public void setEnableRpcService(boolean enableRpcService) {
        this.enableRpcService = enableRpcService;
    }

    public int getIoTaskQueueSizeForFlushing() {
        return this.ioTaskQueueSizeForFlushing;
    }

    public void setIoTaskQueueSizeForFlushing(int ioTaskQueueSizeForFlushing) {
        this.ioTaskQueueSizeForFlushing = ioTaskQueueSizeForFlushing;
    }

    public boolean isEnableSeqSpaceCompaction() {
        return this.enableSeqSpaceCompaction;
    }

    public void setEnableSeqSpaceCompaction(boolean enableSeqSpaceCompaction) {
        this.enableSeqSpaceCompaction = enableSeqSpaceCompaction;
    }

    public boolean isEnableUnseqSpaceCompaction() {
        return this.enableUnseqSpaceCompaction;
    }

    public void setEnableUnseqSpaceCompaction(boolean enableUnseqSpaceCompaction) {
        this.enableUnseqSpaceCompaction = enableUnseqSpaceCompaction;
    }

    public boolean isEnableCrossSpaceCompaction() {
        return this.enableCrossSpaceCompaction;
    }

    public void setEnableCrossSpaceCompaction(boolean enableCrossSpaceCompaction) {
        this.enableCrossSpaceCompaction = enableCrossSpaceCompaction;
    }

    public boolean isEnableAutoRepairCompaction() {
        return this.enableAutoRepairCompaction;
    }

    public void setEnableAutoRepairCompaction(boolean enableAutoRepairCompaction) {
        this.enableAutoRepairCompaction = enableAutoRepairCompaction;
    }

    public InnerSequenceCompactionSelector getInnerSequenceCompactionSelector() {
        return this.innerSequenceCompactionSelector;
    }

    public void setInnerSequenceCompactionSelector(InnerSequenceCompactionSelector innerSequenceCompactionSelector) {
        this.innerSequenceCompactionSelector = innerSequenceCompactionSelector;
    }

    public InnerUnsequenceCompactionSelector getInnerUnsequenceCompactionSelector() {
        return this.innerUnsequenceCompactionSelector;
    }

    public void setInnerUnsequenceCompactionSelector(InnerUnsequenceCompactionSelector innerUnsequenceCompactionSelector) {
        this.innerUnsequenceCompactionSelector = innerUnsequenceCompactionSelector;
    }

    public InnerSeqCompactionPerformer getInnerSeqCompactionPerformer() {
        return this.innerSeqCompactionPerformer;
    }

    public void setInnerSeqCompactionPerformer(InnerSeqCompactionPerformer innerSeqCompactionPerformer) {
        this.innerSeqCompactionPerformer = innerSeqCompactionPerformer;
    }

    public InnerUnseqCompactionPerformer getInnerUnseqCompactionPerformer() {
        return this.innerUnseqCompactionPerformer;
    }

    public void setInnerUnseqCompactionPerformer(InnerUnseqCompactionPerformer innerUnseqCompactionPerformer) {
        this.innerUnseqCompactionPerformer = innerUnseqCompactionPerformer;
    }

    public CrossCompactionSelector getCrossCompactionSelector() {
        return this.crossCompactionSelector;
    }

    public void setCrossCompactionSelector(CrossCompactionSelector crossCompactionSelector) {
        this.crossCompactionSelector = crossCompactionSelector;
    }

    public CrossCompactionPerformer getCrossCompactionPerformer() {
        return this.crossCompactionPerformer;
    }

    public void setCrossCompactionPerformer(CrossCompactionPerformer crossCompactionPerformer) {
        this.crossCompactionPerformer = crossCompactionPerformer;
    }

    public CompactionPriority getCompactionPriority() {
        return this.compactionPriority;
    }

    public void setCompactionPriority(CompactionPriority compactionPriority) {
        this.compactionPriority = compactionPriority;
    }

    public long getTargetCompactionFileSize() {
        return this.targetCompactionFileSize;
    }

    public void setTargetCompactionFileSize(long targetCompactionFileSize) {
        this.targetCompactionFileSize = targetCompactionFileSize;
    }

    public int getMaxLevelGapInInnerCompaction() {
        return this.maxLevelGapInInnerCompaction;
    }

    public void setMaxLevelGapInInnerCompaction(int maxLevelGapInInnerCompaction) {
        this.maxLevelGapInInnerCompaction = maxLevelGapInInnerCompaction;
    }

    public long getInnerCompactionTotalFileSizeThresholdInByte() {
        return this.innerCompactionTotalFileSizeThresholdInByte;
    }

    public void setInnerCompactionTotalFileSizeThresholdInByte(long innerCompactionTotalFileSizeThresholdInByte) {
        this.innerCompactionTotalFileSizeThresholdInByte = innerCompactionTotalFileSizeThresholdInByte;
    }

    public int getInnerCompactionTotalFileNumThreshold() {
        return this.innerCompactionTotalFileNumThreshold;
    }

    public void setInnerCompactionTotalFileNumThreshold(int innerCompactionTotalFileNumThreshold) {
        this.innerCompactionTotalFileNumThreshold = innerCompactionTotalFileNumThreshold;
    }

    public long getTargetChunkSize() {
        return this.targetChunkSize;
    }

    public void setTargetChunkSize(long targetChunkSize) {
        this.targetChunkSize = targetChunkSize;
    }

    public long getChunkSizeLowerBoundInCompaction() {
        return this.chunkSizeLowerBoundInCompaction;
    }

    public void setChunkSizeLowerBoundInCompaction(long chunkSizeLowerBoundInCompaction) {
        this.chunkSizeLowerBoundInCompaction = chunkSizeLowerBoundInCompaction;
    }

    public long getTargetChunkPointNum() {
        return this.targetChunkPointNum;
    }

    public void setTargetChunkPointNum(long targetChunkPointNum) {
        this.targetChunkPointNum = targetChunkPointNum;
    }

    public long getChunkPointNumLowerBoundInCompaction() {
        return this.chunkPointNumLowerBoundInCompaction;
    }

    public void setChunkPointNumLowerBoundInCompaction(long chunkPointNumLowerBoundInCompaction) {
        this.chunkPointNumLowerBoundInCompaction = chunkPointNumLowerBoundInCompaction;
    }

    public long getCompactionAcquireWriteLockTimeout() {
        return this.compactionAcquireWriteLockTimeout;
    }

    public void setCompactionAcquireWriteLockTimeout(long compactionAcquireWriteLockTimeout) {
        this.compactionAcquireWriteLockTimeout = compactionAcquireWriteLockTimeout;
    }

    public long getCompactionScheduleIntervalInMs() {
        return this.compactionScheduleIntervalInMs;
    }

    public void setCompactionScheduleIntervalInMs(long compactionScheduleIntervalInMs) {
        this.compactionScheduleIntervalInMs = compactionScheduleIntervalInMs;
    }

    public int getTTlCheckerNum() {
        return this.ttlCheckerNum;
    }

    public long getMaxExpiredTime() {
        return this.maxExpiredTime;
    }

    public void setMaxExpiredTime(long maxExpiredTime) {
        this.maxExpiredTime = maxExpiredTime;
    }

    public float getExpiredDataRatio() {
        return this.expiredDataRatio;
    }

    public void setExpiredDataRatio(float expiredDataRatio) {
        this.expiredDataRatio = expiredDataRatio;
    }

    public int getInnerCompactionCandidateFileNum() {
        return this.innerCompactionCandidateFileNum;
    }

    public void setInnerCompactionCandidateFileNum(int innerCompactionCandidateFileNum) {
        this.innerCompactionCandidateFileNum = innerCompactionCandidateFileNum;
    }

    public int getFileLimitPerCrossTask() {
        return this.fileLimitPerCrossTask;
    }

    public int getTotalFileLimitForCompactionTask() {
        return this.totalFileLimitForCompactionTask;
    }

    public void setFileLimitPerCrossTask(int fileLimitPerCrossTask) {
        this.fileLimitPerCrossTask = fileLimitPerCrossTask;
    }

    public long getMaxCrossCompactionCandidateFileSize() {
        return this.maxCrossCompactionCandidateFileSize;
    }

    public void setMaxCrossCompactionCandidateFileSize(long maxCrossCompactionCandidateFileSize) {
        this.maxCrossCompactionCandidateFileSize = maxCrossCompactionCandidateFileSize;
    }

    public int getMinCrossCompactionUnseqFileLevel() {
        return this.minCrossCompactionUnseqFileLevel;
    }

    public void setMinCrossCompactionUnseqFileLevel(int minCrossCompactionUnseqFileLevel) {
        this.minCrossCompactionUnseqFileLevel = minCrossCompactionUnseqFileLevel;
    }

    public int getSubCompactionTaskNum() {
        return this.subCompactionTaskNum;
    }

    public void setSubCompactionTaskNum(int subCompactionTaskNum) {
        this.subCompactionTaskNum = subCompactionTaskNum;
    }

    public int getCompactionScheduleThreadNum() {
        return this.compactionScheduleThreadNum;
    }

    public void setCompactionScheduleThreadNum(int compactionScheduleThreadNum) {
        this.compactionScheduleThreadNum = compactionScheduleThreadNum;
    }

    public int getCachedMNodeSizeInPBTreeMode() {
        return this.cachedMNodeSizeInPBTreeMode;
    }

    public void setCachedMNodeSizeInPBTreeMode(int cachedMNodeSizeInPBTreeMode) {
        this.cachedMNodeSizeInPBTreeMode = cachedMNodeSizeInPBTreeMode;
    }

    public short getMinimumSegmentInPBTree() {
        return this.minimumSegmentInPBTree;
    }

    public void setMinimumSegmentInPBTree(short minimumSegmentInPBTree) {
        this.minimumSegmentInPBTree = minimumSegmentInPBTree;
    }

    public int getPageCacheSizeInPBTree() {
        return this.pageCacheSizeInPBTree;
    }

    public void setPageCacheSizeInPBTree(int pageCacheSizeInPBTree) {
        this.pageCacheSizeInPBTree = pageCacheSizeInPBTree;
    }

    public int getPBTreeLogSize() {
        return this.pbTreeLogSize;
    }

    public void setPBTreeLogSize(int pbTreeLogSize) {
        this.pbTreeLogSize = pbTreeLogSize;
    }

    public int getMaxMeasurementNumOfInternalRequest() {
        return this.maxMeasurementNumOfInternalRequest;
    }

    public void setMaxMeasurementNumOfInternalRequest(int maxMeasurementNumOfInternalRequest) {
        this.maxMeasurementNumOfInternalRequest = maxMeasurementNumOfInternalRequest;
    }

    public String getInternalAddress() {
        return this.internalAddress;
    }

    public void setInternalAddress(String internalAddress) {
        this.internalAddress = internalAddress;
    }

    public int getInternalPort() {
        return this.internalPort;
    }

    public void setInternalPort(int internalPort) {
        this.internalPort = internalPort;
    }

    public int getDataRegionConsensusPort() {
        return this.dataRegionConsensusPort;
    }

    public void setDataRegionConsensusPort(int dataRegionConsensusPort) {
        this.dataRegionConsensusPort = dataRegionConsensusPort;
    }

    public int getSchemaRegionConsensusPort() {
        return this.schemaRegionConsensusPort;
    }

    public void setSchemaRegionConsensusPort(int schemaRegionConsensusPort) {
        this.schemaRegionConsensusPort = schemaRegionConsensusPort;
    }

    public TEndPoint getSeedConfigNode() {
        return this.seedConfigNode;
    }

    public void setSeedConfigNode(TEndPoint seedConfigNode) {
        this.seedConfigNode = seedConfigNode;
    }

    public long getJoinClusterRetryIntervalMs() {
        return this.joinClusterRetryIntervalMs;
    }

    public void setJoinClusterRetryIntervalMs(long joinClusterRetryIntervalMs) {
        this.joinClusterRetryIntervalMs = joinClusterRetryIntervalMs;
    }

    public String getDataRegionConsensusProtocolClass() {
        return this.dataRegionConsensusProtocolClass;
    }

    public void setDataRegionConsensusProtocolClass(String dataRegionConsensusProtocolClass) {
        this.dataRegionConsensusProtocolClass = dataRegionConsensusProtocolClass;
    }

    public String getIotConsensusV2Mode() {
        return this.iotConsensusV2Mode;
    }

    public void setIotConsensusV2Mode(String iotConsensusV2Mode) {
        this.iotConsensusV2Mode = iotConsensusV2Mode;
    }

    public String getSchemaRegionConsensusProtocolClass() {
        return this.schemaRegionConsensusProtocolClass;
    }

    public void setSchemaRegionConsensusProtocolClass(String schemaRegionConsensusProtocolClass) {
        this.schemaRegionConsensusProtocolClass = schemaRegionConsensusProtocolClass;
    }

    public String getSeriesPartitionExecutorClass() {
        return this.seriesPartitionExecutorClass;
    }

    public void setSeriesPartitionExecutorClass(String seriesPartitionExecutorClass) {
        this.seriesPartitionExecutorClass = seriesPartitionExecutorClass;
    }

    public int getSeriesPartitionSlotNum() {
        return this.seriesPartitionSlotNum;
    }

    public void setSeriesPartitionSlotNum(int seriesPartitionSlotNum) {
        this.seriesPartitionSlotNum = seriesPartitionSlotNum;
    }

    public int getMppDataExchangePort() {
        return this.mppDataExchangePort;
    }

    public void setMppDataExchangePort(int mppDataExchangePort) {
        this.mppDataExchangePort = mppDataExchangePort;
    }

    public int getMppDataExchangeCorePoolSize() {
        return this.mppDataExchangeCorePoolSize;
    }

    public void setMppDataExchangeCorePoolSize(int mppDataExchangeCorePoolSize) {
        this.mppDataExchangeCorePoolSize = mppDataExchangeCorePoolSize;
    }

    public int getMppDataExchangeMaxPoolSize() {
        return this.mppDataExchangeMaxPoolSize;
    }

    public void setMppDataExchangeMaxPoolSize(int mppDataExchangeMaxPoolSize) {
        this.mppDataExchangeMaxPoolSize = mppDataExchangeMaxPoolSize;
    }

    public int getMppDataExchangeKeepAliveTimeInMs() {
        return this.mppDataExchangeKeepAliveTimeInMs;
    }

    public void setMppDataExchangeKeepAliveTimeInMs(int mppDataExchangeKeepAliveTimeInMs) {
        this.mppDataExchangeKeepAliveTimeInMs = mppDataExchangeKeepAliveTimeInMs;
    }

    public int getConnectionTimeoutInMS() {
        return this.connectionTimeoutInMS;
    }

    public void setConnectionTimeoutInMS(int connectionTimeoutInMS) {
        this.connectionTimeoutInMS = connectionTimeoutInMS;
    }

    public int getMaxClientNumForEachNode() {
        return this.maxClientNumForEachNode;
    }

    public void setMaxClientNumForEachNode(int maxClientNumForEachNode) {
        this.maxClientNumForEachNode = maxClientNumForEachNode;
    }

    public int getSelectorNumOfClientManager() {
        return this.selectorNumOfClientManager;
    }

    public void setSelectorNumOfClientManager(int selectorNumOfClientManager) {
        this.selectorNumOfClientManager = selectorNumOfClientManager;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
        MetricConfigDescriptor.getInstance().getMetricConfig().updateClusterName(clusterName);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public int getDataNodeId() {
        return this.dataNodeId;
    }

    public void setDataNodeId(int dataNodeId) {
        this.dataNodeId = dataNodeId;
    }

    public int getPartitionCacheSize() {
        return this.partitionCacheSize;
    }

    public String getExtPipeDir() {
        return this.extPipeDir;
    }

    public void setExtPipeDir(String extPipeDir) {
        this.extPipeDir = extPipeDir;
    }

    public int getPipeTaskThreadCount() {
        return this.pipeTaskThreadCount;
    }

    public void setPipeTaskThreadCount(int pipeTaskThreadCount) {
        this.pipeTaskThreadCount = pipeTaskThreadCount;
    }

    public void setPartitionCacheSize(int partitionCacheSize) {
        this.partitionCacheSize = partitionCacheSize;
    }

    public int getAuthorCacheSize() {
        return this.authorCacheSize;
    }

    public void setAuthorCacheSize(int authorCacheSize) {
        this.authorCacheSize = authorCacheSize;
    }

    public int getAuthorCacheExpireTime() {
        return this.authorCacheExpireTime;
    }

    public void setAuthorCacheExpireTime(int authorCacheExpireTime) {
        this.authorCacheExpireTime = authorCacheExpireTime;
    }

    public int getTriggerForwardMaxQueueNumber() {
        return this.triggerForwardMaxQueueNumber;
    }

    public void setTriggerForwardMaxQueueNumber(int triggerForwardMaxQueueNumber) {
        this.triggerForwardMaxQueueNumber = triggerForwardMaxQueueNumber;
    }

    public int getTriggerForwardMaxSizePerQueue() {
        return this.triggerForwardMaxSizePerQueue;
    }

    public void setTriggerForwardMaxSizePerQueue(int triggerForwardMaxSizePerQueue) {
        this.triggerForwardMaxSizePerQueue = triggerForwardMaxSizePerQueue;
    }

    public int getTriggerForwardBatchSize() {
        return this.triggerForwardBatchSize;
    }

    public void setTriggerForwardBatchSize(int triggerForwardBatchSize) {
        this.triggerForwardBatchSize = triggerForwardBatchSize;
    }

    public int getTriggerForwardHTTPPoolSize() {
        return this.triggerForwardHTTPPoolSize;
    }

    public void setTriggerForwardHTTPPoolSize(int triggerForwardHTTPPoolSize) {
        this.triggerForwardHTTPPoolSize = triggerForwardHTTPPoolSize;
    }

    public int getTriggerForwardHTTPPOOLMaxPerRoute() {
        return this.triggerForwardHTTPPOOLMaxPerRoute;
    }

    public void setTriggerForwardHTTPPOOLMaxPerRoute(int triggerForwardHTTPPOOLMaxPerRoute) {
        this.triggerForwardHTTPPOOLMaxPerRoute = triggerForwardHTTPPOOLMaxPerRoute;
    }

    public int getTriggerForwardMQTTPoolSize() {
        return this.triggerForwardMQTTPoolSize;
    }

    public void setTriggerForwardMQTTPoolSize(int triggerForwardMQTTPoolSize) {
        this.triggerForwardMQTTPoolSize = triggerForwardMQTTPoolSize;
    }

    public int getRetryNumToFindStatefulTrigger() {
        return this.retryNumToFindStatefulTrigger;
    }

    public void setRetryNumToFindStatefulTrigger(int retryNumToFindStatefulTrigger) {
        this.retryNumToFindStatefulTrigger = retryNumToFindStatefulTrigger;
    }

    public int getCoordinatorReadExecutorSize() {
        return this.coordinatorReadExecutorSize;
    }

    public void setCoordinatorReadExecutorSize(int coordinatorReadExecutorSize) {
        this.coordinatorReadExecutorSize = coordinatorReadExecutorSize;
    }

    public int getCoordinatorWriteExecutorSize() {
        return this.coordinatorWriteExecutorSize;
    }

    public void setCoordinatorWriteExecutorSize(int coordinatorWriteExecutorSize) {
        this.coordinatorWriteExecutorSize = coordinatorWriteExecutorSize;
    }

    public TEndPoint getAddressAndPort() {
        return new TEndPoint(this.rpcAddress, this.rpcPort);
    }

    public String getDataNodeSchemaCacheEvictionPolicy() {
        return this.dataNodeSchemaCacheEvictionPolicy;
    }

    public void setDataNodeSchemaCacheEvictionPolicy(String dataNodeSchemaCacheEvictionPolicy) {
        this.dataNodeSchemaCacheEvictionPolicy = dataNodeSchemaCacheEvictionPolicy;
    }

    public int getDataNodeTableCacheSemaphorePermitNum() {
        return this.dataNodeTableCacheSemaphorePermitNum;
    }

    public void setDataNodeTableCacheSemaphorePermitNum(int dataNodeTableCacheSemaphorePermitNum) {
        this.dataNodeTableCacheSemaphorePermitNum = dataNodeTableCacheSemaphorePermitNum;
    }

    public long getGeneralRegionAttributeSecurityServiceIntervalSeconds() {
        return this.generalRegionAttributeSecurityServiceIntervalSeconds;
    }

    public void setGeneralRegionAttributeSecurityServiceIntervalSeconds(long generalRegionAttributeSecurityServiceIntervalSeconds) {
        this.generalRegionAttributeSecurityServiceIntervalSeconds = generalRegionAttributeSecurityServiceIntervalSeconds;
    }

    public long getGeneralRegionAttributeSecurityServiceTimeoutSeconds() {
        return this.generalRegionAttributeSecurityServiceTimeoutSeconds;
    }

    public void setGeneralRegionAttributeSecurityServiceTimeoutSeconds(long generalRegionAttributeSecurityServiceTimeoutSeconds) {
        this.generalRegionAttributeSecurityServiceTimeoutSeconds = generalRegionAttributeSecurityServiceTimeoutSeconds;
    }

    public long getGeneralRegionAttributeSecurityServiceFailureDurationSecondsToFetch() {
        return this.generalRegionAttributeSecurityServiceFailureDurationSecondsToFetch;
    }

    public void setGeneralRegionAttributeSecurityServiceFailureDurationSecondsToFetch(long generalRegionAttributeSecurityServiceFailureDurationSecondsToFetch) {
        this.generalRegionAttributeSecurityServiceFailureDurationSecondsToFetch = generalRegionAttributeSecurityServiceFailureDurationSecondsToFetch;
    }

    public int getGeneralRegionAttributeSecurityServiceFailureTimesToFetch() {
        return this.generalRegionAttributeSecurityServiceFailureTimesToFetch;
    }

    public void setGeneralRegionAttributeSecurityServiceFailureTimesToFetch(int generalRegionAttributeSecurityServiceFailureTimesToFetch) {
        this.generalRegionAttributeSecurityServiceFailureTimesToFetch = generalRegionAttributeSecurityServiceFailureTimesToFetch;
    }

    public long getDetailContainerMinDegradeMemoryInBytes() {
        return this.detailContainerMinDegradeMemoryInBytes;
    }

    public void setDetailContainerMinDegradeMemoryInBytes(long detailContainerMinDegradeMemoryInBytes) {
        this.detailContainerMinDegradeMemoryInBytes = detailContainerMinDegradeMemoryInBytes;
    }

    public int getSchemaThreadCount() {
        return this.schemaThreadCount;
    }

    public void setSchemaThreadCount(int schemaThreadCount) {
        this.schemaThreadCount = schemaThreadCount;
    }

    public String getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public void setReadConsistencyLevel(String readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
    }

    public int getDriverTaskExecutionTimeSliceInMs() {
        return this.driverTaskExecutionTimeSliceInMs;
    }

    public void setDriverTaskExecutionTimeSliceInMs(int driverTaskExecutionTimeSliceInMs) {
        this.driverTaskExecutionTimeSliceInMs = driverTaskExecutionTimeSliceInMs;
    }

    public static String getEnvironmentVariables() {
        return "\n\tIOTDB_HOME=" + System.getProperty("IOTDB_HOME", "null") + ";\n\t" + "IOTDB_CONF" + "=" + System.getProperty("IOTDB_CONF", "null") + ";\n\t" + "IOTDB_DATA_HOME" + "=" + System.getProperty("IOTDB_DATA_HOME", "null") + ";";
    }

    public long getThrottleThreshold() {
        return this.throttleThreshold;
    }

    public void setThrottleThreshold(long throttleThreshold) {
        this.throttleThreshold = throttleThreshold;
    }

    public double getChunkMetadataSizeProportion() {
        return this.chunkMetadataSizeProportion;
    }

    public void setChunkMetadataSizeProportion(double chunkMetadataSizeProportion) {
        this.chunkMetadataSizeProportion = chunkMetadataSizeProportion;
    }

    public long getCacheWindowTimeInMs() {
        return this.cacheWindowTimeInMs;
    }

    public void setCacheWindowTimeInMs(long cacheWindowTimeInMs) {
        this.cacheWindowTimeInMs = cacheWindowTimeInMs;
    }

    public long getDataRatisConsensusLogAppenderBufferSizeMax() {
        return this.dataRatisConsensusLogAppenderBufferSizeMax;
    }

    public void setDataRatisConsensusLogAppenderBufferSizeMax(long dataRatisConsensusLogAppenderBufferSizeMax) {
        this.dataRatisConsensusLogAppenderBufferSizeMax = dataRatisConsensusLogAppenderBufferSizeMax;
    }

    public String getConfigMessage() {
        StringBuilder configMessage = new StringBuilder();
        String[] notShowArray = new String[]{"NODE_NAME_MATCHER", "PARTIAL_NODE_MATCHER", "STORAGE_GROUP_MATCHER", "STORAGE_GROUP_PATTERN", "NODE_MATCHER", "NODE_PATTERN"};
        List<String> notShowStrings = Arrays.asList(notShowArray);
        for (Field configField : IoTDBConfig.class.getDeclaredFields()) {
            try {
                String configContent;
                String[][] configList;
                String configFieldString = configField.getName();
                if (notShowStrings.contains(configFieldString)) continue;
                String configType = configField.getGenericType().getTypeName();
                if (configType.contains("java.lang.String[][]")) {
                    configList = (String[][])configField.get(this);
                    StringBuilder builder = new StringBuilder();
                    for (String[] strings : configList) {
                        builder.append(Arrays.asList(strings)).append(";");
                    }
                    configContent = builder.toString();
                } else if (configType.contains("java.lang.String[]")) {
                    configList = (String[])configField.get(this);
                    configContent = Arrays.asList(configList).toString();
                } else {
                    configContent = configField.get(this).toString();
                }
                configMessage.append("\n\t").append(configField.getName()).append("=").append(configContent).append(";");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return configMessage.toString();
    }

    public long getDataRatisConsensusSnapshotTriggerThreshold() {
        return this.dataRatisConsensusSnapshotTriggerThreshold;
    }

    public void setDataRatisConsensusSnapshotTriggerThreshold(long dataRatisConsensusSnapshotTriggerThreshold) {
        this.dataRatisConsensusSnapshotTriggerThreshold = dataRatisConsensusSnapshotTriggerThreshold;
    }

    public boolean isDataRatisConsensusLogUnsafeFlushEnable() {
        return this.dataRatisConsensusLogUnsafeFlushEnable;
    }

    public void setDataRatisConsensusLogUnsafeFlushEnable(boolean dataRatisConsensusLogUnsafeFlushEnable) {
        this.dataRatisConsensusLogUnsafeFlushEnable = dataRatisConsensusLogUnsafeFlushEnable;
    }

    public int getDataRatisConsensusLogForceSyncNum() {
        return this.dataRatisConsensusLogForceSyncNum;
    }

    public void setDataRatisConsensusLogForceSyncNum(int dataRatisConsensusLogForceSyncNum) {
        this.dataRatisConsensusLogForceSyncNum = dataRatisConsensusLogForceSyncNum;
    }

    public int getSchemaRatisConsensusLogForceSyncNum() {
        return this.schemaRatisConsensusLogForceSyncNum;
    }

    public void setSchemaRatisConsensusLogForceSyncNum(int schemaRatisConsensusLogForceSyncNum) {
        this.schemaRatisConsensusLogForceSyncNum = schemaRatisConsensusLogForceSyncNum;
    }

    public long getDataRatisConsensusLogSegmentSizeMax() {
        return this.dataRatisConsensusLogSegmentSizeMax;
    }

    public void setDataRatisConsensusLogSegmentSizeMax(long dataRatisConsensusLogSegmentSizeMax) {
        this.dataRatisConsensusLogSegmentSizeMax = dataRatisConsensusLogSegmentSizeMax;
    }

    public long getDataRatisConsensusGrpcFlowControlWindow() {
        return this.dataRatisConsensusGrpcFlowControlWindow;
    }

    public void setDataRatisConsensusGrpcFlowControlWindow(long dataRatisConsensusGrpcFlowControlWindow) {
        this.dataRatisConsensusGrpcFlowControlWindow = dataRatisConsensusGrpcFlowControlWindow;
    }

    public int getDataRatisConsensusGrpcLeaderOutstandingAppendsMax() {
        return this.dataRatisConsensusGrpcLeaderOutstandingAppendsMax;
    }

    public void setDataRatisConsensusGrpcLeaderOutstandingAppendsMax(int dataRatisConsensusGrpcLeaderOutstandingAppendsMax) {
        this.dataRatisConsensusGrpcLeaderOutstandingAppendsMax = dataRatisConsensusGrpcLeaderOutstandingAppendsMax;
    }

    public int getSchemaRatisConsensusGrpcLeaderOutstandingAppendsMax() {
        return this.schemaRatisConsensusGrpcLeaderOutstandingAppendsMax;
    }

    public void setSchemaRatisConsensusGrpcLeaderOutstandingAppendsMax(int schemaRatisConsensusGrpcLeaderOutstandingAppendsMax) {
        this.schemaRatisConsensusGrpcLeaderOutstandingAppendsMax = schemaRatisConsensusGrpcLeaderOutstandingAppendsMax;
    }

    public long getDataRatisConsensusLeaderElectionTimeoutMinMs() {
        return this.dataRatisConsensusLeaderElectionTimeoutMinMs;
    }

    public void setDataRatisConsensusLeaderElectionTimeoutMinMs(long dataRatisConsensusLeaderElectionTimeoutMinMs) {
        this.dataRatisConsensusLeaderElectionTimeoutMinMs = dataRatisConsensusLeaderElectionTimeoutMinMs;
    }

    public long getDataRatisConsensusLeaderElectionTimeoutMaxMs() {
        return this.dataRatisConsensusLeaderElectionTimeoutMaxMs;
    }

    public void setDataRatisConsensusLeaderElectionTimeoutMaxMs(long dataRatisConsensusLeaderElectionTimeoutMaxMs) {
        this.dataRatisConsensusLeaderElectionTimeoutMaxMs = dataRatisConsensusLeaderElectionTimeoutMaxMs;
    }

    public long getSchemaRatisConsensusLogAppenderBufferSizeMax() {
        return this.schemaRatisConsensusLogAppenderBufferSizeMax;
    }

    public void setSchemaRatisConsensusLogAppenderBufferSizeMax(long schemaRatisConsensusLogAppenderBufferSizeMax) {
        this.schemaRatisConsensusLogAppenderBufferSizeMax = schemaRatisConsensusLogAppenderBufferSizeMax;
    }

    public long getSchemaRatisConsensusSnapshotTriggerThreshold() {
        return this.schemaRatisConsensusSnapshotTriggerThreshold;
    }

    public void setSchemaRatisConsensusSnapshotTriggerThreshold(long schemaRatisConsensusSnapshotTriggerThreshold) {
        this.schemaRatisConsensusSnapshotTriggerThreshold = schemaRatisConsensusSnapshotTriggerThreshold;
    }

    public boolean isSchemaRatisConsensusLogUnsafeFlushEnable() {
        return this.schemaRatisConsensusLogUnsafeFlushEnable;
    }

    public void setSchemaRatisConsensusLogUnsafeFlushEnable(boolean schemaRatisConsensusLogUnsafeFlushEnable) {
        this.schemaRatisConsensusLogUnsafeFlushEnable = schemaRatisConsensusLogUnsafeFlushEnable;
    }

    public long getSchemaRatisConsensusLogSegmentSizeMax() {
        return this.schemaRatisConsensusLogSegmentSizeMax;
    }

    public void setSchemaRatisConsensusLogSegmentSizeMax(long schemaRatisConsensusLogSegmentSizeMax) {
        this.schemaRatisConsensusLogSegmentSizeMax = schemaRatisConsensusLogSegmentSizeMax;
    }

    public long getSchemaRatisConsensusGrpcFlowControlWindow() {
        return this.schemaRatisConsensusGrpcFlowControlWindow;
    }

    public void setSchemaRatisConsensusGrpcFlowControlWindow(long schemaRatisConsensusGrpcFlowControlWindow) {
        this.schemaRatisConsensusGrpcFlowControlWindow = schemaRatisConsensusGrpcFlowControlWindow;
    }

    public long getSchemaRatisConsensusLeaderElectionTimeoutMinMs() {
        return this.schemaRatisConsensusLeaderElectionTimeoutMinMs;
    }

    public void setSchemaRatisConsensusLeaderElectionTimeoutMinMs(long schemaRatisConsensusLeaderElectionTimeoutMinMs) {
        this.schemaRatisConsensusLeaderElectionTimeoutMinMs = schemaRatisConsensusLeaderElectionTimeoutMinMs;
    }

    public long getSchemaRatisConsensusLeaderElectionTimeoutMaxMs() {
        return this.schemaRatisConsensusLeaderElectionTimeoutMaxMs;
    }

    public void setSchemaRatisConsensusLeaderElectionTimeoutMaxMs(long schemaRatisConsensusLeaderElectionTimeoutMaxMs) {
        this.schemaRatisConsensusLeaderElectionTimeoutMaxMs = schemaRatisConsensusLeaderElectionTimeoutMaxMs;
    }

    public long getCqMinEveryIntervalInMs() {
        return this.cqMinEveryIntervalInMs;
    }

    public void setCqMinEveryIntervalInMs(long cqMinEveryIntervalInMs) {
        this.cqMinEveryIntervalInMs = cqMinEveryIntervalInMs;
    }

    public double getUsableCompactionMemoryProportion() {
        return 1.0 - this.chunkMetadataSizeProportion;
    }

    public int getPatternMatchingThreshold() {
        return this.patternMatchingThreshold;
    }

    public void setPatternMatchingThreshold(int patternMatchingThreshold) {
        this.patternMatchingThreshold = patternMatchingThreshold;
    }

    public long getDataRatisConsensusRequestTimeoutMs() {
        return this.dataRatisConsensusRequestTimeoutMs;
    }

    public void setDataRatisConsensusRequestTimeoutMs(long dataRatisConsensusRequestTimeoutMs) {
        this.dataRatisConsensusRequestTimeoutMs = dataRatisConsensusRequestTimeoutMs;
    }

    public long getSchemaRatisConsensusRequestTimeoutMs() {
        return this.schemaRatisConsensusRequestTimeoutMs;
    }

    public void setSchemaRatisConsensusRequestTimeoutMs(long schemaRatisConsensusRequestTimeoutMs) {
        this.schemaRatisConsensusRequestTimeoutMs = schemaRatisConsensusRequestTimeoutMs;
    }

    public int getDataRatisConsensusMaxRetryAttempts() {
        return this.dataRatisConsensusMaxRetryAttempts;
    }

    public void setDataRatisConsensusMaxRetryAttempts(int dataRatisConsensusMaxRetryAttempts) {
        this.dataRatisConsensusMaxRetryAttempts = dataRatisConsensusMaxRetryAttempts;
    }

    public int getSchemaRatisConsensusMaxRetryAttempts() {
        return this.schemaRatisConsensusMaxRetryAttempts;
    }

    public void setSchemaRatisConsensusMaxRetryAttempts(int schemaRatisConsensusMaxRetryAttempts) {
        this.schemaRatisConsensusMaxRetryAttempts = schemaRatisConsensusMaxRetryAttempts;
    }

    public long getDataRatisConsensusInitialSleepTimeMs() {
        return this.dataRatisConsensusInitialSleepTimeMs;
    }

    public void setDataRatisConsensusInitialSleepTimeMs(long dataRatisConsensusInitialSleepTimeMs) {
        this.dataRatisConsensusInitialSleepTimeMs = dataRatisConsensusInitialSleepTimeMs;
    }

    public long getSchemaRatisConsensusInitialSleepTimeMs() {
        return this.schemaRatisConsensusInitialSleepTimeMs;
    }

    public void setSchemaRatisConsensusInitialSleepTimeMs(long schemaRatisConsensusInitialSleepTimeMs) {
        this.schemaRatisConsensusInitialSleepTimeMs = schemaRatisConsensusInitialSleepTimeMs;
    }

    public long getDataRatisConsensusMaxSleepTimeMs() {
        return this.dataRatisConsensusMaxSleepTimeMs;
    }

    public void setDataRatisConsensusMaxSleepTimeMs(long dataRatisConsensusMaxSleepTimeMs) {
        this.dataRatisConsensusMaxSleepTimeMs = dataRatisConsensusMaxSleepTimeMs;
    }

    public long getSchemaRatisConsensusMaxSleepTimeMs() {
        return this.schemaRatisConsensusMaxSleepTimeMs;
    }

    public void setSchemaRatisConsensusMaxSleepTimeMs(long schemaRatisConsensusMaxSleepTimeMs) {
        this.schemaRatisConsensusMaxSleepTimeMs = schemaRatisConsensusMaxSleepTimeMs;
    }

    public Properties getCustomizedProperties() {
        return this.customizedProperties;
    }

    public void setCustomizedProperties(Properties customizedProperties) {
        this.customizedProperties = customizedProperties;
    }

    public long getDataRatisConsensusPreserveWhenPurge() {
        return this.dataRatisConsensusPreserveWhenPurge;
    }

    public void setDataRatisConsensusPreserveWhenPurge(long dataRatisConsensusPreserveWhenPurge) {
        this.dataRatisConsensusPreserveWhenPurge = dataRatisConsensusPreserveWhenPurge;
    }

    public long getSchemaRatisConsensusPreserveWhenPurge() {
        return this.schemaRatisConsensusPreserveWhenPurge;
    }

    public void setSchemaRatisConsensusPreserveWhenPurge(long schemaRatisConsensusPreserveWhenPurge) {
        this.schemaRatisConsensusPreserveWhenPurge = schemaRatisConsensusPreserveWhenPurge;
    }

    public long getRatisFirstElectionTimeoutMinMs() {
        return this.ratisFirstElectionTimeoutMinMs;
    }

    public void setRatisFirstElectionTimeoutMinMs(long ratisFirstElectionTimeoutMinMs) {
        this.ratisFirstElectionTimeoutMinMs = ratisFirstElectionTimeoutMinMs;
    }

    public long getRatisFirstElectionTimeoutMaxMs() {
        return this.ratisFirstElectionTimeoutMaxMs;
    }

    public void setRatisFirstElectionTimeoutMaxMs(long ratisFirstElectionTimeoutMaxMs) {
        this.ratisFirstElectionTimeoutMaxMs = ratisFirstElectionTimeoutMaxMs;
    }

    public long getDataRatisLogMax() {
        return this.dataRatisLogMax;
    }

    public void setDataRatisLogMax(long dataRatisLogMax) {
        this.dataRatisLogMax = dataRatisLogMax;
    }

    public long getSchemaRatisLogMax() {
        return this.schemaRatisLogMax;
    }

    public void setSchemaRatisLogMax(long schemaRatisLogMax) {
        this.schemaRatisLogMax = schemaRatisLogMax;
    }

    public int getCandidateCompactionTaskQueueSize() {
        return this.candidateCompactionTaskQueueSize;
    }

    public void setCandidateCompactionTaskQueueSize(int candidateCompactionTaskQueueSize) {
        this.candidateCompactionTaskQueueSize = candidateCompactionTaskQueueSize;
    }

    public boolean isEnableAuditLog() {
        return this.enableAuditLog;
    }

    public void setEnableAuditLog(boolean enableAuditLog) {
        this.enableAuditLog = enableAuditLog;
    }

    public List<AuditLogStorage> getAuditLogStorage() {
        return this.auditLogStorage;
    }

    public void setAuditLogStorage(List<AuditLogStorage> auditLogStorage) {
        this.auditLogStorage = auditLogStorage;
    }

    public List<AuditLogOperation> getAuditLogOperation() {
        return this.auditLogOperation;
    }

    public void setAuditLogOperation(List<AuditLogOperation> auditLogOperation) {
        this.auditLogOperation = auditLogOperation;
    }

    public boolean isEnableAuditLogForNativeInsertApi() {
        return this.enableAuditLogForNativeInsertApi;
    }

    public void setEnableAuditLogForNativeInsertApi(boolean enableAuditLogForNativeInsertApi) {
        this.enableAuditLogForNativeInsertApi = enableAuditLogForNativeInsertApi;
    }

    public void setModeMapSizeThreshold(int modeMapSizeThreshold) {
        this.modeMapSizeThreshold = modeMapSizeThreshold;
    }

    public int getModeMapSizeThreshold() {
        return this.modeMapSizeThreshold;
    }

    public double getMaxAllocateMemoryRatioForLoad() {
        return this.maxAllocateMemoryRatioForLoad;
    }

    public void setMaxAllocateMemoryRatioForLoad(double maxAllocateMemoryRatioForLoad) {
        this.maxAllocateMemoryRatioForLoad = maxAllocateMemoryRatioForLoad;
    }

    public int getLoadTsFileAnalyzeSchemaBatchReadTimeSeriesMetadataCount() {
        return this.loadTsFileAnalyzeSchemaBatchReadTimeSeriesMetadataCount;
    }

    public void setLoadTsFileAnalyzeSchemaBatchReadTimeSeriesMetadataCount(int loadTsFileAnalyzeSchemaBatchReadTimeSeriesMetadataCount) {
        this.loadTsFileAnalyzeSchemaBatchReadTimeSeriesMetadataCount = loadTsFileAnalyzeSchemaBatchReadTimeSeriesMetadataCount;
    }

    public int getLoadTsFileAnalyzeSchemaBatchFlushTimeSeriesNumber() {
        return this.loadTsFileAnalyzeSchemaBatchFlushTimeSeriesNumber;
    }

    public void setLoadTsFileAnalyzeSchemaBatchFlushTimeSeriesNumber(int loadTsFileAnalyzeSchemaBatchFlushTimeSeriesNumber) {
        this.loadTsFileAnalyzeSchemaBatchFlushTimeSeriesNumber = loadTsFileAnalyzeSchemaBatchFlushTimeSeriesNumber;
    }

    public int getLoadTsFileAnalyzeSchemaBatchFlushTableDeviceNumber() {
        return this.loadTsFileAnalyzeSchemaBatchFlushTableDeviceNumber;
    }

    public void setLoadTsFileAnalyzeSchemaBatchFlushTableDeviceNumber(int loadTsFileAnalyzeSchemaBatchFlushTableDeviceNumber) {
        this.loadTsFileAnalyzeSchemaBatchFlushTableDeviceNumber = loadTsFileAnalyzeSchemaBatchFlushTableDeviceNumber;
    }

    public long getLoadTsFileAnalyzeSchemaMemorySizeInBytes() {
        return this.loadTsFileAnalyzeSchemaMemorySizeInBytes;
    }

    public void setLoadTsFileAnalyzeSchemaMemorySizeInBytes(long loadTsFileAnalyzeSchemaMemorySizeInBytes) {
        this.loadTsFileAnalyzeSchemaMemorySizeInBytes = loadTsFileAnalyzeSchemaMemorySizeInBytes;
    }

    public long getLoadTsFileTabletConversionBatchMemorySizeInBytes() {
        return this.loadTsFileTabletConversionBatchMemorySizeInBytes;
    }

    public void setLoadTsFileTabletConversionBatchMemorySizeInBytes(long loadTsFileTabletConversionBatchMemorySizeInBytes) {
        this.loadTsFileTabletConversionBatchMemorySizeInBytes = loadTsFileTabletConversionBatchMemorySizeInBytes;
    }

    public int getLoadTsFileTabletConversionThreadCount() {
        return this.loadTsFileTabletConversionThreadCount;
    }

    public void setLoadTsFileTabletConversionThreadCount(int loadTsFileTabletConversionThreadCount) {
        this.loadTsFileTabletConversionThreadCount = loadTsFileTabletConversionThreadCount;
    }

    public int getLoadTsFileMaxDeviceCountToUseDeviceTimeIndex() {
        return this.loadTsFileMaxDeviceCountToUseDeviceTimeIndex;
    }

    public void setLoadTsFileMaxDeviceCountToUseDeviceTimeIndex(int loadTsFileMaxDeviceCountToUseDeviceTimeIndex) {
        this.loadTsFileMaxDeviceCountToUseDeviceTimeIndex = loadTsFileMaxDeviceCountToUseDeviceTimeIndex;
    }

    public long getLoadChunkMetadataMemorySizeInBytes() {
        return this.loadChunkMetadataMemorySizeInBytes;
    }

    public void setLoadChunkMetadataMemorySizeInBytes(long loadChunkMetadataMemorySizeInBytes) {
        this.loadChunkMetadataMemorySizeInBytes = loadChunkMetadataMemorySizeInBytes;
    }

    public long getLoadMemoryAllocateRetryIntervalMs() {
        return this.loadMemoryAllocateRetryIntervalMs;
    }

    public void setLoadMemoryAllocateRetryIntervalMs(long loadMemoryAllocateRetryIntervalMs) {
        this.loadMemoryAllocateRetryIntervalMs = loadMemoryAllocateRetryIntervalMs;
    }

    public int getLoadMemoryAllocateMaxRetries() {
        return this.loadMemoryAllocateMaxRetries;
    }

    public void setLoadMemoryAllocateMaxRetries(int loadMemoryAllocateMaxRetries) {
        this.loadMemoryAllocateMaxRetries = loadMemoryAllocateMaxRetries;
    }

    public long getLoadCleanupTaskExecutionDelayTimeSeconds() {
        return this.loadCleanupTaskExecutionDelayTimeSeconds;
    }

    public void setLoadCleanupTaskExecutionDelayTimeSeconds(long loadCleanupTaskExecutionDelayTimeSeconds) {
        this.loadCleanupTaskExecutionDelayTimeSeconds = loadCleanupTaskExecutionDelayTimeSeconds;
    }

    public int getLoadTsFileRetryCountOnRegionChange() {
        return this.loadTsFileRetryCountOnRegionChange;
    }

    public void setLoadTsFileRetryCountOnRegionChange(int loadTsFileRetryCountOnRegionChange) {
        this.loadTsFileRetryCountOnRegionChange = loadTsFileRetryCountOnRegionChange;
    }

    public double getLoadWriteThroughputBytesPerSecond() {
        return this.loadWriteThroughputBytesPerSecond;
    }

    public void setLoadWriteThroughputBytesPerSecond(double loadWriteThroughputBytesPerSecond) {
        this.loadWriteThroughputBytesPerSecond = loadWriteThroughputBytesPerSecond;
    }

    public long getLoadTabletConversionThresholdBytes() {
        return this.loadTabletConversionThresholdBytes;
    }

    public void setLoadTabletConversionThresholdBytes(long loadTabletConversionThresholdBytes) {
        this.loadTabletConversionThresholdBytes = loadTabletConversionThresholdBytes;
    }

    public int getLoadActiveListeningMaxThreadNum() {
        return this.loadActiveListeningMaxThreadNum;
    }

    public void setLoadActiveListeningMaxThreadNum(int loadActiveListeningMaxThreadNum) {
        this.loadActiveListeningMaxThreadNum = loadActiveListeningMaxThreadNum;
    }

    public boolean isLoadActiveListeningVerifyEnable() {
        return this.loadActiveListeningVerifyEnable;
    }

    public void setLoadActiveListeningVerifyEnable(boolean loadActiveListeningVerifyEnable) {
        this.loadActiveListeningVerifyEnable = loadActiveListeningVerifyEnable;
    }

    public String getLoadDiskSelectStrategy() {
        return this.loadDiskSelectStrategy;
    }

    public void setLoadDiskSelectStrategy(String loadDiskSelectStrategy) {
        this.loadDiskSelectStrategy = loadDiskSelectStrategy;
    }

    public String getLoadDiskSelectStrategyForIoTV2AndPipe() {
        return this.loadDiskSelectStrategyForIoTV2AndPipe;
    }

    public void setLoadDiskSelectStrategyForIoTV2AndPipe(String loadDiskSelectStrategyForIoTV2AndPipe) {
        this.loadDiskSelectStrategyForIoTV2AndPipe = loadDiskSelectStrategyForIoTV2AndPipe;
    }

    public long getLoadActiveListeningCheckIntervalSeconds() {
        return this.loadActiveListeningCheckIntervalSeconds;
    }

    public void setLoadActiveListeningCheckIntervalSeconds(long loadActiveListeningCheckIntervalSeconds) {
        this.loadActiveListeningCheckIntervalSeconds = loadActiveListeningCheckIntervalSeconds;
    }

    public String getLoadActiveListeningFailDir() {
        return this.loadActiveListeningFailDir == null || Objects.equals(this.loadActiveListeningFailDir, "") ? this.extDir + File.separator + "load" + File.separator + "failed" : this.loadActiveListeningFailDir;
    }

    public void setLoadActiveListeningFailDir(String loadActiveListeningFailDir) {
        this.loadActiveListeningFailDir = IoTDBConfig.addDataHomeDir(loadActiveListeningFailDir);
    }

    public String getLoadActiveListeningPipeDir() {
        return this.loadActiveListeningPipeDir;
    }

    public void setLoadActiveListeningPipeDir(String loadActiveListeningPipeDir) {
        this.loadActiveListeningPipeDir = loadActiveListeningPipeDir;
    }

    public String[] getLoadActiveListeningDirs() {
        String[] stringArray;
        if (Objects.isNull(this.loadActiveListeningDirs) || this.loadActiveListeningDirs.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.extDir + File.separator + "load" + File.separator + "pending";
        } else {
            stringArray = this.loadActiveListeningDirs;
        }
        return stringArray;
    }

    public void setLoadActiveListeningDirs(String[] loadActiveListeningDirs) {
        for (int i = 0; i < loadActiveListeningDirs.length; ++i) {
            loadActiveListeningDirs[i] = IoTDBConfig.addDataHomeDir(loadActiveListeningDirs[i]);
        }
        this.loadActiveListeningDirs = loadActiveListeningDirs;
    }

    public boolean getLoadActiveListeningEnable() {
        return this.loadActiveListeningEnable;
    }

    public void setLoadActiveListeningEnable(boolean loadActiveListeningEnable) {
        this.loadActiveListeningEnable = loadActiveListeningEnable;
    }

    public void setPipeReceiverFileDirs(String[] pipeReceiverFileDirs) {
        this.pipeReceiverFileDirs = pipeReceiverFileDirs;
    }

    public String[] getPipeReceiverFileDirs() {
        String[] stringArray;
        if (Objects.isNull(this.pipeReceiverFileDirs) || this.pipeReceiverFileDirs.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.systemDir + File.separator + "pipe" + File.separator + "receiver";
        } else {
            stringArray = this.pipeReceiverFileDirs;
        }
        return stringArray;
    }

    public void setIotConsensusV2ReceiverFileDirs(String[] iotConsensusV2ReceiverFileDirs) {
        this.iotConsensusV2ReceiverFileDirs = iotConsensusV2ReceiverFileDirs;
    }

    public String[] getIotConsensusV2ReceiverFileDirs() {
        String[] stringArray;
        if (Objects.isNull(this.iotConsensusV2ReceiverFileDirs) || this.iotConsensusV2ReceiverFileDirs.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.systemDir + File.separator + "pipe" + File.separator + "consensus" + File.separator + "receiver";
        } else {
            stringArray = this.iotConsensusV2ReceiverFileDirs;
        }
        return stringArray;
    }

    public boolean isQuotaEnable() {
        return this.quotaEnable;
    }

    public void setQuotaEnable(boolean quotaEnable) {
        this.quotaEnable = quotaEnable;
    }

    public String getRateLimiterType() {
        return this.RateLimiterType;
    }

    public void setRateLimiterType(String rateLimiterType) {
        this.RateLimiterType = rateLimiterType;
    }

    public void setSortBufferSize(long sortBufferSize) {
        this.sortBufferSize = sortBufferSize;
    }

    public long getSortBufferSize() {
        return this.sortBufferSize;
    }

    public void setSortTmpDir(String sortTmpDir) {
        this.sortTmpDir = sortTmpDir;
    }

    public String getSortTmpDir() {
        return this.sortTmpDir;
    }

    public String getObjectStorageBucket() {
        throw new UnsupportedOperationException("object storage is not supported yet");
    }

    public long getDataRatisPeriodicSnapshotInterval() {
        return this.dataRatisPeriodicSnapshotInterval;
    }

    public void setDataRatisPeriodicSnapshotInterval(long dataRatisPeriodicSnapshotInterval) {
        this.dataRatisPeriodicSnapshotInterval = dataRatisPeriodicSnapshotInterval;
    }

    public long getSchemaRatisPeriodicSnapshotInterval() {
        return this.schemaRatisPeriodicSnapshotInterval;
    }

    public void setSchemaRatisPeriodicSnapshotInterval(long schemaRatisPeriodicSnapshotInterval) {
        this.schemaRatisPeriodicSnapshotInterval = schemaRatisPeriodicSnapshotInterval;
    }

    public boolean isEnableTsFileValidation() {
        return this.enableTsFileValidation;
    }

    public void setEnableTsFileValidation(boolean enableTsFileValidation) {
        this.enableTsFileValidation = enableTsFileValidation;
    }

    public long getInnerCompactionTaskSelectionModsFileThreshold() {
        return this.innerCompactionTaskSelectionModsFileThreshold;
    }

    public void setInnerCompactionTaskSelectionModsFileThreshold(long innerCompactionTaskSelectionModsFileThreshold) {
        this.innerCompactionTaskSelectionModsFileThreshold = innerCompactionTaskSelectionModsFileThreshold;
    }

    public double getInnerCompactionTaskSelectionDiskRedundancy() {
        return this.innerCompactionTaskSelectionDiskRedundancy;
    }

    public void setInnerCompactionTaskSelectionDiskRedundancy(double innerCompactionTaskSelectionDiskRedundancy) {
        this.innerCompactionTaskSelectionDiskRedundancy = innerCompactionTaskSelectionDiskRedundancy;
    }

    public TDataNodeLocation generateLocalDataNodeLocation() {
        TDataNodeLocation result = new TDataNodeLocation();
        result.setDataNodeId(this.getDataNodeId());
        result.setClientRpcEndPoint(new TEndPoint(this.getInternalAddress(), this.getRpcPort()));
        result.setInternalEndPoint(new TEndPoint(this.getInternalAddress(), this.getInternalPort()));
        result.setMPPDataExchangeEndPoint(new TEndPoint(this.getInternalAddress(), this.getMppDataExchangePort()));
        result.setDataRegionConsensusEndPoint(new TEndPoint(this.getInternalAddress(), this.getDataRegionConsensusPort()));
        result.setSchemaRegionConsensusEndPoint(new TEndPoint(this.getInternalAddress(), this.getSchemaRegionConsensusPort()));
        return result;
    }

    public CompressionType getWALCompressionAlgorithm() {
        return this.WALCompressionAlgorithm;
    }

    public void setWALCompressionAlgorithm(CompressionType WALCompressionAlgorithm) {
        this.WALCompressionAlgorithm = WALCompressionAlgorithm;
    }

    public LastCacheLoadStrategy getLastCacheLoadStrategy() {
        return this.lastCacheLoadStrategy;
    }

    public void setLastCacheLoadStrategy(LastCacheLoadStrategy lastCacheLoadStrategy) {
        this.lastCacheLoadStrategy = lastCacheLoadStrategy;
    }

    public boolean isCacheLastValuesForLoad() {
        return (this.lastCacheLoadStrategy == LastCacheLoadStrategy.UPDATE || this.lastCacheLoadStrategy == LastCacheLoadStrategy.UPDATE_NO_BLOB) && this.cacheLastValuesForLoad;
    }

    public void setCacheLastValuesForLoad(boolean cacheLastValuesForLoad) {
        this.cacheLastValuesForLoad = cacheLastValuesForLoad;
    }

    public long getCacheLastValuesMemoryBudgetInByte() {
        return this.cacheLastValuesMemoryBudgetInByte;
    }

    public void setCacheLastValuesMemoryBudgetInByte(long cacheLastValuesMemoryBudgetInByte) {
        this.cacheLastValuesMemoryBudgetInByte = cacheLastValuesMemoryBudgetInByte;
    }
}

