/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeactivateTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeEnrichedPlan;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeRegionTaskExecutor;
import org.apache.iotdb.confignode.procedure.state.schema.DeactivateTemplateState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.mpp.rpc.thrift.TConstructSchemaBlackListWithTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TDeactivateTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TDeleteDataForDeleteSchemaReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateMatchedSchemaCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TRollbackSchemaBlackListWithTemplateReq;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeactivateTemplateProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, DeactivateTemplateState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeactivateTemplateProcedure.class);
    private String queryId;
    private Map<PartialPath, List<Template>> templateSetInfo;
    private String requestMessage;
    private PathPatternTree timeSeriesPatternTree;
    private ByteBuffer timeSeriesPatternTreeBytes;
    private Map<String, List<Integer>> dataNodeRequest;
    private static final String CONSENSUS_WRITE_ERROR = "Failed in the write API executing the consensus layer due to: ";

    public DeactivateTemplateProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public DeactivateTemplateProcedure(String queryId, Map<PartialPath, List<Template>> templateSetInfo, boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
        this.queryId = queryId;
        this.setTemplateSetInfo(templateSetInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, DeactivateTemplateState state) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        try {
            switch (state) {
                case CONSTRUCT_BLACK_LIST: {
                    LOGGER.info("Construct schema black list with template {}", (Object)this.requestMessage);
                    if (this.constructBlackList(env) > 0L) {
                        this.setNextState(DeactivateTemplateState.CLEAN_DATANODE_SCHEMA_CACHE);
                        break;
                    }
                    this.setFailure(new ProcedureException((Throwable)new IoTDBException("Target Device Template is not activated on any path matched by given path pattern", TSStatusCode.TEMPLATE_NOT_ACTIVATED.getStatusCode())));
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
                case CLEAN_DATANODE_SCHEMA_CACHE: {
                    LOGGER.info("Invalidate cache of template timeSeries {}", (Object)this.requestMessage);
                    this.invalidateCache(env);
                    break;
                }
                case DELETE_DATA: {
                    LOGGER.info("Delete data of template timeSeries {}", (Object)this.requestMessage);
                    this.deleteData(env);
                    break;
                }
                case DEACTIVATE_TEMPLATE: {
                    LOGGER.info("Deactivate template of {}", (Object)this.requestMessage);
                    this.deactivateTemplate(env);
                    this.collectPayload4Pipe(env);
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
                default: {
                    this.setFailure(new ProcedureException("Unrecognized state " + (Object)((Object)state)));
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
            }
            StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.HAS_MORE_STATE;
            return flow;
        }
        finally {
            LOGGER.info("DeactivateTemplate-[{}] costs {}ms", (Object)state, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private long constructBlackList(ConfigNodeProcedureEnv env) {
        Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup = env.getConfigManager().getRelatedSchemaRegionGroup(this.timeSeriesPatternTree);
        if (targetSchemaRegionGroup.isEmpty()) {
            return 0L;
        }
        final ArrayList successResult = new ArrayList();
        DeactivateTemplateRegionTaskExecutor<TConstructSchemaBlackListWithTemplateReq> constructBlackListTask = new DeactivateTemplateRegionTaskExecutor<TConstructSchemaBlackListWithTemplateReq>("construct schema black list", env, targetSchemaRegionGroup, CnToDnAsyncRequestType.CONSTRUCT_SCHEMA_BLACK_LIST_WITH_TEMPLATE, (dataNodeLocation, consensusGroupIdList) -> new TConstructSchemaBlackListWithTemplateReq(consensusGroupIdList, this.dataNodeRequest)){

            @Override
            protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TSStatus response) {
                ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
                if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    successResult.add(response);
                } else if (response.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    List subStatusList = response.getSubStatus();
                    for (int i = 0; i < subStatusList.size(); ++i) {
                        if (((TSStatus)subStatusList.get(i)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            successResult.add((TSStatus)subStatusList.get(i));
                            continue;
                        }
                        failedRegionList.add(consensusGroupIdList.get(i));
                    }
                } else {
                    failedRegionList.addAll(consensusGroupIdList);
                }
                return failedRegionList;
            }
        };
        constructBlackListTask.execute();
        if (this.isFailed()) {
            return 0L;
        }
        long preDeletedNum = 0L;
        for (TSStatus resp : successResult) {
            preDeletedNum += Long.parseLong(resp.getMessage());
        }
        return preDeletedNum;
    }

    private void invalidateCache(ConfigNodeProcedureEnv env) {
        if (!this.timeSeriesPatternTree.isEmpty()) {
            Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
            DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.INVALIDATE_MATCHED_SCHEMA_CACHE, new TInvalidateMatchedSchemaCacheReq(this.timeSeriesPatternTreeBytes), dataNodeLocationMap);
            CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
            Map statusMap = clientHandler.getResponseMap();
            for (TSStatus status : statusMap.values()) {
                if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                LOGGER.error("Failed to invalidate schema cache of template timeSeries {}", (Object)this.requestMessage);
                this.setFailure(new ProcedureException(new MetadataException("Invalidate schema cache failed")));
                return;
            }
        }
        this.setNextState(DeactivateTemplateState.DELETE_DATA);
    }

    private void deleteData(ConfigNodeProcedureEnv env) {
        Map<TConsensusGroupId, TRegionReplicaSet> relatedDataRegionGroup = env.getConfigManager().getRelatedDataRegionGroup(this.timeSeriesPatternTree);
        if (!relatedDataRegionGroup.isEmpty() && !this.timeSeriesPatternTree.isEmpty()) {
            DeactivateTemplateRegionTaskExecutor<TDeleteDataForDeleteSchemaReq> deleteDataTask = new DeactivateTemplateRegionTaskExecutor<TDeleteDataForDeleteSchemaReq>("delete data", env, relatedDataRegionGroup, true, CnToDnAsyncRequestType.DELETE_DATA_FOR_DELETE_SCHEMA, (dataNodeLocation, consensusGroupIdList) -> new TDeleteDataForDeleteSchemaReq(new ArrayList(consensusGroupIdList), this.timeSeriesPatternTreeBytes));
            deleteDataTask.execute();
        }
        this.setNextState(DeactivateTemplateState.DEACTIVATE_TEMPLATE);
    }

    private void deactivateTemplate(ConfigNodeProcedureEnv env) {
        DeactivateTemplateRegionTaskExecutor<TDeactivateTemplateReq> deleteTimeSeriesTask = new DeactivateTemplateRegionTaskExecutor<TDeactivateTemplateReq>("deactivate template schema", env, env.getConfigManager().getRelatedSchemaRegionGroup(this.timeSeriesPatternTree), CnToDnAsyncRequestType.DEACTIVATE_TEMPLATE, (dataNodeLocation, consensusGroupIdList) -> new TDeactivateTemplateReq(consensusGroupIdList, this.dataNodeRequest).setIsGeneratedByPipe(this.isGeneratedByPipe));
        deleteTimeSeriesTask.execute();
    }

    private void collectPayload4Pipe(ConfigNodeProcedureEnv env) {
        TSStatus result;
        try {
            result = env.getConfigManager().getConsensusManager().write(this.isGeneratedByPipe ? new PipeEnrichedPlan(new PipeDeactivateTemplatePlan(this.templateSetInfo)) : new PipeDeactivateTemplatePlan(this.templateSetInfo));
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            result = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            result.setMessage(e.getMessage());
        }
        if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(result.getMessage());
        }
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, DeactivateTemplateState deactivateTemplateState) throws IOException, InterruptedException, ProcedureException {
        if (deactivateTemplateState == DeactivateTemplateState.CONSTRUCT_BLACK_LIST) {
            DeactivateTemplateRegionTaskExecutor<TRollbackSchemaBlackListWithTemplateReq> rollbackStateTask = new DeactivateTemplateRegionTaskExecutor<TRollbackSchemaBlackListWithTemplateReq>("roll back schema black list", env, env.getConfigManager().getRelatedSchemaRegionGroup(this.timeSeriesPatternTree), CnToDnAsyncRequestType.ROLLBACK_SCHEMA_BLACK_LIST_WITH_TEMPLATE, (dataNodeLocation, consensusGroupIdList) -> new TRollbackSchemaBlackListWithTemplateReq(consensusGroupIdList, this.dataNodeRequest));
            rollbackStateTask.execute();
        }
    }

    @Override
    protected boolean isRollbackSupported(DeactivateTemplateState deactivateTemplateState) {
        return true;
    }

    @Override
    protected DeactivateTemplateState getState(int stateId) {
        return DeactivateTemplateState.values()[stateId];
    }

    @Override
    protected int getStateId(DeactivateTemplateState deactivateTemplateState) {
        return deactivateTemplateState.ordinal();
    }

    @Override
    protected DeactivateTemplateState getInitialState() {
        return DeactivateTemplateState.CONSTRUCT_BLACK_LIST;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public Map<PartialPath, List<Template>> getTemplateSetInfo() {
        return this.templateSetInfo;
    }

    private void setTemplateSetInfo(Map<PartialPath, List<Template>> templateSetInfo) {
        this.templateSetInfo = templateSetInfo;
        this.prepareRequestMessage(templateSetInfo);
        this.prepareTimeSeriesPatternTree(templateSetInfo);
        this.prepareDataNodeRequest(templateSetInfo);
    }

    private void prepareRequestMessage(Map<PartialPath, List<Template>> templateSetInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        for (Map.Entry<PartialPath, List<Template>> entry : templateSetInfo.entrySet()) {
            stringBuilder.append(entry.getKey()).append(":").append(entry.getValue().stream().map(Template::getName).collect(Collectors.toList())).append(";");
        }
        stringBuilder.append("}");
        this.requestMessage = stringBuilder.toString();
    }

    private void prepareTimeSeriesPatternTree(Map<PartialPath, List<Template>> templateSetInfo) {
        PathPatternTree patternTree = new PathPatternTree();
        for (Map.Entry<PartialPath, List<Template>> entry : templateSetInfo.entrySet()) {
            for (Template template : entry.getValue()) {
                for (String measurement : template.getSchemaMap().keySet()) {
                    patternTree.appendPathPattern(entry.getKey().concatNode(measurement));
                }
            }
        }
        patternTree.constructTree();
        this.timeSeriesPatternTree = patternTree;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            patternTree.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.timeSeriesPatternTreeBytes = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    private void prepareDataNodeRequest(Map<PartialPath, List<Template>> templateSetInfo) {
        HashMap<String, List<Integer>> dataNodeRequest = new HashMap<String, List<Integer>>();
        templateSetInfo.forEach((k, v) -> dataNodeRequest.put(k.getFullPath(), v.stream().map(Template::getId).collect(Collectors.toList())));
        this.dataNodeRequest = dataNodeRequest;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_DEACTIVATE_TEMPLATE_PROCEDURE.getTypeCode() : ProcedureType.DEACTIVATE_TEMPLATE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.queryId, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.templateSetInfo.size(), (OutputStream)stream);
        for (Map.Entry<PartialPath, List<Template>> entry : this.templateSetInfo.entrySet()) {
            entry.getKey().serialize((OutputStream)stream);
            ReadWriteIOUtils.write((int)entry.getValue().size(), (OutputStream)stream);
            for (Template template : entry.getValue()) {
                template.serialize((OutputStream)stream);
            }
        }
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.queryId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashMap<PartialPath, List<Template>> templateSetInfo = new HashMap<PartialPath, List<Template>>();
        for (int i = 0; i < size; ++i) {
            PartialPath pattern = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
            int templateNum = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            ArrayList<Template> templateList = new ArrayList<Template>(templateNum);
            for (int j = 0; j < templateNum; ++j) {
                Template template = new Template();
                template.deserialize(byteBuffer);
                templateList.add(template);
            }
            templateSetInfo.put(pattern, templateList);
        }
        this.setTemplateSetInfo(templateSetInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeactivateTemplateProcedure that = (DeactivateTemplateProcedure)o;
        return Objects.equals(this.getProcId(), that.getProcId()) && Objects.equals(this.getCurrentState(), that.getCurrentState()) && Objects.equals(this.getCycles(), that.getCycles()) && Objects.equals(this.isGeneratedByPipe, that.isGeneratedByPipe) && Objects.equals(this.queryId, that.queryId) && Objects.equals(this.templateSetInfo, that.templateSetInfo);
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.isGeneratedByPipe, this.queryId, this.templateSetInfo);
    }

    private class DeactivateTemplateRegionTaskExecutor<Q>
    extends DataNodeRegionTaskExecutor<Q, TSStatus> {
        private final String taskName;

        DeactivateTemplateRegionTaskExecutor(String taskName, ConfigNodeProcedureEnv env, Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup, CnToDnAsyncRequestType dataNodeRequestType, BiFunction<TDataNodeLocation, List<TConsensusGroupId>, Q> dataNodeRequestGenerator) {
            super(env, targetSchemaRegionGroup, false, dataNodeRequestType, dataNodeRequestGenerator);
            this.taskName = taskName;
        }

        DeactivateTemplateRegionTaskExecutor(String taskName, ConfigNodeProcedureEnv env, Map<TConsensusGroupId, TRegionReplicaSet> targetDataRegionGroup, boolean executeOnAllReplicaset, CnToDnAsyncRequestType dataNodeRequestType, BiFunction<TDataNodeLocation, List<TConsensusGroupId>, Q> dataNodeRequestGenerator) {
            super(env, targetDataRegionGroup, executeOnAllReplicaset, dataNodeRequestType, dataNodeRequestGenerator);
            this.taskName = taskName;
        }

        @Override
        protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TSStatus response) {
            ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
            if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return failedRegionList;
            }
            if (response.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                List subStatus = response.getSubStatus();
                for (int i = 0; i < subStatus.size(); ++i) {
                    if (((TSStatus)subStatus.get(i)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                    failedRegionList.add(consensusGroupIdList.get(i));
                }
            } else {
                failedRegionList.addAll(consensusGroupIdList);
            }
            return failedRegionList;
        }

        @Override
        protected void onAllReplicasetFailure(TConsensusGroupId consensusGroupId, Set<TDataNodeLocation> dataNodeLocationSet) {
            DeactivateTemplateProcedure.this.setFailure(new ProcedureException(new MetadataException(String.format("Deactivate template of %s failed when [%s] because failed to execute in all replicaset of %s %s. Failure nodes: %s", DeactivateTemplateProcedure.this.requestMessage, this.taskName, consensusGroupId.type, consensusGroupId.id, dataNodeLocationSet))));
            this.interruptTask();
        }
    }
}

