/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.mechanism;

import java.nio.ByteBuffer;
import java.util.Arrays;
import zmq.Options;
import zmq.ZMQ;
import zmq.io.SessionBase;
import zmq.io.mechanism.Mechanism;
import zmq.io.mechanism.NullMechanism;
import zmq.io.mechanism.curve.CurveClientMechanism;
import zmq.io.mechanism.curve.CurveServerMechanism;
import zmq.io.mechanism.gssapi.GssapiClientMechanism;
import zmq.io.mechanism.gssapi.GssapiServerMechanism;
import zmq.io.mechanism.plain.PlainClientMechanism;
import zmq.io.mechanism.plain.PlainServerMechanism;
import zmq.io.net.Address;

public enum Mechanisms {
    NULL{

        @Override
        public Mechanism create(SessionBase session, Address peerAddress, Options options2) {
            return new NullMechanism(session, peerAddress, options2);
        }
    }
    ,
    PLAIN{

        @Override
        public Mechanism create(SessionBase session, Address peerAddress, Options options2) {
            if (options2.asServer) {
                return new PlainServerMechanism(session, peerAddress, options2);
            }
            return new PlainClientMechanism(options2);
        }
    }
    ,
    CURVE{

        @Override
        public Mechanism create(SessionBase session, Address peerAddress, Options options2) {
            if (options2.asServer) {
                return new CurveServerMechanism(session, peerAddress, options2);
            }
            return new CurveClientMechanism(options2);
        }
    }
    ,
    GSSAPI{

        @Override
        public Mechanism create(SessionBase session, Address peerAddress, Options options2) {
            if (options2.asServer) {
                return new GssapiServerMechanism(session, peerAddress, options2);
            }
            return new GssapiClientMechanism(options2);
        }
    };


    public abstract Mechanism create(SessionBase var1, Address var2, Options var3);

    public boolean isMechanism(ByteBuffer greetingRecv) {
        byte[] dst = new byte[20];
        greetingRecv.get(dst, 0, dst.length);
        byte[] name = this.name().getBytes(ZMQ.CHARSET);
        byte[] comp = Arrays.copyOf(name, 20);
        return Arrays.equals(dst, comp);
    }
}

