/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import zmq.Config;
import zmq.ZMQ;
import zmq.io.coder.IDecoder;
import zmq.io.coder.IEncoder;
import zmq.io.mechanism.Mechanisms;
import zmq.io.net.ipc.IpcAddress;
import zmq.io.net.tcp.TcpAddress;
import zmq.msg.MsgAllocator;
import zmq.msg.MsgAllocatorThreshold;
import zmq.util.Errno;
import zmq.util.ValueReference;
import zmq.util.Z85;

public class Options {
    public int sendHwm = 1000;
    public int recvHwm = 1000;
    public long affinity = 0L;
    public byte identitySize = 0;
    public byte[] identity;
    String lastEndpoint;
    int rate = 100;
    int recoveryIvl = 10000;
    int multicastHops = 1;
    public int sndbuf = 0;
    public int rcvbuf = 0;
    public int tos = 0;
    public int type = -1;
    public int linger = -1;
    public int reconnectIvl = 100;
    public int reconnectIvlMax = 0;
    public int backlog = 100;
    public long maxMsgSize = -1L;
    int recvTimeout = -1;
    int sendTimeout = -1;
    public boolean ipv6 = false;
    public boolean immediate = true;
    public boolean filter = false;
    public boolean recvIdentity = false;
    public boolean rawSocket = false;
    public String socksProxyAddress;
    public int tcpKeepAlive = -1;
    public int tcpKeepAliveCnt = -1;
    public int tcpKeepAliveIdle = -1;
    public int tcpKeepAliveIntvl = -1;
    public final List<TcpAddress.TcpAddressMask> tcpAcceptFilters = new ArrayList<TcpAddress.TcpAddressMask>();
    final List<IpcAddress.IpcAddressMask> ipcAcceptFilters = new ArrayList<IpcAddress.IpcAddressMask>();
    public Mechanisms mechanism = Mechanisms.NULL;
    public boolean asServer = false;
    public String zapDomain = "";
    public String plainUsername;
    public String plainPassword;
    public static final int CURVE_KEYSIZE = 32;
    public static final int CURVE_KEYSIZE_Z85 = 40;
    public byte[] curvePublicKey;
    public byte[] curveSecretKey;
    public byte[] curveServerKey;
    String gssPrincipal;
    String gssServicePrincipal;
    boolean gssPlaintext = false;
    public int socketId = 0;
    public boolean conflate = false;
    public int handshakeIvl = 30000;
    public Class<? extends IDecoder> decoder;
    public Class<? extends IEncoder> encoder;
    public MsgAllocator allocator;
    public final Errno errno = new Errno();

    public Options() {
        this.mechanism = Mechanisms.NULL;
        this.identity = new byte[0];
        this.identitySize = (byte)this.identity.length;
        this.curvePublicKey = new byte[32];
        this.curveSecretKey = new byte[32];
        this.curveServerKey = new byte[32];
        this.allocator = new MsgAllocatorThreshold(Config.MSG_ALLOCATION_HEAP_THRESHOLD.getValue());
    }

    public boolean setSocketOpt(int option2, Object optval) {
        ValueReference<Boolean> result2 = new ValueReference<Boolean>(false);
        switch (option2) {
            case 23: {
                this.sendHwm = (Integer)optval;
                if (this.sendHwm < 0) {
                    throw new IllegalArgumentException("sendHwm " + optval);
                }
                return true;
            }
            case 24: {
                this.recvHwm = (Integer)optval;
                if (this.recvHwm < 0) {
                    throw new IllegalArgumentException("recvHwm " + optval);
                }
                return true;
            }
            case 4: {
                this.affinity = (Long)optval;
                return true;
            }
            case 5: {
                byte[] val = Options.parseBytes(option2, optval);
                if (val == null || val.length > 255) {
                    throw new IllegalArgumentException("identity must not be null or less than 255 " + optval);
                }
                this.identity = Arrays.copyOf(val, val.length);
                this.identitySize = (byte)this.identity.length;
                return true;
            }
            case 8: {
                this.rate = (Integer)optval;
                return true;
            }
            case 9: {
                this.recoveryIvl = (Integer)optval;
                return true;
            }
            case 11: {
                this.sndbuf = (Integer)optval;
                return true;
            }
            case 12: {
                this.rcvbuf = (Integer)optval;
                return true;
            }
            case 57: {
                this.tos = (Integer)optval;
                return true;
            }
            case 17: {
                this.linger = (Integer)optval;
                return true;
            }
            case 18: {
                this.reconnectIvl = (Integer)optval;
                if (this.reconnectIvl < -1) {
                    throw new IllegalArgumentException("reconnectIvl " + optval);
                }
                return true;
            }
            case 21: {
                this.reconnectIvlMax = (Integer)optval;
                if (this.reconnectIvlMax < 0) {
                    throw new IllegalArgumentException("reconnectIvlMax " + optval);
                }
                return true;
            }
            case 19: {
                this.backlog = (Integer)optval;
                return true;
            }
            case 22: {
                this.maxMsgSize = (Long)optval;
                return true;
            }
            case 25: {
                this.multicastHops = (Integer)optval;
                return true;
            }
            case 27: {
                this.recvTimeout = (Integer)optval;
                return true;
            }
            case 28: {
                this.sendTimeout = (Integer)optval;
                return true;
            }
            case 31: {
                return this.setSocketOpt(42, !Options.parseBoolean(option2, optval));
            }
            case 42: {
                this.ipv6 = Options.parseBoolean(option2, optval);
                return true;
            }
            case 67: {
                this.socksProxyAddress = Options.parseString(option2, optval);
                return true;
            }
            case 34: {
                this.tcpKeepAlive = ((Number)optval).intValue();
                if (this.tcpKeepAlive != -1 && this.tcpKeepAlive != 0 && this.tcpKeepAlive != 1) {
                    throw new IllegalArgumentException("tcpKeepAlive only accepts one of -1,0,1 " + optval);
                }
                return true;
            }
            case 35: 
            case 36: 
            case 37: {
                return false;
            }
            case 1039: {
                this.immediate = Options.parseBoolean(option2, optval);
                return true;
            }
            case 39: {
                this.immediate = !Options.parseBoolean(option2, optval);
                return true;
            }
            case 38: {
                String filterStr = Options.parseString(option2, optval);
                if (filterStr == null) {
                    this.tcpAcceptFilters.clear();
                } else {
                    if (filterStr.length() == 0 || filterStr.length() > 255) {
                        throw new IllegalArgumentException("tcp_accept_filter " + optval);
                    }
                    TcpAddress.TcpAddressMask filter2 = new TcpAddress.TcpAddressMask(filterStr, this.ipv6);
                    this.tcpAcceptFilters.add(filter2);
                }
                return true;
            }
            case 44: {
                this.asServer = Options.parseBoolean(option2, optval);
                this.mechanism = this.asServer ? Mechanisms.PLAIN : Mechanisms.NULL;
                return true;
            }
            case 45: {
                if (optval == null) {
                    this.mechanism = Mechanisms.NULL;
                    this.asServer = false;
                    return true;
                }
                this.plainUsername = Options.parseString(option2, optval);
                this.asServer = false;
                this.mechanism = Mechanisms.PLAIN;
                return true;
            }
            case 46: {
                if (optval == null) {
                    this.mechanism = Mechanisms.NULL;
                    this.asServer = false;
                    return true;
                }
                this.plainPassword = Options.parseString(option2, optval);
                this.asServer = false;
                this.mechanism = Mechanisms.PLAIN;
                return true;
            }
            case 55: {
                String domain = Options.parseString(option2, optval);
                if (domain != null && domain.length() < 256) {
                    this.zapDomain = domain;
                    return true;
                }
                throw new IllegalArgumentException("zap domain length shall be < 256 : " + optval);
            }
            case 47: {
                this.asServer = Options.parseBoolean(option2, optval);
                this.mechanism = this.asServer ? Mechanisms.CURVE : Mechanisms.NULL;
                return true;
            }
            case 48: {
                this.curvePublicKey = this.setCurveKey(option2, optval, result2);
                return result2.get();
            }
            case 49: {
                this.curveSecretKey = this.setCurveKey(option2, optval, result2);
                return result2.get();
            }
            case 50: {
                this.curveServerKey = this.setCurveKey(option2, optval, result2);
                if (this.curveServerKey == null) {
                    this.asServer = false;
                }
                return result2.get();
            }
            case 54: {
                this.conflate = Options.parseBoolean(option2, optval);
                return true;
            }
            case 62: {
                this.asServer = Options.parseBoolean(option2, optval);
                this.mechanism = Mechanisms.GSSAPI;
                return true;
            }
            case 63: {
                this.gssPrincipal = Options.parseString(option2, optval);
                this.mechanism = Mechanisms.GSSAPI;
                return true;
            }
            case 64: {
                this.gssServicePrincipal = Options.parseString(option2, optval);
                this.mechanism = Mechanisms.GSSAPI;
                return true;
            }
            case 65: {
                this.gssPlaintext = Options.parseBoolean(option2, optval);
                return true;
            }
            case 66: {
                this.handshakeIvl = (Integer)optval;
                if (this.handshakeIvl < 0) {
                    throw new IllegalArgumentException("handshakeIvl only accept positive values " + optval);
                }
                return true;
            }
            case 1002: {
                this.decoder = this.checkCustomClass(optval, IDecoder.class);
                if (this.decoder == null) {
                    return false;
                }
                this.rawSocket = true;
                return true;
            }
            case 1001: {
                this.encoder = this.checkCustomClass(optval, IEncoder.class);
                if (this.encoder == null) {
                    return false;
                }
                this.rawSocket = true;
                return true;
            }
            case 1003: {
                if (optval instanceof String) {
                    try {
                        this.allocator = this.allocator(Class.forName((String)optval));
                        return true;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                if (optval instanceof Class) {
                    this.allocator = this.allocator((Class)optval);
                    return true;
                }
                if (optval instanceof MsgAllocator) {
                    this.allocator = (MsgAllocator)optval;
                    return true;
                }
                return false;
            }
            case 1004: {
                Integer allocationHeapThreshold = (Integer)optval;
                this.allocator = new MsgAllocatorThreshold(allocationHeapThreshold);
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown Option " + option2);
    }

    private MsgAllocator allocator(Class<?> clazz) {
        try {
            Class<MsgAllocator> msgAllocator = clazz.asSubclass(MsgAllocator.class);
            return msgAllocator.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private <T> Class<? extends T> checkCustomClass(Object optval, Class<T> type) {
        Class clazz = (Class)optval;
        assert (type.isAssignableFrom(clazz));
        Class<T> custom = clazz.asSubclass(type);
        try {
            assert (custom.getConstructor(Integer.TYPE, Long.TYPE) != null);
            return custom;
        }
        catch (NoSuchMethodException | SecurityException e) {
            System.out.println("Custom " + clazz + " has no required constructor <init>(int bufferSize, long maxMsgSize)");
            return null;
        }
    }

    private byte[] setCurveKey(int option2, Object optval, ValueReference<Boolean> result2) {
        if (optval == null) {
            result2.set(false);
            return null;
        }
        byte[] key = null;
        if (optval instanceof byte[] && ((byte[])optval).length == 32) {
            key = (byte[])optval;
            result2.set(true);
            this.errno.set(0);
        } else {
            String val = Options.parseString(option2, optval);
            int length2 = val.length();
            if (length2 == 40) {
                key = Z85.decode(val);
                result2.set(true);
                this.errno.set(0);
            } else if (length2 == 32) {
                key = val.getBytes(ZMQ.CHARSET);
                result2.set(true);
                this.errno.set(0);
            } else {
                result2.set(false);
                this.errno.set(22);
            }
        }
        if (key != null) {
            this.mechanism = Mechanisms.CURVE;
        }
        return key;
    }

    public Object getSocketOpt(int option2) {
        switch (option2) {
            case 23: {
                return this.sendHwm;
            }
            case 24: {
                return this.recvHwm;
            }
            case 4: {
                return this.affinity;
            }
            case 5: {
                return this.identity;
            }
            case 8: {
                return this.rate;
            }
            case 9: {
                return this.recoveryIvl;
            }
            case 11: {
                return this.sndbuf;
            }
            case 12: {
                return this.rcvbuf;
            }
            case 57: {
                return this.tos;
            }
            case 16: {
                return this.type;
            }
            case 17: {
                return this.linger;
            }
            case 18: {
                return this.reconnectIvl;
            }
            case 21: {
                return this.reconnectIvlMax;
            }
            case 19: {
                return this.backlog;
            }
            case 22: {
                return this.maxMsgSize;
            }
            case 25: {
                return this.multicastHops;
            }
            case 27: {
                return this.recvTimeout;
            }
            case 28: {
                return this.sendTimeout;
            }
            case 31: {
                return !this.ipv6;
            }
            case 42: {
                return this.ipv6;
            }
            case 34: {
                return this.tcpKeepAlive;
            }
            case 1039: {
                return this.immediate;
            }
            case 39: {
                return !this.immediate;
            }
            case 67: {
                return this.socksProxyAddress;
            }
            case 35: 
            case 36: 
            case 37: {
                return 0;
            }
            case 43: {
                return this.mechanism;
            }
            case 44: {
                return this.asServer && this.mechanism == Mechanisms.PLAIN;
            }
            case 45: {
                return this.plainUsername;
            }
            case 46: {
                return this.plainPassword;
            }
            case 55: {
                return this.zapDomain;
            }
            case 32: {
                return this.lastEndpoint;
            }
            case 47: {
                return this.asServer && this.mechanism == Mechanisms.CURVE;
            }
            case 48: {
                return this.curvePublicKey;
            }
            case 50: {
                return this.curveServerKey;
            }
            case 49: {
                return this.curveSecretKey;
            }
            case 54: {
                return this.conflate;
            }
            case 62: {
                return this.asServer && this.mechanism == Mechanisms.GSSAPI;
            }
            case 63: {
                return this.gssPrincipal;
            }
            case 64: {
                return this.gssServicePrincipal;
            }
            case 65: {
                return this.gssPlaintext;
            }
            case 66: {
                return this.handshakeIvl;
            }
            case 1003: {
                return this.allocator;
            }
            case 1004: {
                if (this.allocator instanceof MsgAllocatorThreshold) {
                    MsgAllocatorThreshold all2 = (MsgAllocatorThreshold)this.allocator;
                    return all2.threshold;
                }
                return -1;
            }
        }
        throw new IllegalArgumentException("option=" + option2);
    }

    public static boolean parseBoolean(int option2, Object optval) {
        if (optval instanceof Boolean) {
            return (Boolean)optval;
        }
        if (optval instanceof Integer) {
            return (Integer)optval != 0;
        }
        throw new IllegalArgumentException(optval + " is neither an integer or a boolean for option " + option2);
    }

    public static String parseString(int option2, Object optval) {
        if (optval instanceof String) {
            return (String)optval;
        }
        if (optval instanceof byte[]) {
            return new String((byte[])optval, ZMQ.CHARSET);
        }
        throw new IllegalArgumentException(optval + " is neither a string or an array of bytes for option " + option2);
    }

    public static byte[] parseBytes(int option2, Object optval) {
        if (optval instanceof String) {
            return ((String)optval).getBytes(ZMQ.CHARSET);
        }
        if (optval instanceof byte[]) {
            return (byte[])optval;
        }
        throw new IllegalArgumentException(optval + " is neither a string or an array of bytes for option " + option2);
    }
}

