/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.zeromq.util.ZData;

public class ZDigest {
    private final byte[] buffer;
    private final MessageDigest sha1;

    public ZDigest() {
        this(new byte[8192]);
    }

    public ZDigest(byte[] buffer2) {
        this.buffer = buffer2;
        try {
            this.sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public ZDigest update(InputStream input) throws IOException {
        int read2 = input.read(this.buffer);
        while (read2 != -1) {
            this.sha1.update(this.buffer, 0, read2);
            read2 = input.read(this.buffer);
        }
        return this;
    }

    public ZDigest update(byte[] input) {
        return this.update(input, 0, input.length);
    }

    public ZDigest update(byte[] input, int offset, int length2) {
        this.sha1.update(input, offset, length2);
        return this;
    }

    public byte[] data() {
        return this.sha1.digest();
    }

    public int size() {
        return this.sha1.digest().length;
    }

    public String string() {
        return ZData.toString(this.data());
    }
}

