/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray.propagator;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.contrib.awsxray.propagator.AwsXrayPropagator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class AwsXrayLambdaPropagator
implements TextMapPropagator {
    private static final String AWS_TRACE_HEADER_ENV_KEY = "_X_AMZN_TRACE_ID";
    private static final String AWS_TRACE_HEADER_PROP = "com.amazonaws.xray.traceHeader";
    private final AwsXrayPropagator xrayPropagator = AwsXrayPropagator.getInstance();
    private static final AwsXrayLambdaPropagator INSTANCE = new AwsXrayLambdaPropagator();

    private AwsXrayLambdaPropagator() {
    }

    public static AwsXrayLambdaPropagator getInstance() {
        return INSTANCE;
    }

    public List<String> fields() {
        return this.xrayPropagator.fields();
    }

    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        this.xrayPropagator.inject(context, carrier, setter);
    }

    public <C> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        Context xrayContext = this.xrayPropagator.extract(context, carrier, getter);
        if (Span.fromContext((Context)context).getSpanContext().isValid()) {
            return xrayContext;
        }
        String traceHeader = System.getProperty(AWS_TRACE_HEADER_PROP);
        if (AwsXrayLambdaPropagator.isEmptyOrNull(traceHeader)) {
            traceHeader = System.getenv(AWS_TRACE_HEADER_ENV_KEY);
        }
        if (AwsXrayLambdaPropagator.isEmptyOrNull(traceHeader)) {
            return xrayContext;
        }
        return this.xrayPropagator.extract(xrayContext, Collections.singletonMap("X-Amzn-Trace-Id", traceHeader), MapGetter.INSTANCE);
    }

    public String toString() {
        return "AwsXrayLambdaPropagator";
    }

    private static boolean isEmptyOrNull(@Nullable String value) {
        return value == null || value.isEmpty();
    }

    private static enum MapGetter implements TextMapGetter<Map<String, String>>
    {
        INSTANCE;


        public Set<String> keys(Map<String, String> map) {
            return map.keySet();
        }

        @Nullable
        public String get(@Nullable Map<String, String> map, String s) {
            return map == null ? null : map.get(s);
        }
    }
}

