/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements. See the NOTICE file distributed with this
work for additional information regarding copyright ownership. The ASF
licenses this file to You under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations
under the License.
*/
// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.0
// 	protoc        v3.21.1
// source: store_common.proto

package common

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

//--- enum ---
type ResCode int32

const (
	ResCode_RES_CODE_OK        ResCode = 0
	ResCode_RES_CODE_FAIL      ResCode = 1
	ResCode_RES_CODE_NOT_EXIST ResCode = 2
)

// Enum value maps for ResCode.
var (
	ResCode_name = map[int32]string{
		0: "RES_CODE_OK",
		1: "RES_CODE_FAIL",
		2: "RES_CODE_NOT_EXIST",
	}
	ResCode_value = map[string]int32{
		"RES_CODE_OK":        0,
		"RES_CODE_FAIL":      1,
		"RES_CODE_NOT_EXIST": 2,
	}
)

func (x ResCode) Enum() *ResCode {
	p := new(ResCode)
	*p = x
	return p
}

func (x ResCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResCode) Descriptor() protoreflect.EnumDescriptor {
	return file_store_common_proto_enumTypes[0].Descriptor()
}

func (ResCode) Type() protoreflect.EnumType {
	return &file_store_common_proto_enumTypes[0]
}

func (x ResCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResCode.Descriptor instead.
func (ResCode) EnumDescriptor() ([]byte, []int) {
	return file_store_common_proto_rawDescGZIP(), []int{0}
}

type ScanMethod int32

const (
	ScanMethod_UNKNOWN_SCAN_TYPE ScanMethod = 0
	ScanMethod_ALL               ScanMethod = 1
	ScanMethod_PREFIX            ScanMethod = 2
	ScanMethod_RANGE             ScanMethod = 3
)

// Enum value maps for ScanMethod.
var (
	ScanMethod_name = map[int32]string{
		0: "UNKNOWN_SCAN_TYPE",
		1: "ALL",
		2: "PREFIX",
		3: "RANGE",
	}
	ScanMethod_value = map[string]int32{
		"UNKNOWN_SCAN_TYPE": 0,
		"ALL":               1,
		"PREFIX":            2,
		"RANGE":             3,
	}
)

func (x ScanMethod) Enum() *ScanMethod {
	p := new(ScanMethod)
	*p = x
	return p
}

func (x ScanMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ScanMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_store_common_proto_enumTypes[1].Descriptor()
}

func (ScanMethod) Type() protoreflect.EnumType {
	return &file_store_common_proto_enumTypes[1]
}

func (x ScanMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ScanMethod.Descriptor instead.
func (ScanMethod) EnumDescriptor() ([]byte, []int) {
	return file_store_common_proto_rawDescGZIP(), []int{1}
}

type ScanOrderType int32

const (
	// 批量接口下，返回顺序的要求
	ScanOrderType_ORDER_NONE          ScanOrderType = 0 // 允许无序
	ScanOrderType_ORDER_WITHIN_VERTEX ScanOrderType = 1 // 一个点内的边不会被打断，单不同点之间为无序
	ScanOrderType_ORDER_STRICT        ScanOrderType = 2 // 保证原始的输入点顺序
)

// Enum value maps for ScanOrderType.
var (
	ScanOrderType_name = map[int32]string{
		0: "ORDER_NONE",
		1: "ORDER_WITHIN_VERTEX",
		2: "ORDER_STRICT",
	}
	ScanOrderType_value = map[string]int32{
		"ORDER_NONE":          0,
		"ORDER_WITHIN_VERTEX": 1,
		"ORDER_STRICT":        2,
	}
)

func (x ScanOrderType) Enum() *ScanOrderType {
	p := new(ScanOrderType)
	*p = x
	return p
}

func (x ScanOrderType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ScanOrderType) Descriptor() protoreflect.EnumDescriptor {
	return file_store_common_proto_enumTypes[2].Descriptor()
}

func (ScanOrderType) Type() protoreflect.EnumType {
	return &file_store_common_proto_enumTypes[2]
}

func (x ScanOrderType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ScanOrderType.Descriptor instead.
func (ScanOrderType) EnumDescriptor() ([]byte, []int) {
	return file_store_common_proto_rawDescGZIP(), []int{2}
}

type OpType int32

const (
	OpType_OP_TYPE_UNKNOWN    OpType = 0
	OpType_OP_TYPE_PUT        OpType = 1
	OpType_OP_TYPE_DEL        OpType = 2
	OpType_OP_TYPE_DEL_SINGLE OpType = 3
	OpType_OP_TYPE_DEL_PREFIX OpType = 4
	OpType_OP_TYPE_DEL_RANGE  OpType = 5
	OpType_OP_TYPE_MERGE      OpType = 6
)

// Enum value maps for OpType.
var (
	OpType_name = map[int32]string{
		0: "OP_TYPE_UNKNOWN",
		1: "OP_TYPE_PUT",
		2: "OP_TYPE_DEL",
		3: "OP_TYPE_DEL_SINGLE",
		4: "OP_TYPE_DEL_PREFIX",
		5: "OP_TYPE_DEL_RANGE",
		6: "OP_TYPE_MERGE",
	}
	OpType_value = map[string]int32{
		"OP_TYPE_UNKNOWN":    0,
		"OP_TYPE_PUT":        1,
		"OP_TYPE_DEL":        2,
		"OP_TYPE_DEL_SINGLE": 3,
		"OP_TYPE_DEL_PREFIX": 4,
		"OP_TYPE_DEL_RANGE":  5,
		"OP_TYPE_MERGE":      6,
	}
)

func (x OpType) Enum() *OpType {
	p := new(OpType)
	*p = x
	return p
}

func (x OpType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OpType) Descriptor() protoreflect.EnumDescriptor {
	return file_store_common_proto_enumTypes[3].Descriptor()
}

func (OpType) Type() protoreflect.EnumType {
	return &file_store_common_proto_enumTypes[3]
}

func (x OpType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OpType.Descriptor instead.
func (OpType) EnumDescriptor() ([]byte, []int) {
	return file_store_common_proto_rawDescGZIP(), []int{3}
}

type TableMethod int32

const (
	TableMethod_TABLE_METHOD_UNKNOWN  TableMethod = 0
	TableMethod_TABLE_METHOD_EXISTS   TableMethod = 1
	TableMethod_TABLE_METHOD_CREATE   TableMethod = 2
	TableMethod_TABLE_METHOD_DELETE   TableMethod = 3
	TableMethod_TABLE_METHOD_DROP     TableMethod = 4
	TableMethod_TABLE_METHOD_TRUNCATE TableMethod = 5
)

// Enum value maps for TableMethod.
var (
	TableMethod_name = map[int32]string{
		0: "TABLE_METHOD_UNKNOWN",
		1: "TABLE_METHOD_EXISTS",
		2: "TABLE_METHOD_CREATE",
		3: "TABLE_METHOD_DELETE",
		4: "TABLE_METHOD_DROP",
		5: "TABLE_METHOD_TRUNCATE",
	}
	TableMethod_value = map[string]int32{
		"TABLE_METHOD_UNKNOWN":  0,
		"TABLE_METHOD_EXISTS":   1,
		"TABLE_METHOD_CREATE":   2,
		"TABLE_METHOD_DELETE":   3,
		"TABLE_METHOD_DROP":     4,
		"TABLE_METHOD_TRUNCATE": 5,
	}
)

func (x TableMethod) Enum() *TableMethod {
	p := new(TableMethod)
	*p = x
	return p
}

func (x TableMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TableMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_store_common_proto_enumTypes[4].Descriptor()
}

func (TableMethod) Type() protoreflect.EnumType {
	return &file_store_common_proto_enumTypes[4]
}

func (x TableMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TableMethod.Descriptor instead.
func (TableMethod) EnumDescriptor() ([]byte, []int) {
	return file_store_common_proto_rawDescGZIP(), []int{4}
}

type GraphMethod int32

const (
	GraphMethod_GRAPH_METHOD_UNKNOWN GraphMethod = 0
	GraphMethod_GRAPH_METHOD_DELETE  GraphMethod = 3
)

// Enum value maps for GraphMethod.
var (
	GraphMethod_name = map[int32]string{
		0: "GRAPH_METHOD_UNKNOWN",
		3: "GRAPH_METHOD_DELETE",
	}
	GraphMethod_value = map[string]int32{
		"GRAPH_METHOD_UNKNOWN": 0,
		"GRAPH_METHOD_DELETE":  3,
	}
)

func (x GraphMethod) Enum() *GraphMethod {
	p := new(GraphMethod)
	*p = x
	return p
}

func (x GraphMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GraphMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_store_common_proto_enumTypes[5].Descriptor()
}

func (GraphMethod) Type() protoreflect.EnumType {
	return &file_store_common_proto_enumTypes[5]
}

func (x GraphMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GraphMethod.Descriptor instead.
func (GraphMethod) EnumDescriptor() ([]byte, []int) {
	return file_store_common_proto_rawDescGZIP(), []int{5}
}

type Header struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Graph string `protobuf:"bytes,1,opt,name=graph,proto3" json:"graph,omitempty"`
}

func (x *Header) Reset() {
	*x = Header{}
	if protoimpl.UnsafeEnabled {
		mi := &file_store_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Header) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Header) ProtoMessage() {}

func (x *Header) ProtoReflect() protoreflect.Message {
	mi := &file_store_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Header.ProtoReflect.Descriptor instead.
func (*Header) Descriptor() ([]byte, []int) {
	return file_store_common_proto_rawDescGZIP(), []int{0}
}

func (x *Header) GetGraph() string {
	if x != nil {
		return x.Graph
	}
	return ""
}

type Tkv struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	Key   []byte `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	Value []byte `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	Code  int32  `protobuf:"varint,9,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *Tkv) Reset() {
	*x = Tkv{}
	if protoimpl.UnsafeEnabled {
		mi := &file_store_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tkv) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tkv) ProtoMessage() {}

func (x *Tkv) ProtoReflect() protoreflect.Message {
	mi := &file_store_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tkv.ProtoReflect.Descriptor instead.
func (*Tkv) Descriptor() ([]byte, []int) {
	return file_store_common_proto_rawDescGZIP(), []int{1}
}

func (x *Tkv) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *Tkv) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *Tkv) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Tkv) GetCode() int32 {
	if x != nil {
		return x.Code
	}
	return 0
}

type Tk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	Key   []byte `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	Code  int32  `protobuf:"varint,9,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *Tk) Reset() {
	*x = Tk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_store_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tk) ProtoMessage() {}

func (x *Tk) ProtoReflect() protoreflect.Message {
	mi := &file_store_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tk.ProtoReflect.Descriptor instead.
func (*Tk) Descriptor() ([]byte, []int) {
	return file_store_common_proto_rawDescGZIP(), []int{2}
}

func (x *Tk) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *Tk) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *Tk) GetCode() int32 {
	if x != nil {
		return x.Code
	}
	return 0
}

type Tp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Table  string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	Prefix []byte `protobuf:"bytes,2,opt,name=prefix,proto3" json:"prefix,omitempty"`
	Code   int32  `protobuf:"varint,9,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *Tp) Reset() {
	*x = Tp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_store_common_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tp) ProtoMessage() {}

func (x *Tp) ProtoReflect() protoreflect.Message {
	mi := &file_store_common_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tp.ProtoReflect.Descriptor instead.
func (*Tp) Descriptor() ([]byte, []int) {
	return file_store_common_proto_rawDescGZIP(), []int{3}
}

func (x *Tp) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *Tp) GetPrefix() []byte {
	if x != nil {
		return x.Prefix
	}
	return nil
}

func (x *Tp) GetCode() int32 {
	if x != nil {
		return x.Code
	}
	return 0
}

type Tse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	Start *Key   `protobuf:"bytes,2,opt,name=start,proto3" json:"start,omitempty"`
	End   *Key   `protobuf:"bytes,3,opt,name=end,proto3" json:"end,omitempty"`
}

func (x *Tse) Reset() {
	*x = Tse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_store_common_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tse) ProtoMessage() {}

func (x *Tse) ProtoReflect() protoreflect.Message {
	mi := &file_store_common_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tse.ProtoReflect.Descriptor instead.
func (*Tse) Descriptor() ([]byte, []int) {
	return file_store_common_proto_rawDescGZIP(), []int{4}
}

func (x *Tse) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *Tse) GetStart() *Key {
	if x != nil {
		return x.Start
	}
	return nil
}

func (x *Tse) GetEnd() *Key {
	if x != nil {
		return x.End
	}
	return nil
}

type Key struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key  []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Code int32  `protobuf:"varint,9,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *Key) Reset() {
	*x = Key{}
	if protoimpl.UnsafeEnabled {
		mi := &file_store_common_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Key) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Key) ProtoMessage() {}

func (x *Key) ProtoReflect() protoreflect.Message {
	mi := &file_store_common_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Key.ProtoReflect.Descriptor instead.
func (*Key) Descriptor() ([]byte, []int) {
	return file_store_common_proto_rawDescGZIP(), []int{5}
}

func (x *Key) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *Key) GetCode() int32 {
	if x != nil {
		return x.Code
	}
	return 0
}

type Kv struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	Code  int32  `protobuf:"varint,9,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *Kv) Reset() {
	*x = Kv{}
	if protoimpl.UnsafeEnabled {
		mi := &file_store_common_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Kv) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Kv) ProtoMessage() {}

func (x *Kv) ProtoReflect() protoreflect.Message {
	mi := &file_store_common_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Kv.ProtoReflect.Descriptor instead.
func (*Kv) Descriptor() ([]byte, []int) {
	return file_store_common_proto_rawDescGZIP(), []int{6}
}

func (x *Kv) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *Kv) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Kv) GetCode() int32 {
	if x != nil {
		return x.Code
	}
	return 0
}

type ResStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Code ResCode `protobuf:"varint,1,opt,name=code,proto3,enum=ResCode" json:"code,omitempty"`
	Msg  string  `protobuf:"bytes,2,opt,name=msg,proto3" json:"msg,omitempty"`
}

func (x *ResStatus) Reset() {
	*x = ResStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_store_common_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResStatus) ProtoMessage() {}

func (x *ResStatus) ProtoReflect() protoreflect.Message {
	mi := &file_store_common_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResStatus.ProtoReflect.Descriptor instead.
func (*ResStatus) Descriptor() ([]byte, []int) {
	return file_store_common_proto_rawDescGZIP(), []int{7}
}

func (x *ResStatus) GetCode() ResCode {
	if x != nil {
		return x.Code
	}
	return ResCode_RES_CODE_OK
}

func (x *ResStatus) GetMsg() string {
	if x != nil {
		return x.Msg
	}
	return ""
}

var File_store_common_proto protoreflect.FileDescriptor

var file_store_common_proto_rawDesc = []byte{
	0x0a, 0x12, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x1e, 0x0a, 0x06, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x14,
	0x0a, 0x05, 0x67, 0x72, 0x61, 0x70, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x67,
	0x72, 0x61, 0x70, 0x68, 0x22, 0x57, 0x0a, 0x03, 0x54, 0x6b, 0x76, 0x12, 0x14, 0x0a, 0x05, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x22, 0x40, 0x0a,
	0x02, 0x54, 0x6b, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x22,
	0x46, 0x0a, 0x02, 0x54, 0x70, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x22, 0x4f, 0x0a, 0x03, 0x54, 0x73, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x04, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x12, 0x16, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x04, 0x2e,
	0x4b, 0x65, 0x79, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x22, 0x2b, 0x0a, 0x03, 0x4b, 0x65, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x04, 0x63, 0x6f, 0x64, 0x65, 0x22, 0x40, 0x0a, 0x02, 0x4b, 0x76, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x22, 0x3b, 0x0a, 0x09, 0x52, 0x65, 0x73, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x1c, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x08, 0x2e, 0x52, 0x65, 0x73, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f,
	0x64, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x73, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6d, 0x73, 0x67, 0x2a, 0x45, 0x0a, 0x07, 0x52, 0x65, 0x73, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x53, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x4f, 0x4b, 0x10, 0x00,
	0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x53, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x46, 0x41, 0x49,
	0x4c, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x53, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f,
	0x4e, 0x4f, 0x54, 0x5f, 0x45, 0x58, 0x49, 0x53, 0x54, 0x10, 0x02, 0x2a, 0x43, 0x0a, 0x0a, 0x53,
	0x63, 0x61, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x15, 0x0a, 0x11, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x53, 0x43, 0x41, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x00,
	0x12, 0x07, 0x0a, 0x03, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x52, 0x45,
	0x46, 0x49, 0x58, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x41, 0x4e, 0x47, 0x45, 0x10, 0x03,
	0x2a, 0x4a, 0x0a, 0x0d, 0x53, 0x63, 0x61, 0x6e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x0e, 0x0a, 0x0a, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10,
	0x00, 0x12, 0x17, 0x0a, 0x13, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x49,
	0x4e, 0x5f, 0x56, 0x45, 0x52, 0x54, 0x45, 0x58, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x4f, 0x52,
	0x44, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54, 0x10, 0x02, 0x2a, 0x99, 0x01, 0x0a,
	0x06, 0x4f, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x13, 0x0a, 0x0f, 0x4f, 0x50, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b,
	0x4f, 0x50, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x55, 0x54, 0x10, 0x01, 0x12, 0x0f, 0x0a,
	0x0b, 0x4f, 0x50, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x4c, 0x10, 0x02, 0x12, 0x16,
	0x0a, 0x12, 0x4f, 0x50, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x4c, 0x5f, 0x53, 0x49,
	0x4e, 0x47, 0x4c, 0x45, 0x10, 0x03, 0x12, 0x16, 0x0a, 0x12, 0x4f, 0x50, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x44, 0x45, 0x4c, 0x5f, 0x50, 0x52, 0x45, 0x46, 0x49, 0x58, 0x10, 0x04, 0x12, 0x15,
	0x0a, 0x11, 0x4f, 0x50, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x4c, 0x5f, 0x52, 0x41,
	0x4e, 0x47, 0x45, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d, 0x4f, 0x50, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x10, 0x06, 0x2a, 0xa4, 0x01, 0x0a, 0x0b, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x18, 0x0a, 0x14, 0x54, 0x41, 0x42, 0x4c,
	0x45, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e,
	0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x48,
	0x4f, 0x44, 0x5f, 0x45, 0x58, 0x49, 0x53, 0x54, 0x53, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x54,
	0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x43, 0x52, 0x45, 0x41,
	0x54, 0x45, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4d, 0x45,
	0x54, 0x48, 0x4f, 0x44, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x03, 0x12, 0x15, 0x0a,
	0x11, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x44, 0x52,
	0x4f, 0x50, 0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4d, 0x45,
	0x54, 0x48, 0x4f, 0x44, 0x5f, 0x54, 0x52, 0x55, 0x4e, 0x43, 0x41, 0x54, 0x45, 0x10, 0x05, 0x2a,
	0x40, 0x0a, 0x0b, 0x47, 0x72, 0x61, 0x70, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x18,
	0x0a, 0x14, 0x47, 0x52, 0x41, 0x50, 0x48, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55,
	0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x47, 0x52, 0x41, 0x50,
	0x48, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10,
	0x03, 0x42, 0x5b, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x62, 0x61, 0x69, 0x64, 0x75, 0x2e, 0x68,
	0x75, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67,
	0x72, 0x70, 0x63, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x42, 0x12, 0x48, 0x67, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x1c, 0x2f, 0x68, 0x75, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2d, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2d, 0x67, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_store_common_proto_rawDescOnce sync.Once
	file_store_common_proto_rawDescData = file_store_common_proto_rawDesc
)

func file_store_common_proto_rawDescGZIP() []byte {
	file_store_common_proto_rawDescOnce.Do(func() {
		file_store_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_store_common_proto_rawDescData)
	})
	return file_store_common_proto_rawDescData
}

var file_store_common_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_store_common_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_store_common_proto_goTypes = []interface{}{
	(ResCode)(0),       // 0: ResCode
	(ScanMethod)(0),    // 1: ScanMethod
	(ScanOrderType)(0), // 2: ScanOrderType
	(OpType)(0),        // 3: OpType
	(TableMethod)(0),   // 4: TableMethod
	(GraphMethod)(0),   // 5: GraphMethod
	(*Header)(nil),     // 6: Header
	(*Tkv)(nil),        // 7: Tkv
	(*Tk)(nil),         // 8: Tk
	(*Tp)(nil),         // 9: Tp
	(*Tse)(nil),        // 10: Tse
	(*Key)(nil),        // 11: Key
	(*Kv)(nil),         // 12: Kv
	(*ResStatus)(nil),  // 13: ResStatus
}
var file_store_common_proto_depIdxs = []int32{
	11, // 0: Tse.start:type_name -> Key
	11, // 1: Tse.end:type_name -> Key
	0,  // 2: ResStatus.code:type_name -> ResCode
	3,  // [3:3] is the sub-list for method output_type
	3,  // [3:3] is the sub-list for method input_type
	3,  // [3:3] is the sub-list for extension type_name
	3,  // [3:3] is the sub-list for extension extendee
	0,  // [0:3] is the sub-list for field type_name
}

func init() { file_store_common_proto_init() }
func file_store_common_proto_init() {
	if File_store_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_store_common_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Header); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_store_common_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Tkv); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_store_common_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Tk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_store_common_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Tp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_store_common_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Tse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_store_common_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Key); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_store_common_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Kv); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_store_common_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_store_common_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_store_common_proto_goTypes,
		DependencyIndexes: file_store_common_proto_depIdxs,
		EnumInfos:         file_store_common_proto_enumTypes,
		MessageInfos:      file_store_common_proto_msgTypes,
	}.Build()
	File_store_common_proto = out.File
	file_store_common_proto_rawDesc = nil
	file_store_common_proto_goTypes = nil
	file_store_common_proto_depIdxs = nil
}
