/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.Schema;
import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.view.PropertiesUpdate;
import org.apache.iceberg.view.ReplaceViewVersion;
import org.apache.iceberg.view.SQLViewRepresentation;
import org.apache.iceberg.view.SetViewLocation;
import org.apache.iceberg.view.UpdateViewProperties;
import org.apache.iceberg.view.View;
import org.apache.iceberg.view.ViewHistoryEntry;
import org.apache.iceberg.view.ViewOperations;
import org.apache.iceberg.view.ViewRepresentation;
import org.apache.iceberg.view.ViewVersion;
import org.apache.iceberg.view.ViewVersionReplace;

public class BaseView
implements View,
Serializable {
    private final ViewOperations ops;
    private final String name;

    public BaseView(ViewOperations ops, String name) {
        this.ops = ops;
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public ViewOperations operations() {
        return this.ops;
    }

    public Schema schema() {
        return this.operations().current().schema();
    }

    public Map<Integer, Schema> schemas() {
        return this.operations().current().schemasById();
    }

    public ViewVersion currentVersion() {
        return this.operations().current().currentVersion();
    }

    public Iterable<ViewVersion> versions() {
        return this.operations().current().versions();
    }

    public ViewVersion version(int versionId) {
        return this.operations().current().version(versionId);
    }

    public List<ViewHistoryEntry> history() {
        return this.operations().current().history();
    }

    public Map<String, String> properties() {
        return this.operations().current().properties();
    }

    public String location() {
        return this.operations().current().location();
    }

    public UpdateViewProperties updateProperties() {
        return new PropertiesUpdate(this.ops);
    }

    public ReplaceViewVersion replaceVersion() {
        return new ViewVersionReplace(this.ops);
    }

    public UpdateLocation updateLocation() {
        return new SetViewLocation(this.ops);
    }

    public UUID uuid() {
        return UUID.fromString(this.ops.current().uuid());
    }

    public SQLViewRepresentation sqlFor(String dialect) {
        Preconditions.checkArgument((dialect != null ? 1 : 0) != 0, (Object)"Invalid dialect: null");
        Preconditions.checkArgument((!dialect.isEmpty() ? 1 : 0) != 0, (Object)"Invalid dialect: (empty string)");
        SQLViewRepresentation closest = null;
        for (ViewRepresentation representation : this.currentVersion().representations()) {
            if (!(representation instanceof SQLViewRepresentation)) continue;
            SQLViewRepresentation sqlViewRepresentation = (SQLViewRepresentation)representation;
            if (sqlViewRepresentation.dialect().equalsIgnoreCase(dialect)) {
                return sqlViewRepresentation;
            }
            if (closest != null) continue;
            closest = sqlViewRepresentation;
        }
        return closest;
    }
}

