/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.messaging;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.gravitino.Audit;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.messaging.Topic;

public class TopicDTO
implements Topic {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="properties")
    private Map<String, String> properties;
    @JsonProperty(value="audit")
    private AuditDTO audit;

    public static Builder builder() {
        return new Builder();
    }

    private TopicDTO() {
    }

    private TopicDTO(String name, String comment, Map<String, String> properties, AuditDTO audit) {
        this.name = name;
        this.comment = comment;
        this.properties = properties;
        this.audit = audit;
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public String comment() {
        return this.comment;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public Audit auditInfo() {
        return this.audit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Topic)) {
            return false;
        }
        TopicDTO topicDTO = (TopicDTO)o;
        return Objects.equals(this.name, topicDTO.name) && Objects.equals(this.comment, topicDTO.comment) && Objects.equals(this.properties, topicDTO.properties) && Objects.equals(this.audit, topicDTO.audit);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.comment, this.properties, this.audit);
    }

    public String toString() {
        return "TopicDTO{name='" + this.name + '\'' + ", comment='" + this.comment + '\'' + ", properties=" + this.properties + ", audit=" + this.audit + '}';
    }

    public static class Builder {
        private String name;
        private String comment;
        private Map<String, String> properties;
        private AuditDTO audit;

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder withAudit(AuditDTO audit) {
            this.audit = audit;
            return this;
        }

        public TopicDTO build() {
            return new TopicDTO(this.name, this.comment, this.properties, this.audit);
        }
    }
}

