/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.connector.capability;

import com.google.common.base.Preconditions;
import org.apache.gravitino.annotation.Evolving;

@Evolving
public interface CapabilityResult {
    public static final CapabilityResult SUPPORTED = new ResultImpl(true, null);

    public static CapabilityResult unsupported(String unsupportedMessage) {
        return new ResultImpl(false, unsupportedMessage);
    }

    public boolean supported();

    public String unsupportedMessage();

    public static class ResultImpl
    implements CapabilityResult {
        private final boolean supported;
        private final String unsupportedMessage;

        private ResultImpl(boolean supported, String unsupportedMessage) {
            Preconditions.checkArgument((supported || unsupportedMessage != null ? 1 : 0) != 0, (Object)"unsupportedReason is required when supportsNotNull is false");
            this.supported = supported;
            this.unsupportedMessage = unsupportedMessage;
        }

        @Override
        public boolean supported() {
            return this.supported;
        }

        @Override
        public String unsupportedMessage() {
            return this.unsupportedMessage;
        }
    }
}

