/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx;

import java.util.UUID;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.TxStateMeta;
import org.apache.ignite3.internal.tx.message.TxMessagesFactory;
import org.apache.ignite3.internal.tx.message.TxStateMetaAbandonedMessage;
import org.apache.ignite3.internal.util.FastTimestamps;

public class TxStateMetaAbandoned
extends TxStateMeta {
    private static final long serialVersionUID = 8521181896862227127L;
    private final long lastAbandonedMarkerTs = FastTimestamps.coarseCurrentTimeMillis();

    public TxStateMetaAbandoned(UUID txCoordinatorId, ReplicationGroupId commitPartitionId) {
        super(TxState.ABANDONED, txCoordinatorId, commitPartitionId, null, null, null);
    }

    public long lastAbandonedMarkerTs() {
        return this.lastAbandonedMarkerTs;
    }

    @Override
    public TxStateMetaAbandonedMessage toTransactionMetaMessage(ReplicaMessagesFactory replicaMessagesFactory, TxMessagesFactory txMessagesFactory) {
        ReplicationGroupId commitPartitionId = this.commitPartitionId();
        return txMessagesFactory.txStateMetaAbandonedMessage().txState(this.txState()).txCoordinatorId(this.txCoordinatorId()).commitPartitionId(commitPartitionId == null ? null : ReplicaMessageUtils.toReplicationGroupIdMessage(replicaMessagesFactory, commitPartitionId)).commitTimestamp(this.commitTimestamp()).initialVacuumObservationTimestamp(this.initialVacuumObservationTimestamp()).cleanupCompletionTimestamp(this.cleanupCompletionTimestamp()).lastAbandonedMarkerTs(this.lastAbandonedMarkerTs).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TxStateMetaAbandoned that = (TxStateMetaAbandoned)o;
        return this.lastAbandonedMarkerTs == that.lastAbandonedMarkerTs;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Long.hashCode(this.lastAbandonedMarkerTs);
        return result;
    }

    @Override
    public String toString() {
        return S.toString(TxStateMetaAbandoned.class, this);
    }
}

