/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.picocli;

import io.micronaut.configuration.picocli.MicronautFactory;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.env.CommandLinePropertySource;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.cli.CommandLine;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@TypeHint(value={System.class, Executable.class, Parameter.class, ResourceBundle.class, Path.class, Paths.class}, typeNames={"picocli.CommandLine$AutoHelpMixin", "picocli.CommandLine$Model$CommandSpec"}, accessType={TypeHint.AccessType.ALL_DECLARED_FIELDS, TypeHint.AccessType.ALL_PUBLIC_METHODS, TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS})
public class PicocliRunner {
    public static <C extends Callable<T>, T> T call(Class<C> cls, String ... args) {
        try (ApplicationContext ctx = ApplicationContext.builder(cls, (String[])new String[]{"cli"}).start();){
            T t = PicocliRunner.call(cls, ctx, args);
            return t;
        }
    }

    public static <C extends Callable<T>, T> T call(Class<C> cls, ApplicationContext ctx, String ... args) {
        picocli.CommandLine commandLine = new picocli.CommandLine(cls, (CommandLine.IFactory)new MicronautFactory(ctx));
        commandLine.execute(args);
        return (T)commandLine.getExecutionResult();
    }

    public static <R extends Runnable> void run(Class<R> cls, String ... args) {
        ApplicationContextBuilder builder = PicocliRunner.buildApplicationContext(cls, args);
        try (ApplicationContext ctx = builder.start();){
            PicocliRunner.run(cls, ctx, args);
        }
    }

    public static <R extends Runnable> void run(Class<R> cls, ApplicationContext ctx, String ... args) {
        picocli.CommandLine commandLine = new picocli.CommandLine(cls, (CommandLine.IFactory)new MicronautFactory(ctx));
        commandLine.execute(args);
    }

    public static int execute(Class<?> clazz, String ... args) {
        ApplicationContextBuilder builder = PicocliRunner.buildApplicationContext(clazz, args);
        try (ApplicationContext context = builder.start();){
            int n = PicocliRunner.execute(clazz, context, args);
            return n;
        }
    }

    private static int execute(Class<?> clazz, ApplicationContext context, String ... args) {
        return new picocli.CommandLine(clazz, (CommandLine.IFactory)new MicronautFactory(context)).execute(args);
    }

    private static ApplicationContextBuilder buildApplicationContext(Class<?> cls, String[] args) {
        CommandLine commandLine = CommandLine.parse((String[])args);
        CommandLinePropertySource commandLinePropertySource = new CommandLinePropertySource(commandLine);
        return ApplicationContext.builder(cls, (String[])new String[]{"cli"}).propertySources(new PropertySource[]{commandLinePropertySource});
    }
}

