/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.gossip;

import io.scalecube.cluster.gossip.Gossip;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

final class GossipRequest
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private List<Gossip> gossips;
    private String from;

    public GossipRequest() {
    }

    public GossipRequest(Gossip gossip, String from) {
        this(Collections.singletonList(gossip), from);
    }

    public GossipRequest(List<Gossip> gossips, String from) {
        Objects.requireNonNull(gossips);
        Objects.requireNonNull(from);
        this.gossips = Collections.unmodifiableList(new ArrayList<Gossip>(gossips));
        this.from = from;
    }

    public List<Gossip> gossips() {
        return this.gossips;
    }

    public String from() {
        return this.from;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.gossips.size());
        for (Gossip gossip : this.gossips) {
            out.writeObject(gossip);
        }
        out.writeUTF(this.from);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int gossipsSize = in.readInt();
        ArrayList<Gossip> gossips = new ArrayList<Gossip>(gossipsSize);
        for (int i = 0; i < gossipsSize; ++i) {
            gossips.add((Gossip)in.readObject());
        }
        this.gossips = Collections.unmodifiableList(gossips);
        this.from = in.readUTF();
    }

    public String toString() {
        return new StringJoiner(", ", GossipRequest.class.getSimpleName() + "[", "]").add("gossips=" + this.gossips).add("from='" + this.from + "'").toString();
    }
}

