/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.cors;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ImmutableArgumentConversionContext;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.value.ConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.server.cors.CorsOriginConfiguration;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Singleton
public class CorsOriginConverter
implements TypeConverter<Map<String, Object>, CorsOriginConfiguration> {
    private static final String ALLOWED_ORIGINS = "allowed-origins";
    private static final String ALLOWED_ORIGINS_REGEX = "allowed-origins-regex";
    private static final String ALLOWED_METHODS = "allowed-methods";
    private static final String ALLOWED_HEADERS = "allowed-headers";
    private static final String EXPOSED_HEADERS = "exposed-headers";
    private static final String ALLOW_CREDENTIALS = "allow-credentials";
    private static final String MAX_AGE = "max-age";
    private static final ArgumentConversionContext<List<HttpMethod>> CONVERSION_CONTEXT_LIST_OF_HTTP_METHOD = ImmutableArgumentConversionContext.of((Argument)Argument.listOf(HttpMethod.class));

    public Optional<CorsOriginConfiguration> convert(Map<String, Object> object, Class<CorsOriginConfiguration> targetType, ConversionContext context) {
        CorsOriginConfiguration configuration = new CorsOriginConfiguration();
        ConvertibleValuesMap convertibleValues = new ConvertibleValuesMap(object);
        convertibleValues.get((CharSequence)ALLOWED_ORIGINS, ConversionContext.LIST_OF_STRING).ifPresent(configuration::setAllowedOrigins);
        convertibleValues.get((CharSequence)ALLOWED_ORIGINS_REGEX, ConversionContext.STRING).ifPresent(configuration::setAllowedOriginsRegex);
        convertibleValues.get((CharSequence)ALLOWED_METHODS, CONVERSION_CONTEXT_LIST_OF_HTTP_METHOD).ifPresent(configuration::setAllowedMethods);
        convertibleValues.get((CharSequence)ALLOWED_HEADERS, ConversionContext.LIST_OF_STRING).ifPresent(configuration::setAllowedHeaders);
        convertibleValues.get((CharSequence)EXPOSED_HEADERS, ConversionContext.LIST_OF_STRING).ifPresent(configuration::setExposedHeaders);
        convertibleValues.get((CharSequence)ALLOW_CREDENTIALS, ConversionContext.BOOLEAN).ifPresent(configuration::setAllowCredentials);
        convertibleValues.get((CharSequence)MAX_AGE, ConversionContext.LONG).ifPresent(configuration::setMaxAge);
        return Optional.of(configuration);
    }
}

