/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.io.Serializable;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;

public class HostAndPort
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final String host;
    private final int port;

    public static HostAndPort parse(String addrStr, int dfltPort, String errMsgPrefix) throws IgniteException {
        int port;
        String host;
        if (addrStr == null || addrStr.isEmpty()) {
            throw HostAndPort.createParseError(addrStr, errMsgPrefix, "Address is empty");
        }
        if (addrStr.charAt(0) == '[') {
            int hostEndIdx = addrStr.indexOf(93);
            if (hostEndIdx == -1) {
                throw HostAndPort.createParseError(addrStr, errMsgPrefix, "Failed to parse IPv6 address, missing ']'");
            }
            host = addrStr.substring(1, hostEndIdx);
            if (hostEndIdx == addrStr.length() - 1) {
                port = dfltPort;
            } else {
                String portStr = addrStr.substring(hostEndIdx + 2);
                port = HostAndPort.parsePort(portStr, addrStr, errMsgPrefix);
            }
        } else {
            int colIdx = addrStr.lastIndexOf(58);
            if (colIdx > 0) {
                if (addrStr.lastIndexOf(58, colIdx - 1) != -1) {
                    try {
                        Inet6Address.getByName(addrStr);
                        host = addrStr;
                        port = dfltPort;
                    }
                    catch (UnknownHostException e) {
                        throw HostAndPort.createParseError(addrStr, errMsgPrefix, "IPv6 is incorrect", e);
                    }
                } else {
                    host = addrStr.substring(0, colIdx);
                    String portStr = addrStr.substring(colIdx + 1);
                    port = HostAndPort.parsePort(portStr, addrStr, errMsgPrefix);
                }
            } else {
                if (colIdx == 0) {
                    throw HostAndPort.createParseError(addrStr, errMsgPrefix, "Host name is empty");
                }
                host = addrStr;
                port = dfltPort;
            }
        }
        return new HostAndPort(host, port);
    }

    private static int parsePort(String portStr, String addrStr, String errMsgPrefix) {
        try {
            int port = Integer.parseInt(portStr);
            if (port <= 0 || port > 65535) {
                throw HostAndPort.createParseError(addrStr, errMsgPrefix, "invalid port " + portStr);
            }
            return port;
        }
        catch (NumberFormatException ignored) {
            throw HostAndPort.createParseError(addrStr, errMsgPrefix, "invalid port " + portStr);
        }
    }

    private static RuntimeException createParseError(String addrStr, String errMsgPrefix, String errMsg) {
        return new IgniteException(ErrorGroups.Client.CONFIGURATION_ERR, errMsgPrefix + " (" + errMsg + "): " + addrStr);
    }

    private static RuntimeException createParseError(String addrStr, String errMsgPrefix, String errMsg, Throwable cause) {
        return new IgniteException(ErrorGroups.Client.CONFIGURATION_ERR, errMsgPrefix + " (" + errMsg + "): " + addrStr, cause);
    }

    public HostAndPort(String host, int port) {
        assert (host != null && !host.isEmpty());
        this.host = host;
        this.port = port;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (o instanceof HostAndPort) {
            HostAndPort other = (HostAndPort)o;
            return this.host.equals(other.host) && this.port == other.port;
        }
        return false;
    }

    public int hashCode() {
        int res = this.host.hashCode();
        res = 31 * res + this.port;
        return res;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }
}

