<!--
  ~ Licensed to the Apache Software Foundation (ASF) under one
  ~ or more contributor license agreements.  See the NOTICE file
  ~ distributed with this work for additional information
  ~ regarding copyright ownership.  The ASF licenses this file
  ~ to you under the Apache License, Version 2.0 (the
  ~ "License"); you may not use this file except in compliance
  ~ with the License.  You may obtain a copy of the License at
  ~
  ~   http://www.apache.org/licenses/LICENSE-2.0
  ~
  ~ Unless required by applicable law or agreed to in writing,
  ~ software distributed under the License is distributed on an
  ~ "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  ~ KIND, either express or implied.  See the License for the
  ~ specific language governing permissions and limitations
  ~ under the License.
-->

# Changelog

All notable changes to this project will be documented in this file.

## [0.1.0] - 2024-07-15

### 🚀 Features

- Initial rust implementation to integrate with datafusion (#1) by @xushiyan
- Add python binding (#21) by @xushiyan
- Implement `HudiTable` as python API (#23) by @xushiyan
- Use `object_store` for common storage APIs (#25) by @xushiyan
- Implement Rust and Python APIs to read file slices (#28) by @xushiyan
- Add APIs for time-travel read (#33) by @xushiyan
- Implement datafusion API using ParquetExec (#35) by @xushiyan
- Add `HudiConfigs` for parsing and managing named configs (#37) by @xushiyan
- Add config validation when creating table (#49) by @xushiyan
- Add internal config to skip validation (#51) by @xushiyan
- Support time travel with read option (#52) by @xushiyan
- Support taking env vars for cloud storages (#55) by @xushiyan

### 🐛 Bug Fixes

- Handle replacecommit for loading file slices (#53) by @xushiyan

### 🚜 Refactor

- Use `anyhow` for generic errors (#26) by @xushiyan
- Use `object_store` API for Timeline (#27) by @xushiyan
- Make APIs async (#31) by @xushiyan
- Improve thread safety and error handling (#32) by @xushiyan
- Improve error handling in storage module (#34) by @xushiyan
- Adjust table APIs to skip passing options (#56) by @xushiyan

### 📚 Documentation

- Update readme, contributing guide, and issue template (#57) by @xushiyan
- Update CONTRIBUTING with minor changes (#58) by @codope

### 🎨 Styling

- Enforce rust code style (#14) by @xushiyan

### 🛠️ Build

- Clean up and trim down dependencies (#54) by @xushiyan
- Add info for rust and python artifacts (#60) by @xushiyan
- Add release workflow (#63) by @xushiyan

### 🧪 Testing

- Add tests crate and adopt testing tables (#30) by @xushiyan
- Add test cases for different table setup (#36) by @xushiyan

### ⚙️ Miscellaneous Tasks

- Setup ci for license file and headers (#2) by @xushiyan
- Fix failing check and test case (#10) by @xushiyan
- Fix asf notification (#11) by @xushiyan
- Add commit linting (#12) by @xushiyan
- Use cargo tarpaulin to generate code coverage (#15) by @xushiyan
- Remove codecov to keep ci green (#17) by @xushiyan
- Fix codecov setup (#20) by @xushiyan
- Configure codecov (#50) by @xushiyan
- Add scripts to streamline source release (#64) by @xushiyan

## New Contributors

* @codope made their first contribution in #58
* @xushiyan made their first contribution in #1

<!-- generated by git-cliff -->
