/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.concurrent;

import java.util.concurrent.Future;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.concurrent.FutureContribution;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestComplexFuture {
    TestComplexFuture() {
    }

    @Test
    void testCancelled() {
        ComplexFuture future = new ComplexFuture(null);
        BasicFuture dependency1 = new BasicFuture(null);
        future.setDependency((Future)dependency1);
        Assertions.assertFalse((boolean)future.isDone());
        future.cancel();
        MatcherAssert.assertThat((Object)future.isCancelled(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)dependency1.isCancelled(), (Matcher)CoreMatchers.is((Object)true));
        BasicFuture dependency2 = new BasicFuture(null);
        future.setDependency((Future)dependency2);
        MatcherAssert.assertThat((Object)dependency2.isCancelled(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void testCompleted() {
        ComplexFuture future = new ComplexFuture(null);
        BasicFuture dependency1 = new BasicFuture(null);
        future.setDependency((Future)dependency1);
        Assertions.assertFalse((boolean)future.isDone());
        future.completed((Object)Boolean.TRUE);
        MatcherAssert.assertThat((Object)future.isCancelled(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)dependency1.isCancelled(), (Matcher)CoreMatchers.is((Object)false));
        BasicFuture dependency2 = new BasicFuture(null);
        future.setDependency((Future)dependency2);
        MatcherAssert.assertThat((Object)dependency2.isCancelled(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void testCancelledWithCallback() {
        ComplexFuture future = new ComplexFuture(null);
        BasicFuture dependency1 = new BasicFuture((FutureCallback)new FutureContribution<Object>((BasicFuture)future){

            public void completed(Object result) {
            }
        });
        future.setDependency((Future)dependency1);
        Assertions.assertFalse((boolean)future.isDone());
        future.cancel();
        MatcherAssert.assertThat((Object)future.isCancelled(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)dependency1.isCancelled(), (Matcher)CoreMatchers.is((Object)true));
        BasicFuture dependency2 = new BasicFuture(null);
        future.setDependency((Future)dependency2);
        MatcherAssert.assertThat((Object)dependency2.isCancelled(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void testCanceledAndFailed() {
        ComplexFuture future = new ComplexFuture(null);
        MatcherAssert.assertThat((Object)future.cancel(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)future.failed(new Exception()), (Matcher)CoreMatchers.is((Object)false));
    }
}

