/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.serde2.io.TimestampLocalTZWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampLocalTZObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.iceberg.mr.hive.serde.objectinspector.WriteObjectInspector;

public class IcebergTimestampWithZoneObjectInspectorHive3
extends AbstractPrimitiveJavaObjectInspector
implements TimestampLocalTZObjectInspector,
WriteObjectInspector {
    private static final IcebergTimestampWithZoneObjectInspectorHive3 INSTANCE = new IcebergTimestampWithZoneObjectInspectorHive3();

    public static IcebergTimestampWithZoneObjectInspectorHive3 get() {
        return INSTANCE;
    }

    private IcebergTimestampWithZoneObjectInspectorHive3() {
        super((PrimitiveTypeInfo)TypeInfoFactory.timestampLocalTZTypeInfo);
    }

    @Override
    public OffsetDateTime convert(Object o) {
        if (o == null) {
            return null;
        }
        ZonedDateTime zdt = ((TimestampTZ)o).getZonedDateTime();
        return OffsetDateTime.of(zdt.toLocalDateTime(), zdt.getOffset());
    }

    public TimestampTZ getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        OffsetDateTime odt = (OffsetDateTime)o;
        ZonedDateTime zdt = odt.atZoneSameInstant(((TimestampLocalTZTypeInfo)this.typeInfo).getTimeZone());
        return new TimestampTZ(zdt);
    }

    public TimestampLocalTZWritable getPrimitiveWritableObject(Object o) {
        TimestampTZ tsTz = this.getPrimitiveJavaObject(o);
        return tsTz == null ? null : new TimestampLocalTZWritable(tsTz);
    }

    public Object copyObject(Object o) {
        if (o instanceof TimestampTZ) {
            TimestampTZ ts = (TimestampTZ)o;
            return new TimestampTZ(ts.getZonedDateTime());
        }
        if (o instanceof OffsetDateTime) {
            OffsetDateTime odt = (OffsetDateTime)o;
            return OffsetDateTime.of(odt.toLocalDateTime(), odt.getOffset());
        }
        return o;
    }
}

